/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.portrait.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.portrait.CreditBalanceIndexInfo;
import com.kingdee.eas.scm.framework.portrait.PortraitType;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitException;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitIndexCollection;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitIndexFactory;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitIndexInfo;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitLogFactory;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitLogInfo;
import com.kingdee.eas.scm.framework.portrait.app.AbstractSCMPortraitIndexControllerBean;
import com.kingdee.eas.scm.framework.portrait.util.SCMPortraitUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SCMPortraitIndexControllerBean
extends AbstractSCMPortraitIndexControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.portrait.app.SCMPortraitIndexControllerBean");
    private String RESOURCE = "com.kingdee.eas.scm.framework.portrait.SCMPortraitResource";
    private static String[] keyWords = new String[]{"SELECT.*INTO.*FROM", "/\\*\\s*DIALECT\\s*\\*/"};
    public static final String SELECT_KEYWORD = "SELECT.*FROM";
    public static final String PATTERN_1 = "(FROM|JOIN)\\s+(\\w+)";
    public static final String PATTERN_2 = "(FROM)\\s+(\\w+\\s*(AS)?\\s*\\w*\\s*,\\s*)+\\w+";
    private CreditBalanceIndexInfo creditBalance = null;

    @Override
    protected Map _executeSql(Context ctx, String sqlText, PortraitType indexType, String cuID, String instanceID, String instanceDetail) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection con = null;
        if (StringUtils.isEmpty((String)sqlText)) {
            return map;
        }
        try {
            this.checkBeforeExecuteSql(ctx, sqlText, indexType);
            con = EJBFactory.getConnection((Context)ctx);
            if (this.creditBalance != null) {
                sqlText = sqlText.replace("creditTempTable", this.creditBalance.getCreditTempTable());
            }
            sqlText = SCMPortraitUtil.evalFunction(sqlText);
            RptRowSet rptRowSet = DBUtils.executeQuery((String)sqlText, null, (int)0, (int)10, (Connection)con);
            this.writeLog(ctx, sqlText, cuID, instanceID, instanceDetail);
            map.put("result", rptRowSet);
            String[] columnNames = rptRowSet.getColumnNames();
            RptTableHeader header = new RptTableHeader();
            RptTableColumn col = null;
            Object[][] labels = new Object[1][columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                col = new RptTableColumn(columnNames[i]);
                col.setWidth(100);
                header.addColumn(col);
                labels[0][i] = columnNames[i];
            }
            header.setLabels(labels, true);
            map.put("header", header);
            map.put("columns", columnNames);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                if (this.creditBalance != null) {
                    this.creditBalance.releaseTempTable();
                    this.creditBalance = null;
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        if (this.creditBalance != null) {
            this.creditBalance.releaseTempTable();
            this.creditBalance = null;
        }
        return map;
    }

    private void checkBeforeExecuteSql(Context ctx, String sqlText, PortraitType indexType) throws SCMPortraitException, BOSException {
        sqlText = sqlText.replaceAll("\n", " ");
        String upperSql = sqlText.toUpperCase();
        this.checkSqlKeyWord(upperSql);
        this.checkTableNameWhiteList(ctx, upperSql);
        this.checkIndexTypeKeyWord(indexType, upperSql);
    }

    private void checkSqlKeyWord(String upperSql) throws SCMPortraitException {
        Object pattern = null;
        Matcher matcher = null;
        matcher = Pattern.compile(SELECT_KEYWORD).matcher(upperSql);
        if (!matcher.find()) {
            throw new SCMPortraitException(SCMPortraitException.ILLEGALSQL);
        }
        int start = matcher.start();
        if (start != 0 && !StringUtils.isEmpty((String)upperSql.substring(0, start - 1).trim())) {
            throw new SCMPortraitException(SCMPortraitException.ILLEGALSQL);
        }
        for (String keyWord : keyWords) {
            matcher = Pattern.compile(keyWord).matcher(upperSql);
            if (!matcher.find()) continue;
            throw new SCMPortraitException(SCMPortraitException.ILLEGALSQL);
        }
    }

    private void checkTableNameWhiteList(Context ctx, String upperSql) throws BOSException, SCMPortraitException {
        HashSet<String> tableSet = new HashSet<String>();
        Pattern pattern = Pattern.compile(PATTERN_1);
        Matcher matcher = pattern.matcher(upperSql);
        String creditTempTable = "creditTempTable".toUpperCase(ctx.getLocale());
        while (matcher.find()) {
            if (creditTempTable.equals(matcher.group(2))) {
                this.creditBalance = new CreditBalanceIndexInfo(ctx);
                continue;
            }
            tableSet.add(matcher.group(2));
        }
        pattern = Pattern.compile(PATTERN_2);
        matcher = pattern.matcher(upperSql);
        String matcherStr = null;
        while (matcher.find()) {
            matcherStr = matcher.group();
            matcherStr = matcherStr.substring("FROM".length(), matcherStr.length());
            String[] split = matcherStr.split(",");
            block4: for (int i = 0; i < split.length; ++i) {
                String[] s = split[i].split(" ");
                for (int j = 0; j < s.length; ++j) {
                    if (s[j].trim().length() <= 0) continue;
                    if (creditTempTable.equals(s[j].trim())) {
                        this.creditBalance = new CreditBalanceIndexInfo(ctx);
                        continue block4;
                    }
                    tableSet.add(s[j].trim());
                    continue block4;
                }
            }
        }
        if (tableSet.isEmpty()) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Upper(ftablename)", tableSet, CompareType.INCLUDE));
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct ftablename from T_SCM_PORTRAITWHITELIST WHERE ").append(filterInfo.toSql());
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (iRowSet.next()) {
                set.add(iRowSet.getString("ftablename").toUpperCase());
            }
            tableSet.removeAll(set);
            if (tableSet.size() > 0) {
                throw new SCMPortraitException(SCMPortraitException.ILLEGALTABLENAME, new Object[]{tableSet.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkIndexTypeKeyWord(PortraitType indexType, String upperSql) throws SCMPortraitException {
        String[] keyWords = null;
        keyWords = indexType.equals((Object)PortraitType.MATERIAL) ? new String[]{"MATERIAL"} : (indexType.equals((Object)PortraitType.SUPPLIER) ? new String[]{"SUPPLIER", "ASSTACT"} : new String[]{"CUSTOMER", "ASSTACT"});
        int select = upperSql.indexOf("SELECT");
        int from = upperSql.indexOf("FROM");
        if (select == -1 || from == -1) {
            throw new SCMPortraitException(SCMPortraitException.ERRORSQL);
        }
        String substring = upperSql.substring(select, from);
        for (String keyWord : keyWords) {
            if (!substring.contains(keyWord)) continue;
            return;
        }
        throw new SCMPortraitException(SCMPortraitException.NOTFINDINDEX);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!UseStatusEnum.INACTIVE.equals((Object)((SCMPortraitIndexInfo)model).getState())) {
            this.setState(model, UseStatusEnum.SAVED);
        }
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMPortraitIndexInfo scmPortraitIndexInfo;
        SCMPortraitIndexInfo info = (SCMPortraitIndexInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            this.throwException("numberCantBeNull", ctx);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            this.throwException("nameCantBeNull", ctx);
        }
        if (info.getCU() == null) {
            this.throwException("CUCantBeNull", ctx);
        }
        if (StringUtils.isEmpty((String)info.getSqlText())) {
            this.throwException("sqlTextBeNull", ctx);
        }
        if (StringUtils.isEmpty((String)info.getResultField())) {
            this.throwException("resultFieldBeNull", ctx);
        }
        this.checkSelectField(ctx, info);
        if (info.getId() != null && (scmPortraitIndexInfo = this.getNewestStatusInfo4Check(ctx, info.getId().toString())).getState() == UseStatusEnum.ACTIVE) {
            throw new SCMPortraitException(SCMPortraitException.STATUSERROR4SAVE);
        }
        this.checkNumberDup(ctx, info);
        this.checkNameDup(ctx, info);
    }

    private void checkSelectField(Context ctx, SCMPortraitIndexInfo info) throws EASBizException, BOSException {
        String sqlText = info.getSqlText();
        Map map = null;
        try {
            map = this._executeSql(ctx, sqlText, info.getIndexType(), info.getCU().getId().toString(), info.getId() == null ? null : info.getId().toString(), info.getNumber() + " " + info.getName(ctx.getLocale()));
        }
        catch (BOSException e) {
            throw new SCMPortraitException(SCMPortraitException.ERRORSQL);
        }
        String[] columns = (String[])map.get("columns");
        StringBuffer columnsStr = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            columnsStr.append(columns[i]).append(";");
        }
        String selectField = info.getSelectField();
        if (!columnsStr.substring(0, columnsStr.length() - 1).equals(selectField)) {
            throw new SCMPortraitException(SCMPortraitException.SQLISCHANGE);
        }
    }

    private SCMPortraitIndexInfo getNewestStatusInfo4Check(Context ctx, String id) throws EASBizException, BOSException {
        this.checkExist(ctx, (IObjectPK)new ObjectUuidPK(id));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("state"));
        sics.add(new SelectorItemInfo("isSystem"));
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("CU.id"));
        return this.getSCMPortraitIndexInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sics);
    }

    private void checkExist(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (!this.exists(ctx, pk)) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale());
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{msg});
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SCMPortraitIndexInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeDisable(ctx, (IObjectValue)info, true);
        this.setState((IObjectValue)info, UseStatusEnum.INACTIVE);
        super._cancel(ctx, pk, (IObjectValue)info);
    }

    private String checkBeforeDisable(Context ctx, IObjectValue model, boolean needThrowEx) throws EASBizException, BOSException {
        SCMPortraitIndexInfo scmPortraitIndexInfo = (SCMPortraitIndexInfo)model;
        StringBuilder checkMsg = new StringBuilder();
        String scmPortraitIndex = ResourceBase.getString((String)this.RESOURCE, (String)"scmPortraitIndex", (Locale)ctx.getLocale());
        if (scmPortraitIndexInfo.getState() == UseStatusEnum.INACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"badState2Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{scmPortraitIndex + scmPortraitIndexInfo.getNumber()}));
        } else if (scmPortraitIndexInfo.getState() != UseStatusEnum.ACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"saveState2Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{scmPortraitIndex + scmPortraitIndexInfo.getNumber()}));
        }
        if (!StringUtils.isEmpty((String)checkMsg.toString()) && needThrowEx) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{checkMsg.toString()});
        }
        return checkMsg.toString();
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SCMPortraitIndexInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeEnable(ctx, (IObjectValue)info, true);
        this.setState((IObjectValue)info, UseStatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, (IObjectValue)info);
    }

    private void setState(IObjectValue model, UseStatusEnum state) {
        SCMPortraitIndexInfo info = (SCMPortraitIndexInfo)model;
        info.setState(state);
    }

    private String checkBeforeEnable(Context ctx, IObjectValue model, boolean needThrowEx) throws EASBizException, BOSException {
        SCMPortraitIndexInfo scmPortraitIndexInfo = (SCMPortraitIndexInfo)model;
        StringBuilder checkMsg = new StringBuilder();
        CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String scmPortraitIndex = ResourceBase.getString((String)this.RESOURCE, (String)"scmPortraitIndex", (Locale)ctx.getLocale());
        if (scmPortraitIndexInfo.getState() == UseStatusEnum.ACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"badState2Eanble", (Locale)ctx.getLocale(), (Object[])new String[]{scmPortraitIndex + scmPortraitIndexInfo.getNumber()}));
        }
        if (!StringUtils.isEmpty((String)checkMsg.toString()) && needThrowEx) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{checkMsg.toString()});
        }
        return checkMsg.toString();
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SCMPortraitIndexInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    private void checkBeforeDelete(Context ctx, SCMPortraitIndexInfo info) throws EASBizException, BOSException {
        String permission = SCMPortraitUtil.checkFunctionPermissionStr(ctx, null, info.getCU().getId().toString(), "portraitIndex_delete");
        if (permission != null) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{permission});
        }
        if (!UseStatusEnum.SAVED.equals((Object)info.getState())) {
            throw new SCMPortraitException(SCMPortraitException.STATUSERROR4DELETE);
        }
        if (info.isIsSystem()) {
            this.throwException("systemNotDelete", ctx);
        }
    }

    private void throwException(String resourceKey, Context ctx) throws EASBizException {
        throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{EASResource.getString((String)this.RESOURCE, (String)resourceKey, (Locale)ctx.getLocale())});
    }

    @Override
    protected Map _batchEnable(Context ctx, List idList) throws BOSException, EASBizException {
        return this.batchEnbleOrDisable(ctx, idList, true);
    }

    @Override
    protected Map _batchDisable(Context ctx, List idList) throws BOSException, EASBizException {
        return this.batchEnbleOrDisable(ctx, idList, false);
    }

    private Map batchEnbleOrDisable(Context ctx, List idList, boolean isEnble) throws BOSException, EASBizException {
        SCMPortraitIndexCollection scmPortraitCollection = this.getSCMPortraitIndexCollByIds(ctx, idList);
        String operation = null;
        String method = null;
        if (isEnble) {
            operation = "portraitIndex_enable";
            method = "batchEnable";
        } else {
            operation = "portraitIndex_disable";
            method = "batchDisable";
        }
        String msg = null;
        boolean hasError = false;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder result = new StringBuilder();
        HashSet<String> validateIdSet = new HashSet<String>();
        SCMPortraitIndexInfo scmPortraitInfo = null;
        HashMap<String, String> permission = new HashMap<String, String>();
        String cuId = null;
        String permissionStr = null;
        int size = scmPortraitCollection.size();
        for (int i = 0; i < size; ++i) {
            scmPortraitInfo = scmPortraitCollection.get(i);
            cuId = scmPortraitInfo.getCU().getId().toString();
            if (!permission.containsKey(cuId)) {
                permissionStr = SCMPortraitUtil.checkFunctionPermissionStr(ctx, null, cuId, operation);
                permission.put(cuId, permissionStr);
            }
            msg = permission.get(cuId) == null ? (isEnble ? this.checkBeforeEnable(ctx, (IObjectValue)scmPortraitInfo, false) : this.checkBeforeDisable(ctx, (IObjectValue)scmPortraitInfo, false)) : scmPortraitInfo.getNumber() + " " + permission.get(cuId);
            if (!StringUtils.isEmpty((String)msg)) {
                hasError = true;
                result.append(msg).append("\n");
                continue;
            }
            validateIdSet.add(scmPortraitCollection.get(i).getId().toString());
        }
        resultMap.put("hasError", hasError);
        resultMap.put("errorMsg", result.toString());
        this.updateStatus(ctx, validateIdSet, isEnble ? 1 : 2);
        SCMPortraitUtil.buildLogInfo(ctx, (IObjectCollection)scmPortraitCollection, validateIdSet, operation, method, this.getBOSType());
        return resultMap;
    }

    private void updateStatus(Context ctx, Set idSet, int stateValue) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_SCM_SCMPortraitIndex set FState = ").append(stateValue).append(" ");
        sql.append(" where fid in (").append(ArrayUtil.getKeyIdStr((Object[])idSet.toArray())).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private SCMPortraitIndexCollection getSCMPortraitIndexCollByIds(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("state"));
        sics.add(new SelectorItemInfo("isSystem"));
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("name"));
        sics.add(new SelectorItemInfo("bosType"));
        sics.add(new SelectorItemInfo("CU.id"));
        view.setFilter(filter);
        view.setSelector(sics);
        SCMPortraitIndexCollection scmPortraitIndexCollection = this.getSCMPortraitIndexCollection(ctx, view);
        if (scmPortraitIndexCollection.size() != idSet.size()) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{ResourceBase.getString((String)this.RESOURCE, (String)"billNotExists", (Locale)ctx.getLocale())});
        }
        return scmPortraitIndexCollection;
    }

    private void writeLog(Context ctx, String sqlText, String cuID, String instanceId, String instanceDetail) throws BOSException, EASBizException {
        SCMPortraitLogInfo log = new SCMPortraitLogInfo();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (userInfo != null) {
            log.setUserID(userInfo.getId().toString());
            log.setUserNumber(userInfo.getNumber());
            log.setUserName(userInfo.getName(ctx.getLocale()));
            log.setUserType(userInfo.getType().getAlias(ctx.getLocale()));
        } else {
            log.setUserID("");
            log.setUserNumber("");
            log.setUserName("");
            log.setUserType("");
        }
        log.setOccurTime(new Timestamp(System.currentTimeMillis()));
        Object clientIP = ctx.getClientHostIP();
        if (clientIP == null) {
            clientIP = ctx.get((Object)"ClientIP");
        }
        log.setClientIP(clientIP == null ? "" : clientIP.toString());
        Object clientHostName = ctx.getClientHostName();
        if (clientHostName == null) {
            clientHostName = ctx.get((Object)"ClientName");
        }
        if (clientHostName == null || clientHostName.toString().isEmpty()) {
            clientHostName = clientIP;
        }
        log.setClientName(clientHostName == null ? "" : clientHostName.toString());
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuID));
        log.setCuID(cuID);
        log.setCuName(orgUnitInfo.getName(ctx.getLocale()));
        log.setInstanceSql(sqlText);
        log.setInstanceID(instanceId);
        if (instanceId != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            SCMPortraitIndexInfo scmPortraitInfo = SCMPortraitIndexFactory.getLocalInstance(ctx).getSCMPortraitIndexInfo((IObjectPK)new ObjectUuidPK(instanceId), selector);
            instanceDetail = scmPortraitInfo.getNumber() + " " + scmPortraitInfo.getName();
        }
        log.setInstanceNo(instanceDetail);
        SCMPortraitLogFactory.getLocalInstance(ctx).addnew(log);
    }
}

