/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.portrait.util;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitFactory;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitFeildInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PortraitViewHelper {
    private Logger logger = Logger.getLogger(PortraitViewHelper.class);
    private KDTable portraitTable = null;
    private KDTable detailTable = null;
    private CoreBaseInfo editData = null;
    private HashMap colMap = new HashMap();
    private ArrayList componentList = new ArrayList();
    private KDTSelectListener kdtSelectListener = null;
    private EditUI editUI;
    private Point innerOrigin = new Point();
    private Point portraitTableLocation = new Point();
    private boolean isInnerDraged = false;
    private HashMap cache = new HashMap();

    public PortraitViewHelper(EditUI editUI, KDTable portraitTable, KDTable detailTable, CoreBaseInfo editData) {
        this.editUI = editUI;
        this.portraitTable = portraitTable;
        this.detailTable = detailTable;
        this.editData = editData;
    }

    public PortraitViewHelper(EditUI editUI, KDTable detailTable) {
        this.editUI = editUI;
        this.detailTable = detailTable;
        this.initPortraitTable();
    }

    public void setDetailTable(KDTable detailTable) {
        this.detailTable = detailTable;
    }

    public void setEditData(CoreBaseInfo editData) {
        this.editData = editData;
    }

    public KDTable getPortraitTable() {
        return this.portraitTable;
    }

    public void setPortraitTable(KDTable portraitTable) {
        this.portraitTable = portraitTable;
    }

    protected KDTable initPortraitTable() {
        if (this.portraitTable != null) {
            return this.portraitTable;
        }
        this.portraitTable = new KDTable();
        this.portraitTable.setName("portraitTable");
        String tblMainStrXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/KDF KDFSchema.xsd\" version=\"0.0\"><Styles><c:Style id=\"sCol0\"><c:Protection hidden=\"true\" /></c:Style></Styles><Table id=\"KDTable\"><t:Sheet name=\"sheet1\"><t:Table t:selectMode=\"15\" t:mergeMode=\"0\" t:dataRequestMode=\"0\" t:pageRowCount=\"100\"><t:ColumnGroup><t:Column t:key=\"colName\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" /><t:Column t:key=\"sumRs\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" /></t:ColumnGroup><t:Head><t:Row t:name=\"header1\" t:height=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\"><t:Cell>Field_Name</t:Cell><t:Cell>Total</t:Cell></t:Row></t:Head></t:Table><t:SheetOptions><t:MergeBlocks><t:Head /></t:MergeBlocks></t:SheetOptions></t:Sheet></Table></DocRoot>";
        tblMainStrXML = tblMainStrXML.replace("Field_Name", EASResource.getString((String)"com.kingdee.eas.scm.framework.portrait.SCMPortraitResource.tblCol_portraitIndex"));
        tblMainStrXML = tblMainStrXML.replace("Total", EASResource.getString((String)"com.kingdee.eas.scm.framework.portrait.SCMPortraitResource.tblCol_value"));
        this.portraitTable.setFormatXml(tblMainStrXML);
        this.portraitTable.checkParsed();
        this.portraitTable.setEditable(false);
        this.portraitTable.getSelectManager().setSelectMode(2);
        this.portraitTable.setVisible(false);
        this.portraitTable.setBounds(new Rectangle(0, 0, 228, 300));
        this.portraitTable.setColumnMoveable(false);
        if (this.editUI != null) {
            this.editUI.add((Component)this.portraitTable, 1);
        }
        this.portraitTable.setColumnsAutoResizeMode(3);
        this.portraitTable.getViewManager().getView(1).addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((PortraitViewHelper)PortraitViewHelper.this).innerOrigin.x = e.getX();
                ((PortraitViewHelper)PortraitViewHelper.this).innerOrigin.y = e.getY();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ((Component)e.getSource()).setCursor(new Cursor(13));
            }
        });
        this.portraitTable.getViewManager().getView(1).addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                KDTable portraitTable = (KDTable)e.getComponent().getParent();
                Point p = portraitTable.getLocation();
                PortraitViewHelper.this.portraitTableLocation.setLocation(p.x + e.getX() - ((PortraitViewHelper)PortraitViewHelper.this).innerOrigin.x, p.y + e.getY() - ((PortraitViewHelper)PortraitViewHelper.this).innerOrigin.y);
                portraitTable.setLocation(PortraitViewHelper.this.portraitTableLocation);
                PortraitViewHelper.this.isInnerDraged = true;
            }
        });
        return this.portraitTable;
    }

    public void addF7ListenerForPortrait(KDPromptBox kdPromptBox, IColumn col, int portraitType) {
        if (this.portraitTable == null) {
            return;
        }
        if (kdPromptBox != null && col == null) {
            this.addMouseListener(kdPromptBox, portraitType);
        } else if (this.detailTable != null && col != null) {
            this.addSelectListener(col, portraitType);
        }
    }

    private void addSelectListener(IColumn col, int portraitType) {
        this.colMap.put(col.getKey(), portraitType);
        if (this.kdtSelectListener == null) {
            this.kdtSelectListener = new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    int beginCol = e.getSelectBlock().getBeginCol();
                    int beginRow = e.getSelectBlock().getBeginRow();
                    if (beginCol == -1 || beginRow == -1) {
                        PortraitViewHelper.this.portraitTable.setVisible(false);
                        return;
                    }
                    String colName = PortraitViewHelper.this.detailTable.getColumn(beginCol).getKDTColumn().getKey();
                    if (KDTableUtil.getSelectedRows((KDTable)PortraitViewHelper.this.detailTable).length == 1 && beginCol == e.getSelectBlock().getEndCol() && PortraitViewHelper.this.colMap.containsKey(colName) && PortraitViewHelper.this.detailTable.getCell(beginRow, beginCol).getValue() != null) {
                        PortraitViewHelper.this.mouseEnteredShowTable(null, (Integer)PortraitViewHelper.this.colMap.get(colName), beginRow);
                    } else {
                        PortraitViewHelper.this.portraitTable.setVisible(false);
                    }
                }
            };
            this.detailTable.addKDTSelectListener(this.kdtSelectListener);
        }
    }

    private void addMouseListener(final KDPromptBox kdPromptBox, final int portraitType) {
        Component[] components = kdPromptBox.getComponents();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof KDPromptBox.DefaultEditor) || this.componentList.contains(components[i])) continue;
            list.add(components[i]);
        }
        if (list.size() == 0) {
            return;
        }
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (kdPromptBox.getValue() != null) {
                    PortraitViewHelper.this.mouseEnteredShowTable(e, portraitType, -1);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PortraitViewHelper.this.portraitTable.setVisible(false);
            }
        };
        for (int i = 0; i < list.size(); ++i) {
            ((Component)list.get(i)).addMouseListener(mouseListener);
        }
        this.componentList.addAll(list);
    }

    public void mouseEnteredShowTable(MouseEvent e, int portraitType, int rowIndex) {
        try {
            this.portraitTable.setVisible(false);
            this.portraitTable.removeRows();
            Map portraitData = null;
            if (this.editData == null && this.editUI.getDataObject() == null) {
                return;
            }
            this.editUI.storeFields();
            this.editData = (CoreBaseInfo)this.editUI.getDataObject();
            if (this.editData.getId() == null || this.editData.getBOSType() == null) {
                return;
            }
            portraitData = SCMPortraitFactory.getRemoteInstance().getPortraitData((IObjectValue)this.editData, portraitType, rowIndex);
            if (portraitData == null) {
                return;
            }
            ArrayList list = (ArrayList)portraitData.get("resultList");
            if (list.size() == 0) {
                return;
            }
            IRow iRow = null;
            int keyMaxLength = 5;
            int valueMaxLength = 5;
            int valueLength = 5;
            int nameIndex = 0;
            int valueIndex = 1;
            SCMPortraitFeildInfo info = null;
            for (Object obj : list) {
                iRow = this.portraitTable.addRow();
                info = (SCMPortraitFeildInfo)obj;
                iRow.getCell(nameIndex).setValue((Object)info.getName());
                iRow.getCell(valueIndex).setValue(info.getValue());
                valueLength = 0;
                if (info.getValue() instanceof BigDecimal) {
                    int scale = ((BigDecimal)info.getValue()).scale();
                    if (info.isUp()) {
                        iRow.getCell(valueIndex).getStyleAttributes().setBackground(info.getColor());
                        iRow.getCell(valueIndex).getStyleAttributes().setNumberFormat(this.getFormatPattern(scale, true));
                        valueLength = 1;
                    } else if (info.isDowm()) {
                        iRow.getCell(valueIndex).getStyleAttributes().setBackground(info.getColor());
                        iRow.getCell(valueIndex).getStyleAttributes().setNumberFormat(this.getFormatPattern(scale, false));
                        valueLength = 1;
                    }
                }
                if (info.getName() != null && keyMaxLength < info.getName().toString().length()) {
                    keyMaxLength = info.getName().toString().length();
                }
                valueLength = this.getStringLength(info.getValue()) + valueLength;
                if (info.getValue() == null || valueMaxLength >= valueLength) continue;
                valueMaxLength = valueLength;
            }
            this.portraitTable.setBounds(0, 0, (keyMaxLength + valueMaxLength) * 13 + 28, this.portraitTable.getHead().getHeight() + this.portraitTable.getDefaultRowHeight() * list.size() + 2);
            this.portraitTable.getColumn(nameIndex).setWidth(keyMaxLength * 13);
            this.portraitTable.getColumn(valueIndex).setWidth(valueMaxLength * 13);
            if (e != null) {
                this.portraitTable.setLocation(this.getLocationPoint((Component)e.getSource(), e.getPoint()));
            } else {
                int height = this.portraitTable.getHeight();
                int width = this.portraitTable.getWidth();
                Dimension dm = Toolkit.getDefaultToolkit().getScreenSize();
                int x = dm.width / 2 - width / 2 - 30;
                int y = dm.height / 3 - height / 2;
                this.portraitTable.setLocation(x + 1, y + 1);
            }
            this.portraitTable.setVisible(true);
        }
        catch (Exception e1) {
            this.logger.error((Object)e1);
            this.editUI.handUIException((Throwable)e1);
        }
    }

    private Point getLocationPoint(Component component, Point point) {
        if (component instanceof CoreUI) {
            return point;
        }
        Container parent = component.getParent();
        point.setLocation(point.getX() + (double)parent.getX(), point.getY() + (double)parent.getY());
        return this.getLocationPoint(parent, point);
    }

    private int getStringLength(Object obj) {
        if (obj == null) {
            return 0;
        }
        String str = obj.toString();
        boolean num = false;
        float b = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '!' && c <= 'z') {
                b = (float)((double)b + 0.65);
                continue;
            }
            b += 1.0f;
        }
        return Math.round(b);
    }

    private String getFormatPattern(int scale, boolean isUp) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        String foreStr = "\u2193";
        if (isUp) {
            foreStr = "\u2191";
        }
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = foreStr + pattern + ";" + foreStr + "-" + pattern + ";";
        return pattern;
    }
}

