/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.portrait.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.service.formula.api.BaseFormulaFunctions;
import com.kingdee.bos.service.formula.api.InvokeFunctionException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitException;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class SCMPortraitUtil {
    public static Map<String, EntityObjectInfo> entiytyMap = new HashMap<String, EntityObjectInfo>();
    public static Map<String, Object> cache = new HashMap<String, Object>();
    public static final String CU_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    public static final String REGEX_SIMICOLON = ";";
    public static final String REGEX_COMMA = ",";
    public static final String REGEX_DOT = ".";
    public static final String HAS_ERROR = "hasError";
    public static final String ERROR_MSG = "errorMsg";
    public static final String NEW_LINE = "\n";
    public static final String FUNCTION_PREFIX = "__";
    public static final String FUNCTION_LEFT = "(";
    public static final String FUNCTION_RIGHT = ")";
    public static final String CREDIT_TEMPTABLE = "creditTempTable";
    public static final String RESULTLIST = "resultList";
    private static BaseFormulaFunctions baseFormulaFunctions = new BaseFormulaFunctions();

    public static String[] getFeildArr(String feild) {
        if (feild == null) {
            return new String[0];
        }
        return feild.split(REGEX_SIMICOLON);
    }

    public static String getListUIMainQuery(String listUIName) {
        if (StringUtil.isEmpty((String)listUIName)) {
            return null;
        }
        UIObjectInfo listUIObject = MetadataUtils.loadUI((IMetaDataPK)MetaDataPK.create((String)listUIName));
        if (listUIObject == null || listUIObject.getDataObjects().size() == 0) {
            return null;
        }
        int size = listUIObject.getDataObjects().size();
        for (int i = 0; i < size; ++i) {
            DataObjectInfo dataObject = listUIObject.getDataObjects().get(i);
            if (!dataObject.getName().equals("mainQuery")) continue;
            return dataObject.getType();
        }
        return null;
    }

    public static EntityObjectInfo getEntityObjectInfo(String bosTypeID) {
        return SCMPortraitUtil.getEntityObjectInfo(null, bosTypeID);
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bosTypeID) {
        if (StringUtil.isEmpty((String)bosTypeID)) {
            return null;
        }
        if (entiytyMap.containsKey(bosTypeID)) {
            return entiytyMap.get(bosTypeID);
        }
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeID);
        IMetaDataLoader iMeta = null;
        iMeta = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = iMeta.getEntity(bosType);
        if (entity != null) {
            entiytyMap.put(bosTypeID, entity);
        }
        return entity;
    }

    public static String getEntityPropertyAlias(EntityObjectInfo mainEntity, String propertyValue) {
        String alias = null;
        EntityObjectInfo currentEntity = mainEntity;
        String currentProperty = propertyValue;
        PropertyCollection propertyCollection = Util.getAllEntityProperties((EntityObjectInfo)currentEntity);
        int size = propertyCollection.size();
        int index = currentProperty.indexOf(REGEX_DOT);
        String compareProperty = null;
        if (index != -1) {
            compareProperty = currentProperty.substring(0, index);
            currentProperty = currentProperty.substring(index + 1);
        } else {
            compareProperty = currentProperty;
        }
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(compareProperty)) continue;
            alias = alias == null ? Util.getPropertyAlias((PropertyInfo)propertyInfo) : alias + Util.getPropertyAlias((PropertyInfo)propertyInfo);
            if (compareProperty != currentProperty) {
                currentEntity = Util.getEntity((String)currentEntity.getFullName(), (LinkPropertyInfo)((LinkPropertyInfo)propertyInfo));
                return alias + REGEX_DOT + SCMPortraitUtil.getEntityPropertyAlias(currentEntity, currentProperty);
            }
            return alias;
        }
        return compareProperty;
    }

    public static String evalFunction(String sqlText) throws SCMPortraitException, BOSException {
        return SCMPortraitUtil.evalFunction(sqlText, 0);
    }

    private static String getFunctionName(String sqlText, int start) {
        int i = sqlText.indexOf(FUNCTION_LEFT, start);
        return sqlText.substring(start + FUNCTION_PREFIX.length(), i);
    }

    private static String evalFunction(String sqlText, int position) throws SCMPortraitException, BOSException {
        String param;
        ArrayList paramList;
        StringBuffer sql = new StringBuffer();
        if (sqlText.length() == 0 || position > sqlText.length()) {
            return sqlText;
        }
        int start = sqlText.indexOf(FUNCTION_PREFIX, position);
        if (start == -1) {
            return sqlText;
        }
        int end = -1;
        int paramStart = -1;
        Object value = null;
        String funsName = SCMPortraitUtil.getFunctionName(sqlText, start);
        value = SCMPortraitUtil.evalFunction(funsName, paramList = SCMPortraitUtil.getParamList(param = sqlText.substring((paramStart = start + FUNCTION_PREFIX.length() + funsName.length()) + 1, end = SCMPortraitUtil.findEnd(sqlText, paramStart))));
        if (value == null) {
            throw new SCMPortraitException(SCMPortraitException.ERRORFUNCTION);
        }
        sql.append(sqlText, 0, start);
        sql.append(value);
        sql.append(sqlText.substring(end + 1));
        return SCMPortraitUtil.evalFunction(sql.toString(), start + String.valueOf(value).length());
    }

    private static ArrayList getParamList(String param) throws SCMPortraitException, BOSException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (param.length() == 0) {
            return paramList;
        }
        int start = 0;
        int funsIndex = -1;
        int splitIndex = -1;
        while (start < param.length()) {
            funsIndex = param.indexOf(FUNCTION_PREFIX, start);
            if (funsIndex == -1) {
                String[] split = param.split(REGEX_COMMA);
                paramList.add(split);
                return paramList;
            }
            splitIndex = param.indexOf(REGEX_COMMA, start);
            if (splitIndex != -1 && splitIndex < funsIndex) {
                paramList.add(param.substring(start, splitIndex));
                start = splitIndex;
                continue;
            }
            paramList.add(SCMPortraitUtil.evalFunction(param, funsIndex));
            start = SCMPortraitUtil.findEnd(param, funsIndex) + 1;
        }
        return paramList;
    }

    private static int findEnd(String sqlText, int start) throws SCMPortraitException {
        int now = start;
        Stack<Integer> stack = new Stack<Integer>();
        while (now < sqlText.length()) {
            int leftIndex = sqlText.indexOf(FUNCTION_LEFT, now);
            int rightIndex = sqlText.indexOf(FUNCTION_RIGHT, now);
            if (leftIndex != -1 && rightIndex != -1) {
                if (leftIndex > rightIndex) {
                    now = rightIndex;
                    stack.pop();
                    if (stack.empty()) {
                        return now;
                    }
                    ++now;
                    continue;
                }
                now = leftIndex + 1;
                stack.push(leftIndex);
                continue;
            }
            if (rightIndex == -1) continue;
            now = rightIndex;
            stack.pop();
            if (stack.empty()) {
                return now;
            }
            ++now;
        }
        if (!stack.empty()) {
            throw new SCMPortraitException(SCMPortraitException.ERRORFUNCTION);
        }
        return sqlText.length();
    }

    public static PermItemInfo getPortraitPermission(Context ctx, String bosType) throws BOSException, EASBizException {
        if (cache.containsKey(bosType)) {
            return (PermItemInfo)cache.get(bosType);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("OBJECTTYPE", (Object)bosType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"%portrait%", CompareType.LIKE));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        PermItemCollection permItemCollection = PermItemFactory.getLocalInstance((Context)ctx).getPermItemCollection(view);
        if (permItemCollection.size() > 0) {
            cache.put(bosType, permItemCollection.get(0));
            return permItemCollection.get(0);
        }
        cache.put(bosType, null);
        return null;
    }

    public static boolean checkFunctionPermission(Context ctx, String userId, String orgId, String permission) throws BOSException, EASBizException {
        boolean checkPermission = true;
        try {
            IPermission localInstance = null;
            IObjectPK userPk = null;
            if (ctx == null) {
                localInstance = PermissionFactory.getRemoteInstance();
            } else {
                localInstance = PermissionFactory.getLocalInstance((Context)ctx);
                userPk = ctx.getCaller();
            }
            if (userPk == null && userId != null) {
                userPk = new ObjectUuidPK(userId);
            }
            localInstance.checkFunctionPermission(userPk, (IObjectPK)new ObjectUuidPK(orgId), permission);
        }
        catch (PermissionException e) {
            checkPermission = false;
        }
        return checkPermission;
    }

    public static String checkFunctionPermissionStr(Context ctx, String userId, String orgId, String permission) throws BOSException, EASBizException {
        String msg = null;
        try {
            IPermission localInstance = null;
            IObjectPK userPk = null;
            if (ctx == null) {
                localInstance = PermissionFactory.getRemoteInstance();
            } else {
                localInstance = PermissionFactory.getLocalInstance((Context)ctx);
                userPk = ctx.getCaller();
            }
            if (userPk == null && userId != null) {
                userPk = new ObjectUuidPK(userId);
            }
            localInstance.checkFunctionPermission(userPk, (IObjectPK)new ObjectUuidPK(orgId), permission);
        }
        catch (PermissionException e) {
            msg = e.getMessage();
        }
        return msg;
    }

    public static String addShellSql(String sqlText, String whereSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ( ").append(sqlText).append(") T ");
        if (whereSql != null) {
            sql.append(whereSql);
        }
        return sql.toString();
    }

    private static Object evalFunction(String funsName, ArrayList paramList) throws KScriptException {
        if ("lastYear".equals(funsName)) {
            return SCMPortraitUtil.lastYear(funsName, paramList);
        }
        if ("lastDay".equals(funsName)) {
            return SCMPortraitUtil.lastDay(funsName, paramList);
        }
        if ("firstDay".equals(funsName)) {
            return SCMPortraitUtil.firstDay(funsName, paramList);
        }
        return baseFormulaFunctions.evalFunction(funsName, (List)paramList);
    }

    private static Object lastYear(String funsName, ArrayList paramList) throws KScriptException {
        SCMPortraitUtil.checkParamList(funsName, paramList, 1);
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
        nowDateFormat.applyPattern(pattern);
        Calendar c = Calendar.getInstance();
        String s = (String)paramList.get(0);
        s = s.replaceAll("-", "/");
        c.setTime(new Date(s));
        c.add(1, -1);
        return nowDateFormat.format(c.getTime());
    }

    private static Object lastDay(String funsName, ArrayList paramList) throws KScriptException {
        SCMPortraitUtil.checkParamList(funsName, paramList, 1);
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
        nowDateFormat.applyPattern(pattern);
        Calendar c = Calendar.getInstance();
        String s = (String)paramList.get(0);
        s = s.replaceAll("-", "/");
        Date date = new Date(s);
        c.set(1, date.getYear() + 1900 + 1);
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.add(5, -1);
        return nowDateFormat.format(c.getTime());
    }

    private static Object firstDay(String funsName, ArrayList paramList) throws KScriptException {
        SCMPortraitUtil.checkParamList(funsName, paramList, 1);
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
        nowDateFormat.applyPattern(pattern);
        Calendar c = Calendar.getInstance();
        String s = (String)paramList.get(0);
        s = s.replaceAll("-", "/");
        Date date = new Date(s);
        c.set(1, date.getYear() + 1900);
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return nowDateFormat.format(c.getTime());
    }

    private static void checkParamList(String funsName, ArrayList paramList, int paramNums) throws KScriptException {
        try {
            if (paramList == null) {
                throw new InvokeFunctionException(funsName, paramNums);
            }
            if (paramList.size() < paramNums) {
                throw new InvokeFunctionException(funsName, paramNums);
            }
            if (paramList.size() > paramNums) {
                throw new InvokeFunctionException(funsName, paramNums);
            }
            for (int i = 0; i < paramNums; ++i) {
                if (paramList.get(i) != null) continue;
                throw new InvokeFunctionException(funsName, paramNums);
            }
        }
        catch (InvokeFunctionException e) {
            throw new KScriptException(e.toString(), (Throwable)e);
        }
    }

    public static void buildLogInfo(Context ctx, IObjectCollection coll, Set validateIdSet, String logItem, String methodName, BOSObjectType bosType) {
        DataBaseInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = (DataBaseInfo)coll.getObject(i);
            IObjectPK logId = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bosType, (IObjectPK)new ObjectUuidPK(info.getId()), (String)(info.getNumber() + " " + info.getName()), (String)logItem, (String)info.getCU().getId().toString());
            if (!validateIdSet.contains(info.getId().toString())) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)logId);
        }
    }

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("0.");
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgInfo, OrgType orgType) throws BOSException, EASBizException {
        if (orgInfo != null && orgType != null) {
            OrgUnitCollection orgUnitCollection = null;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            orgUnitCollection = iOrgUnitRelation.getToUnit(orgInfo.getId().toString(), orgType.getValue(), 1);
            if (orgUnitCollection.size() > 0) {
                company = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
            }
            return company;
        }
        return null;
    }
}

