/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotScheduleFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotScheduleInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SCMRobotJobServerUtil {
    private static String SCMROBOTSCHEMA_METHOD = "excute";
    private static String SCMROBOTSCHEMA = "schemaID";
    private static String SCMROBOT = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"GL_SmartAccounting");

    public static void init(Context ctx) throws BOSException {
    }

    public static void scheduleFwEnable(Context ctx, SCMRobotScheduleInfo saScheduleInfo, String number) throws BOSException, EASBizException {
        SCMRobotJobServerUtil.init(ctx);
        String jobDefID = saScheduleInfo.getJobDefID();
        String scheduleXml = saScheduleInfo.getSchemeXML();
        if (jobDefID != null) {
            EnactmentServiceFactory.createEnactService((Context)ctx).removeJobProcessDef(jobDefID);
            saScheduleInfo.setJobDefID(null);
        }
        FunctionObjectInfo function = SCMRobotJobServerUtil.getSCMRobotFunction(ctx);
        OperationCollection operCol = function.getOperation();
        OperationInfo operation = null;
        int length = operCol.size();
        for (int i = 0; i < length; ++i) {
            if (!operCol.get(i).getName().equalsIgnoreCase(SCMROBOTSCHEMA_METHOD)) continue;
            operation = operCol.get(i);
            break;
        }
        if (operation == null) {
            throw new BOSException("Cannot found METHOD: " + SCMROBOTSCHEMA_METHOD);
        }
        HashMap<String, Object> jobContext = new HashMap<String, Object>();
        jobContext.put(SCMROBOTSCHEMA, saScheduleInfo.getScmRobotSchema().getId().toString());
        if (saScheduleInfo.getServerNumber() != null) {
            jobContext.put("selectedServer", saScheduleInfo.getServerNumber());
        }
        jobContext.put("isRetainTime", true);
        String tJobNumber = SCMROBOT + "_" + number;
        jobDefID = EnactmentServiceFactory.createEnactService((Context)ctx).createJobProcessDef(tJobNumber, function, operation, jobContext, scheduleXml, ctx.getLocale());
        saScheduleInfo.setStatus(UseStatusEnum.ACTIVE);
        saScheduleInfo.setJobDefID(jobDefID);
        SCMRobotScheduleFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(saScheduleInfo.getId()), (CoreBaseInfo)saScheduleInfo);
    }

    public static void jobDisable(Context ctx, SCMRobotScheduleInfo saScheduleInfo) throws BOSException, EASBizException {
        SCMRobotJobServerUtil.init(ctx);
        String jobDefID = saScheduleInfo.getJobDefID();
        String scheduleXml = saScheduleInfo.getSchemeXML();
        if (jobDefID != null && jobDefID != "") {
            EnactmentServiceFactory.createEnactService((Context)ctx).updateProcessSchedule(jobDefID, scheduleXml);
            EnactmentServiceFactory.createEnactService((Context)ctx).setProcessDefEnable(jobDefID, false);
        }
        saScheduleInfo.setStatus(UseStatusEnum.INACTIVE);
        SCMRobotScheduleFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(saScheduleInfo.getId()), (CoreBaseInfo)saScheduleInfo);
    }

    public static void removeJob(Context ctx, SCMRobotScheduleInfo saScheduleInfo) throws BOSException, EASBizException {
        SCMRobotJobServerUtil.init(ctx);
        String jobDefID = saScheduleInfo.getJobDefID();
        if (jobDefID != null) {
            EnactmentServiceFactory.createEnactService((Context)ctx).removeJobProcessDef(jobDefID);
            try {
                EnactmentServiceFactory.createEnactService((Context)ctx).deleteProcessDefine(jobDefID);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        saScheduleInfo.setJobDefID(null);
        saScheduleInfo.setStatus(UseStatusEnum.INACTIVE);
    }

    public static void startJob(Context ctx, SCMRobotScheduleInfo saScheduleInfo) throws BOSException, EASBizException {
        SCMRobotJobServerUtil.init(ctx);
        String jobDefID = saScheduleInfo.getJobDefID();
        if (jobDefID != null) {
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put(SCMROBOTSCHEMA, saScheduleInfo.getScmRobotSchema().getId().toString());
            String initiatorId = ctx.getCaller().toString();
            EnactmentServiceFactory.createEnactService((Context)ctx).createJobProcessInst(jobDefID, jobContext, initiatorId);
        }
    }

    public static String stopJob(Context ctx, SCMRobotScheduleInfo saScheduleInfo) throws BOSException, EASBizException {
        SCMRobotJobServerUtil.init(ctx);
        String result = "";
        String jobDefID = saScheduleInfo.getJobDefID();
        String processInstID = SCMRobotJobServerUtil.getProcInstByDefId(ctx, saScheduleInfo);
        ProcessInstInfo instInfo = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstInfo(processInstID);
        String state = instInfo.getState();
        return result;
    }

    public static List getProcessInstByProcDefID(Context ctx, SCMRobotScheduleInfo saScheduleInfo) throws BOSException, EASBizException {
        String jobDefID = saScheduleInfo.getJobDefID();
        ArrayList result = new ArrayList();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.job.app.JobInstQuery"));
        new MetaDataPK("com.kingdee.eas.base.job.app", "JobInstHstQuery");
        FilterItemInfo fii = new FilterItemInfo("jobDefId", (Object)jobDefID, CompareType.EQUALS);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo ff = new FilterInfo();
        ff.getFilterItems().add(fii);
        ff.setMaskString("(#0)");
        ev.setFilter(ff);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        try {
            while (rs.next()) {
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static String getProcInstByDefId(Context ctx, SCMRobotScheduleInfo saScheduleInfo) throws BOSException, EASBizException {
        String jobDefID = saScheduleInfo.getJobDefID();
        String instID = "";
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.job.app.JobInstQuery"));
        FilterItemInfo fii = new FilterItemInfo("jobDefId", (Object)jobDefID, CompareType.EQUALS);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo ff = new FilterInfo();
        ff.getFilterItems().add(fii);
        ff.setMaskString("(#0)");
        ev.setFilter(ff);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        try {
            while (rs.next()) {
                instID = "";
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return instID;
    }

    private static FunctionObjectInfo getSCMRobotFunction(Context ctx) {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.scm.framework.robot.SCMRobot");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        return function;
    }

    public static List getServerList(Context ctx, SCMRobotScheduleInfo bill) throws BOSException {
        ArrayList serverList = new ArrayList();
        String[] jobServiceInstanceKeys = JobUtils.getJobServiceFacade().getJobServiceInstanceKeys_c();
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        String defualtServer = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"auto_choose");
        defaultMap.put("value", "autoExecuteServer");
        defaultMap.put("alias", defualtServer);
        serverList.add(defaultMap);
        if (jobServiceInstanceKeys != null && jobServiceInstanceKeys.length > 0) {
            String serverNumber = null;
            if (bill != null) {
                serverNumber = bill.getServerNumber();
            }
            for (int i = 0; i < jobServiceInstanceKeys.length; ++i) {
                HashMap<String, Object> serverMap = new HashMap<String, Object>();
                serverMap.put("value", jobServiceInstanceKeys[i]);
                serverMap.put("alias", jobServiceInstanceKeys[i]);
                if (serverNumber != null && serverNumber.equals(jobServiceInstanceKeys[i])) {
                    serverMap.put("isDefault", 1);
                }
                serverList.add(serverMap);
            }
        }
        return serverList;
    }
}

