/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IMAGroup;
import com.kingdee.eas.base.message.IMAGroupEntry;
import com.kingdee.eas.base.message.IMAGroupResolventEntry;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupResolventEntryFactory;
import com.kingdee.eas.base.message.MAGroupResolventEntryInfo;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSendRecordInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.MsgUnreadCountFactory;
import com.kingdee.eas.base.message.app.ReceiversUtil;
import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.webservice.MCInvoke;
import com.kingdee.eas.base.message.webservice.WebServiceControlUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.UnionGroupOrgUnitFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.robot.OperationTypeEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotException;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotScheduleFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotScheduleInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryInfo;
import com.kingdee.eas.scm.framework.robot.app.AbstractSCMRobotSchemaControllerBean;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotExecuteAccountRecoder;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotJobServerUtil;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotServerUtil;
import com.kingdee.eas.scm.framework.robot.app.executor.ISCMRobotExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotBillOprtExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotBillTransExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotOtherOprtExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotTask;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotVoucherExecutor;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SCMRobotSchemaControllerBean
extends AbstractSCMRobotSchemaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.robot.app.SCMRobotSchemaControllerBean");
    private static final String RES = "com.kingdee.eas.scm.framework.SCMRobotResource";
    private static final String SCMRobot_MutexLock = "SCM_Robot";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        SCMRobotSchemaInfo schemaInfo = (SCMRobotSchemaInfo)model;
        if (schemaInfo.getSchedule() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_SCM_SCMRobotSchedule set FScmRobotSchemaID = ? where fid = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{pk.toString(), schemaInfo.getSchedule().getId().toString()});
        }
        return pk;
    }

    @Override
    protected List _enable(Context ctx, String ids) throws BOSException, EASBizException {
        Locale loc = ctx.getOriginLocale();
        IObjectPK userPk = ctx.getCaller();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        permission.checkFunctionPermission(userPk, null, "scmrobot_enable");
        ArrayList<String> result = new ArrayList<String>();
        String[] schemaArr = ids.split(",");
        for (int i = 0; i < schemaArr.length; ++i) {
            String schemaID = schemaArr[i];
            String error = "";
            if (schemaID == null || schemaID.equals("")) {
                error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
                result.add(error);
                continue;
            }
            boolean isExist = SCMRobotSchemaFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(schemaID));
            if (!isExist) {
                error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
                result.add(error);
                continue;
            }
            SCMRobotSchemaInfo schemaInfo = (SCMRobotSchemaInfo)SCMRobotSchemaFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(schemaID));
            String scheduleID = "";
            if (schemaInfo.getSchedule() == null) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaNoSchedule", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            scheduleID = schemaInfo.getSchedule().getId().toString();
            isExist = SCMRobotScheduleFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(scheduleID));
            if (!isExist) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaNoSchedule", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            if (schemaInfo.getStatus().equals((Object)UseStatusEnum.ACTIVE)) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaEnabled", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            SCMRobotScheduleInfo scheduleInfo = (SCMRobotScheduleInfo)SCMRobotScheduleFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(scheduleID));
            if (scheduleInfo.getScmRobotSchema() == null) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaNoSchedule", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"enableSchema", (BOSObjectType)schemaInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(schemaID), (String)schemaInfo.getNumber(), (String)"SCM_RobotSchema_enable");
            StringBuffer sqlUpdate = new StringBuffer();
            sqlUpdate.append("Update T_SCM_SCMRobotSchema \r\n");
            sqlUpdate.append("Set FStatus = 1 ,FLastUpdateUserID = ?, FLastUpdateTime = ?   \r\n");
            sqlUpdate.append("Where  FStatus in(0,2) and fid = ? ");
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            Timestamp time = new Timestamp(new Date().getTime());
            DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])new Object[]{user.getId().toString(), time, schemaID});
            SCMRobotJobServerUtil.scheduleFwEnable(ctx, scheduleInfo, schemaInfo.getNumber());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return result;
    }

    @Override
    protected List _disable(Context ctx, String ids) throws BOSException, EASBizException {
        Locale loc = ctx.getOriginLocale();
        Object company = null;
        IObjectPK userPk = ctx.getCaller();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        permission.checkFunctionPermission(userPk, null, "scmrobot_disable");
        if (ids == null || ids.equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("99", EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc)));
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] schemaStr = ids.split(",");
        for (int i = 0; i < schemaStr.length; ++i) {
            String schemaID = schemaStr[i];
            String error = "";
            boolean isExist = SCMRobotSchemaFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(schemaID));
            if (!isExist) {
                error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
                result.add(error);
                continue;
            }
            SCMRobotSchemaInfo schemaInfo = (SCMRobotSchemaInfo)SCMRobotSchemaFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(schemaID));
            if (!schemaInfo.getStatus().equals((Object)UseStatusEnum.ACTIVE)) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaNotEnable", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            if (schemaInfo.getStatus().equals((Object)UseStatusEnum.INACTIVE)) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaDisabled", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            String scheduleID = null;
            if (schemaInfo.getSchedule() != null) {
                scheduleID = schemaInfo.getSchedule().getId().toString();
            }
            if (schemaInfo.getSchedule() == null) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaNoSchedule", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            boolean isRunning = this.getSchemaProcessState(ctx, schemaInfo.getId().toString());
            if (isRunning) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaIsProcessCantDisable", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"disableSchema", (BOSObjectType)schemaInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(schemaID), (String)schemaInfo.getNumber(), (String)"SCM_RobotSchema_disable");
            StringBuffer sqlUpdate = new StringBuffer();
            sqlUpdate.append("Update T_SCM_SCMRobotSchema                                      \r\n");
            sqlUpdate.append("Set FStatus = 2 ,FLastUpdateUserID = ?, FLastUpdateTime = ?   \r\n");
            sqlUpdate.append("Where  FStatus in(1,0) and fid = ? ");
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            Timestamp time = new Timestamp(new Date().getTime());
            DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])new Object[]{user.getId().toString(), time, schemaID});
            if (scheduleID != null && scheduleID.length() > 0) {
                SCMRobotScheduleInfo scheduleInfo = (SCMRobotScheduleInfo)SCMRobotScheduleFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(scheduleID));
                if (scheduleInfo.getScmRobotSchema() == null) {
                    scheduleInfo.setScmRobotSchema(schemaInfo);
                }
                SCMRobotJobServerUtil.jobDisable(ctx, scheduleInfo);
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return result;
    }

    @Override
    protected String _excute(Context ctx, String schemaID) throws BOSException, EASBizException {
        Map taskMap = this._createExcuteTask(ctx, schemaID);
        String uuid = (String)taskMap.get("guuid");
        ctx.put((Object)"isBack", (Object)true);
        String result = this._excuteByPeriod(ctx, uuid, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String _excuteByPeriod(Context ctx, String uuid, String periodNum) throws BOSException, EASBizException {
        String result = "";
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        SCMRobotTask curTask = null;
        String reportID = null;
        MutexParameter mp = null;
        SCMRobotExecuteAccountRecoder reportRecorder = new SCMRobotExecuteAccountRecoder();
        logger.error((Object)"SCMRobot task start ==============================");
        while (true) {
            result = "";
            try {
                long rptcurrent = System.currentTimeMillis();
                reportID = SCMRobotServerUtil.getFirstReportIDByGuuid(ctx, uuid);
                logger.info((Object)("SCMRobot getFirstReportIDByGuuid \u8017\u65f6 " + (System.currentTimeMillis() - rptcurrent) + " ms........."));
            }
            catch (Exception e) {
                logger.error((Object)("SCMRobot \u4efb\u52a1\u6267\u884c \u83b7\u53d6reportID\u5931\u8d25\uff1a" + e.getMessage()));
            }
            if (reportID == null) return result;
            try {
                curTask = this.buildSCMRobotTask(ctx, reportID, periodNum);
                this.addPeriodTag(ctx, curTask);
            }
            catch (Exception e) {
                result = e.getMessage();
                reportRecorder.updateFinishState(ctx, reportID, result, 0, 0);
                continue;
            }
            mp = this.getMutexParam(ctx, curTask);
            boolean isLockSucceed = mutex.requestMutex(mp);
            try {
                if (!isLockSucceed) {
                    result = EASResource.getString((String)RES, (String)"getTaskMutexFail", (Locale)ctx.getOriginLocale());
                }
                if (StringUtils.isEmpty((String)(result = this.checkImpClass(ctx, curTask)))) {
                    UserInfo currUser;
                    reportRecorder.updateStartSate(ctx, reportID);
                    SCMRobotSchemaInfo schemaInfo = curTask.getSchemaInfo();
                    SCMRobotSchemaOrgEntryInfo orgEntryInfo = curTask.getOrgEntryInfo();
                    UserInfo schemaUserInfo = schemaInfo.getSchedule().getCreator();
                    UserInfo exeUser = currUser = ContextUtil.getCurrentUserInfo((Context)ctx);
                    UserInfo schemaUserInfoNew = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(schemaUserInfo.getId().toString()));
                    if (ctx.get((Object)"isBack") != null) {
                        exeUser = schemaUserInfoNew;
                    }
                    Context smartCtx = (Context)ObjectUtils.createCopy((Object)ctx);
                    FullOrgUnitInfo orgInfo = orgEntryInfo.getOrgUnit();
                    smartCtx.put((Object)"orgInfo", (Object)orgInfo);
                    smartCtx.put((Object)"UserInfo", (Object)exeUser);
                    if (smartCtx.get((Object)"isBack") != null) {
                        smartCtx.setCaller((IObjectPK)new ObjectUuidPK(schemaUserInfo.getId()));
                    }
                    OrgType orgType = curTask.getOperation().getOrgType();
                    if ((orgInfo = this.getBusinessOrgByID(ctx, orgInfo.getId().toString(), orgType)) != null) {
                        try {
                            ContextUtil.setCurrentOrgUnit((Context)smartCtx, (OrgType)orgType, (OrgUnitInfo)orgInfo);
                        }
                        catch (Exception e) {
                            logger.error((Object)"\u4f9b\u5e94\u94fe\u673a\u5668\u4eba\u8bbe\u7f6e\u5f53\u524d\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
                        }
                    }
                    IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"excuteByPeriod", (BOSObjectType)schemaInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(schemaInfo.getId()), (String)schemaInfo.getNumber(), (String)"SCM_RobotSchema_excute", (String)orgInfo.getId().toString());
                    ISCMRobotExecutor taskExecutor = this.getTaskExecutor(curTask);
                    Map exeResult = taskExecutor.excute(smartCtx, curTask);
                    int sucessCount = 0;
                    int failureCount = 0;
                    if (exeResult.get("successCount") != null) {
                        sucessCount = (Integer)exeResult.get("successCount");
                    }
                    if (exeResult.get("failCount") != null) {
                        failureCount = (Integer)exeResult.get("failCount");
                    }
                    if (exeResult.get("errorString") != null) {
                        result = (String)exeResult.get("errorString");
                    }
                    reportRecorder.updateFinishState(ctx, reportID, result, sucessCount, failureCount);
                    if (failureCount > 0) {
                        this.pushMessage(ctx, curTask, result, failureCount + "");
                    }
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                    continue;
                }
                reportRecorder.updateFinishState(ctx, reportID, result, 0, 0);
                this.pushMessage(ctx, curTask, result, null);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"SCMRobot execute error", (Throwable)e);
                result = e.getMessage();
                result = result != null && result.contains("ERROR_GETFILTER") ? (curTask.getPeriodInfo() == null ? EASResource.getString((String)RES, (String)"ERROR_GETFILTER_PERIOD", (Locale)ctx.getOriginLocale()) : EASResource.getString((String)RES, (String)"ERROR_GETFILTER", (Locale)ctx.getOriginLocale())) : EASResource.getString((String)RES, (String)"systemErr", (Locale)ctx.getOriginLocale());
                String a = "";
                reportRecorder.updateFinishState(ctx, reportID, result, 0, 0);
                this.pushMessage(ctx, curTask, e.getMessage(), null);
                continue;
            }
            finally {
                if (mp == null) continue;
                mutex.releaseMutex(mp.getRequestId());
                continue;
            }
            break;
        }
    }

    private void addPeriodTag(Context ctx, SCMRobotTask curTask) throws BOSException {
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = curTask.getPeriodInfo();
        sql.append(" update T_SCM_SCMRobotExecuteAccount set FOperationName = '").append(periodInfo.toString()).append("\u2014\u2014'||FOperationName ");
        sql.append(" where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{curTask.getReportId()});
    }

    private OrgUnitInfo getBusinessOrgByID(Context ctx, String orgId, OrgType orgType) throws EASBizException, BOSException {
        CompanyOrgUnitInfo orgInfo = null;
        switch (orgType.getValue()) {
            case -1: 
            case 1: {
                orgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 0: {
                orgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 2: {
                orgInfo = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 3: {
                orgInfo = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 4: {
                orgInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 5: {
                orgInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 6: {
                orgInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 8: {
                orgInfo = UnionGroupOrgUnitFactory.getLocalInstance((Context)ctx).getUnionGroupOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 16: {
                orgInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 24: {
                orgInfo = TransportOrgUnitFactory.getLocalInstance((Context)ctx).getTransportOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
            case 32: {
                orgInfo = QualityOrgUnitFactory.getLocalInstance((Context)ctx).getQualityOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                break;
            }
        }
        return orgInfo;
    }

    public void pushMessage(Context ctx, SCMRobotTask task, String error, String number) throws EASBizException, BOSException {
        String message = "";
        SCMRobotSchemaInfo schemaInfo = task.getSchemaInfo();
        SCMRobotSchemaOrgEntryInfo orgEntryInfo = task.getOrgEntryInfo();
        SCMRobotOperationInfo operation = task.getOperation();
        UserInfo executor = task.getExecutor();
        String schemaName = schemaInfo.getName();
        String companyName = orgEntryInfo.getOrgUnit().getName();
        String businessName = operation.getBussinessName();
        String operatorName = operation.getOperationName();
        message = MessageFormat.format(EASResource.getString((String)RES, (String)"pushMsg1", (Locale)ctx.getOriginLocale()), schemaName) + ",";
        String de = EASResource.getString((String)RES, (String)"de", (Locale)ctx.getOriginLocale());
        String err1 = EASResource.getString((String)RES, (String)"busiProcessFail", (Locale)ctx.getOriginLocale());
        message = companyName.length() > 0 ? message + companyName + " " + de + " " + businessName + " " + de + " " + operatorName + " " + err1 : message + businessName + " " + de + " " + operatorName + " " + err1;
        if (number != null && number.length() > 0) {
            message = message + MessageFormat.format(EASResource.getString((String)RES, (String)"failNumber", (Locale)ctx.getOriginLocale()), number);
            message = message + EASResource.getString((String)RES, (String)"failMsg2", (Locale)ctx.getOriginLocale());
        } else {
            message = message + EASResource.getString((String)RES, (String)"failres", (Locale)ctx.getOriginLocale()) + "\uff1a " + error;
        }
        String priorty = "10";
        String receiverId = "";
        String sql = "select fid ,fpersonid from T_PM_User where fid= ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{executor.getId().toString()});
        try {
            if (rs.next()) {
                receiverId = rs.getString("fpersonid");
            }
        }
        catch (SQLException e) {
            throw new BOSException("get personinfo error", (Throwable)e);
        }
        if (receiverId != null && receiverId.length() > 0) {
            String title = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaMsg3", (Locale)ctx.getOriginLocale()), schemaName);
            Map returnValue = new HashMap();
            BMCMessageInfo msgInfo = new BMCMessageInfo();
            IObjectPK idpk = BMCMessageFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)msgInfo);
            returnValue = this.sendInstantMsg(receiverId, priorty, title, message, msgInfo.getId().toString(), ctx);
            ArrayList list = new ArrayList();
            list.add(returnValue);
            JSONUtil.getJson4List(list, null);
        }
    }

    public Map sendInstantMsg(String personIds, String priorty, String title, String content, String msgBosID, Context ctx) {
        HashMap resultMap = new HashMap();
        HashMap failMap = new HashMap();
        Locale locale = ProcessCenterUtil.getLocale((Context)ctx);
        try {
            priorty = URLDecoder.decode(priorty, "UTF-8");
            title = URLDecoder.decode(title, "UTF-8");
            content = URLDecoder.decode(content, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        int pritotyValue = Integer.parseInt(priorty);
        msgInfo.setPriority(MsgPriority.getEnum((int)pritotyValue));
        if (!StringUtils.isEmpty((String)title)) {
            title = title.trim();
        }
        msgInfo.setTitle(title, new Locale("l1"));
        msgInfo.setTitle(title, new Locale("l2"));
        msgInfo.setTitle(title, new Locale("l3"));
        if (!StringUtils.isEmpty((String)content)) {
            content = content.trim();
        }
        msgInfo.setBody(content, new Locale("l1"));
        msgInfo.setBody(content, new Locale("l2"));
        msgInfo.setBody(content, new Locale("l3"));
        msgInfo.setType(MsgType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        IUser iUser = null;
        IBMCMessage iBMCMessage = null;
        UserInfo userInfo = null;
        String receiverNames = "";
        BasReceiverCollection receivers = new BasReceiverCollection();
        StringBuffer validName = new StringBuffer();
        StringBuffer invalidName = new StringBuffer();
        try {
            iUser = UserFactory.getLocalInstance((Context)ctx);
            iBMCMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
            userInfo = iUser.getUserInfo(ctx.getCaller());
            Map activeReceiverMap = ProcessCenterUtil.getUserByPerson((Context)ctx, (String)personIds);
            Iterator activeReceiverId = null;
            if (activeReceiverMap.isEmpty()) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.base.message.MessageCenter", (String)"sendFailedLog2", (Locale)locale));
                return failMap;
            }
            activeReceiverId = activeReceiverMap.keySet().iterator();
            Map receiverMap = ProcessCenterUtil.getReceiverMap((Context)ctx, (String)personIds);
            while (activeReceiverId.hasNext()) {
                String receiverId = activeReceiverId.next().toString();
                if (receiverMap.containsKey(receiverId)) {
                    validName.append(receiverMap.get(receiverId)).append(",");
                    continue;
                }
                invalidName.append(receiverMap.get(receiverId)).append(",");
            }
            if (validName.length() > 0) {
                receiverNames = validName.substring(0, validName.length() - 1);
            }
            receivers = ProcessCenterUtil.getBasReceiverCollection((Map)activeReceiverMap);
            msgInfo.setSender(userInfo.getName());
            msgInfo.setNreceivers(receiverNames);
            this.addHandMsg(ctx, (IObjectValue)msgInfo, (IObjectCollection)receivers, iBMCMessage);
            return resultMap;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
    }

    protected void addHandMsg(Context ctx, IObjectValue msgInfo, IObjectCollection receiverCollection, IBMCMessage iBMCMessage) throws BOSException {
        Iterator ids;
        BMCMessageInfo mInfo = (BMCMessageInfo)msgInfo;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        mInfo.setReceiveTime(cuttentDate);
        mInfo.setSendTime(cuttentDate);
        mInfo.setBizType(MsgBizType.ONLINE);
        mInfo.setSenderId(ctx.getCaller().toString());
        BasReceiverCollection receivers = (BasReceiverCollection)receiverCollection;
        BasReceiverInfo info = null;
        HashMap userIdMap = new HashMap();
        ReceiversUtil util = new ReceiversUtil();
        util.setCtx(ctx);
        ArrayList list = null;
        MsgSendRecordInfo msrInfo = new MsgSendRecordInfo();
        ObjectUuidPK recordPk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)msrInfo.getBOSType()));
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        if (receivers != null && receivers.size() > 0) {
            for (int i = 0; i < receivers.size(); ++i) {
                info = receivers.get(i);
                if (info.getType().equals("1") || info.getType().equals("3")) {
                    userIdMap.put(info.getValue(), null);
                    continue;
                }
                if (info.getType().equals("0") || info.getType().equals("5")) {
                    try {
                        list = util.getUserIDsByAdminOrgUnit(info.getValue());
                        for (int j = 0; j < list.size(); ++j) {
                            userIdMap.put((String)list.get(j), null);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (info.getType().equals("2")) {
                    IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
                    IMAGroupResolventEntry ire = MAGroupResolventEntryFactory.getLocalInstance((Context)ctx);
                    IMAGroup im = MAGroupFactory.getLocalInstance((Context)ctx);
                    IMAGroupEntry ime = MAGroupEntryFactory.getLocalInstance((Context)ctx);
                    String personid = "";
                    String sql1 = "select FID from T_PM_User where FPersonId=?";
                    StringBuffer sb = new StringBuffer();
                    try {
                        MAGroupResolventInfo mainfo = MAGroupResolventFactory.getLocalInstance((Context)ctx).getMAGroupResolventInfo("select * where id = '" + info.getValue() + "'");
                        for (int n = 0; n < mainfo.getEntries().size(); ++n) {
                            MAGroupResolventEntryInfo entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(mainfo.getEntries().get(n).getId().toString()));
                            MAGroupInfo magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
                            if (magroupInfo == null) continue;
                            for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                                MAGroupEntryInfo magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                                if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString()))) continue;
                                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{personid});
                                try {
                                    while (rs.next()) {
                                        userIdMap.put(rs.getString("FID"), null);
                                    }
                                    continue;
                                }
                                catch (SQLException e) {
                                    logger.error((Object)"_addHandMsg SQLException failed!", (Throwable)e);
                                }
                            }
                        }
                        continue;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"_addHandMsg EASBizException failed!", (Throwable)e);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)"_addHandMsg BOSException failed!", (Throwable)e);
                        continue;
                    }
                }
                if (info.getType().equals("8")) {
                    UserCollection usercol = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select * where person = '" + info.getValue().toString() + "'");
                    for (UserInfo userInfo : usercol) {
                        if (userInfo == null) continue;
                        userIdMap.put(userInfo.getId().toString(), null);
                    }
                    continue;
                }
                if (!info.getType().equals("9")) continue;
                UserCollection uc = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select * where type <> 20 and isDelete = 0 and isLocked = 0 and isForbidden = 0 and cu = '" + info.getValue().toString() + "'");
                Iterator it1 = uc.iterator();
                UserInfo ui = null;
                while (it1.hasNext()) {
                    ui = (UserInfo)it1.next();
                    userIdMap.put(ui.getId().toString(), null);
                }
            }
        }
        String id = null;
        if (mInfo.getId() != null) {
            id = mInfo.getId().toString();
        }
        if ((ids = userIdMap.keySet().iterator()).hasNext()) {
            mInfo.setReceiver((String)ids.next());
            try {
                IObjectPK pk;
                if (id != null) {
                    pk = new ObjectUuidPK(id);
                    iBMCMessage.submit(pk, (CoreBaseInfo)mInfo);
                } else {
                    pk = iBMCMessage.submit((CoreBaseInfo)mInfo);
                    id = pk.toString();
                }
                msrInfo.setSenderID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
                msrInfo.setSendTime(new Timestamp(new Date().getTime()));
                msrInfo.setTitle(mInfo.getTitle(), l1);
                msrInfo.setTitle(mInfo.getTitle(), l2);
                msrInfo.setTitle(mInfo.getTitle(), l3);
                msrInfo.setBody(mInfo.getBody(), l1);
                msrInfo.setBody(mInfo.getBody(), l2);
                msrInfo.setBody(mInfo.getBody(), l3);
                msrInfo.setReciever(mInfo.getNreceivers(), l1);
                msrInfo.setReciever(mInfo.getNreceivers(), l2);
                msrInfo.setReciever(mInfo.getNreceivers(), l3);
                msrInfo.setPriority(mInfo.getPriority());
                msrInfo.setSourceID(mInfo.getId());
                if (WebServiceControlUtil.isToOtherSys()) {
                    MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage((BMCMessageInfo)mInfo, (Context)ctx), ctx);
                }
                if (WebServiceControlUtil.isLetOtherSysGet()) {
                    MsgUnreadCountFactory.getLocalInstance((Context)ctx).unReadCount(mInfo.getReceiver(), mInfo.getReceiveTime());
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        AttachmentServerManager attmanager = AttachmentManagerFactory.getServerManager((Context)ctx);
        while (ids.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)mInfo.getBOSType()));
            mInfo.setReceiver((String)ids.next());
            try {
                iBMCMessage.addnew((IObjectPK)pk, (CoreBaseInfo)mInfo);
                attmanager.copyBizRelation(id, pk.toString());
                if (WebServiceControlUtil.isToOtherSys()) {
                    MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage((BMCMessageInfo)mInfo, (Context)ctx), ctx);
                }
                if (!WebServiceControlUtil.isLetOtherSysGet()) continue;
                MsgUnreadCountFactory.getLocalInstance((Context)ctx).unReadCount(mInfo.getReceiver(), mInfo.getReceiveTime());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            attmanager.copyBizRelation(id, recordPk.toString());
            MsgSendRecordFactory.getLocalInstance((Context)ctx).addnew((IObjectPK)recordPk, (CoreBaseInfo)msrInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_addHandMsg Exception failed!", (Throwable)e);
        }
    }

    private ISCMRobotExecutor getTaskExecutor(SCMRobotTask curTask) {
        SCMRobotOperationInfo operation = curTask.getOperation();
        OperationTypeEnum operationType = operation.getOperationType();
        switch (operationType.getValue()) {
            case 2: {
                return new SCMRobotVoucherExecutor();
            }
            case 4: {
                return new SCMRobotVoucherExecutor();
            }
            case 1: {
                return new SCMRobotBillTransExecutor();
            }
            case 0: {
                return new SCMRobotBillOprtExecutor();
            }
            case 3: {
                return new SCMRobotOtherOprtExecutor();
            }
        }
        return null;
    }

    private String checkImpClass(Context ctx, SCMRobotTask curTask) {
        String className = null;
        String result = null;
        SCMRobotOperationInfo operation = curTask.getOperation();
        if (operation != null && StringUtils.isEmpty((String)(className = operation.getClassNameFull()))) {
            result = EASResource.getString((String)RES, (String)"schemaNoImpClass", (Locale)ctx.getOriginLocale());
        }
        if (!StringUtils.isEmpty(className) && StringUtils.isEmpty(result)) {
            try {
                Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)e);
                result = EASResource.getString((String)RES, (String)"getImpClassErr", (Locale)ctx.getOriginLocale());
            }
        }
        return result;
    }

    private MutexParameter getMutexParam(Context ctx, SCMRobotTask curTask) throws BOSException {
        SCMRobotSchemaInfo schemaInfo = curTask.getSchemaInfo();
        SCMRobotSchemaEntryInfo entryInfo = curTask.getEntryInfo();
        SCMRobotSchemaOrgEntryInfo orgEntryInfo = curTask.getOrgEntryInfo();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = currentUserInfo.getId().toString();
        String orgId = orgEntryInfo.getOrgUnit().getId().toString();
        MutexParameter mp = this.buildModifyMutexParameter(ctx, ctx.getAIS(), schemaInfo.getId().toString(), entryInfo.getId().toString(), orgId, userId, "SCM_robot", null, MutexLockType.EXCLUSIVE_LOCK);
        return mp;
    }

    private MutexParameter buildModifyMutexParameter(Context ctx, String dcName, String schemaID, String entryID, String orgID, String userId, String actionResName, String actionDetail, MutexLockType type) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        if (entryID != null) {
            mp.setMutexName("SCM_Robot_" + schemaID + "_" + entryID + "_" + orgID);
        } else {
            mp.setMutexName("SCM_Robot_" + schemaID);
        }
        String actionName = ResourceBase.getString((String)RES, (String)actionResName, (Locale)ctx.getLocale());
        if (actionDetail != null && actionDetail.trim().length() > 0) {
            actionName = actionName + "[" + actionDetail.trim() + "]";
        }
        mp.setActionName(actionName);
        if (orgID != null) {
            mp.setOrgUnitID(BOSUuid.read((String)orgID));
        }
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(type);
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = ResourceBase.getString((String)RES, (String)"SCM_robot", (Locale)ctx.getLocale());
        mp.setDescription(description);
        return mp;
    }

    protected List checkExcuteState(Context ctx, String schemaID) throws BOSException, EASBizException {
        boolean isRunning;
        ArrayList<String> result = new ArrayList<String>();
        String error = "";
        Locale loc = ctx.getOriginLocale();
        if (schemaID == null || schemaID.equals("") || "null".equals(schemaID)) {
            error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
            result.add(error);
            return result;
        }
        boolean isExist = SCMRobotSchemaFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(schemaID));
        if (!isExist) {
            error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
            result.add(error);
            return result;
        }
        SCMRobotSchemaInfo schemaInfo = SCMRobotSchemaFactory.getLocalInstance(ctx).getSCMRobotSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID));
        if (!schemaInfo.getStatus().equals((Object)UseStatusEnum.ACTIVE)) {
            error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaIsAddCantProcess", (Locale)loc), schemaInfo.getNumber());
            result.add(error);
            return result;
        }
        String scheduleID = null;
        if (schemaInfo.getSchedule() != null) {
            scheduleID = schemaInfo.getSchedule().getId().toString();
        }
        Object scheduleInfo = null;
        if (scheduleID != null && (isRunning = this.getSchemaProcessState(ctx, schemaID))) {
            error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaIsProcess", (Locale)loc), schemaInfo.getNumber());
            result.add(error);
            return result;
        }
        return result;
    }

    private boolean getSchemaProcessState(Context ctx, String schemaID) throws BOSException {
        boolean isProcess = false;
        String sql = "SELECT top 1 fid FROM T_SCM_SCMRobotExecuteAccount where FSchemaId = '" + schemaID + "' and  FState in (0,1) ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                isProcess = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isProcess;
    }

    private boolean getEntryProcessState(Context ctx, String schemaID, String entryId, String orgEntryId) throws BOSException {
        boolean isProcess = false;
        String sql = "SELECT top 1 fid FROM T_SCM_SCMRobotExecuteAccount where FSchemaId = ? and FSchemaEntryID = ? and FSchemaOrgEntryID = ? and  FState in (0,1) ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{schemaID, entryId, orgEntryId});
        try {
            if (rs.next()) {
                isProcess = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isProcess;
    }

    @Override
    protected Map _createEntryTask(Context ctx, List schemaList) throws BOSException, EASBizException {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        ArrayList<String> result = new ArrayList<String>();
        Locale loc = ctx.getOriginLocale();
        String error = "";
        String scheduleID = null;
        SCMRobotExecuteAccountRecoder recoder = new SCMRobotExecuteAccountRecoder();
        int size = schemaList.size();
        for (int i = 0; i < size; ++i) {
            Map schemaEE = (Map)schemaList.get(i);
            String schemaID = schemaEE.get("schemaID").toString();
            String busiEntryId = schemaEE.get("businessEntryID").toString();
            String comEntryId = schemaEE.get("companyEntryID").toString();
            if (schemaID == null || schemaID.equals("")) {
                error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
                result.add(error);
                continue;
            }
            boolean isExist = SCMRobotSchemaFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(schemaID));
            if (!isExist) {
                error = EASResource.getString((String)RES, (String)"noCurSchema", (Locale)loc);
                result.add(error);
                continue;
            }
            SCMRobotSchemaInfo schemaInfo = SCMRobotSchemaFactory.getLocalInstance(ctx).getSCMRobotSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID));
            if (!schemaInfo.getStatus().equals((Object)UseStatusEnum.ACTIVE)) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaIsAddCantProcess", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            if (!SCMRobotSchemaEntryFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(busiEntryId))) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaBusiEntryIsNull", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            if (!SCMRobotSchemaOrgEntryFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(comEntryId))) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaComEntryIsNull", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            if (schemaInfo.getSchedule() != null) {
                scheduleID = schemaInfo.getSchedule().getId().toString();
            }
            if (scheduleID != null && this.getEntryProcessState(ctx, schemaID, busiEntryId, comEntryId)) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"schemaIsProcess", (Locale)loc), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)comEntryId, CompareType.EQUALS));
            view.setFilter(filter);
            view.setSelector(this.getOrgEntrySelector());
            CoreBillEntryBaseCollection coreBillColl = SCMRobotSchemaOrgEntryFactory.getLocalInstance(ctx).getCoreBillEntryBaseCollection(view);
            SCMRobotSchemaOrgEntryInfo orgEntryInfo = (SCMRobotSchemaOrgEntryInfo)coreBillColl.get(0);
            schemaInfo = orgEntryInfo.getParent1().getParent();
            SCMRobotSchemaEntryInfo entryInfo = orgEntryInfo.getParent1();
            recoder.addNewReport(ctx, schemaInfo, entryInfo, orgEntryInfo, ContextUtil.getCurrentUserInfo((Context)ctx), uuid, i, null);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("error", result);
        resultMap.put("guuid", uuid);
        return resultMap;
    }

    @Override
    protected Map _cancelEntryTask(Context ctx, List schemaList) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        int updateCount = 0;
        String cancelSql = "update T_SCM_SCMROBOTEXECUTEACCOUNT set fstate = 2 where FSCHEMAID = ? and FSCHEMAENTRYID = ? and FSCHEMAORGENTRYID = ? and fstate = 0";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(cancelSql);
            int size = schemaList.size();
            for (int i = 0; i < size; ++i) {
                Map schemaEE = (Map)schemaList.get(i);
                String schemaID = schemaEE.get("schemaID").toString();
                String busiEntryId = schemaEE.get("businessEntryID").toString();
                String comEntryId = schemaEE.get("companyEntryID").toString();
                stmt.setString(1, schemaID);
                stmt.setString(2, busiEntryId);
                stmt.setString(3, comEntryId);
                updateCount += stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        HashMap<String, Integer> rsMap = new HashMap<String, Integer>();
        rsMap.put("updateCount", updateCount);
        return rsMap;
    }

    @Override
    protected Map _stopTask(Context ctx, List executeAccountIds) throws BOSException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < executeAccountIds.size(); ++i) {
            ids.append("'").append(executeAccountIds.get(i)).append("',");
        }
        ids.setLength(ids.length() - 1);
        StringBuffer sql = new StringBuffer();
        String msg = SCMUtils.getResource((String)RES, (String)"stopTask", (Context)ctx);
        sql.append("update T_SCM_SCMROBOTEXECUTEACCOUNT set fstate = 2, FENDTIME = getdate()");
        sql.append(", FSUCCESSCOUNT = 0, FAILEDCOUNT = 0, FRESULT = '").append(msg).append("'");
        sql.append("where fid in (").append(ids.toString()).append(")");
        sql.append(" and fstate <> 2");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return null;
    }

    @Override
    protected Map _createExcuteTask(Context ctx, String schemaIDs) throws BOSException, EASBizException {
        String[] schemaArr = schemaIDs.split(",");
        String a = "";
        ArrayList totalResult = new ArrayList();
        HashSet<String> schemaSet = new HashSet<String>();
        schemaSet.add("111111111111111111111111111=");
        for (int i = 0; i < schemaArr.length; ++i) {
            List result = this.checkExcuteState(ctx, schemaArr[i]);
            if (result != null && result.size() > 0) {
                totalResult.addAll(result);
                continue;
            }
            schemaSet.add(schemaArr[i]);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        ArrayList schemaParamList = new ArrayList();
        Object schemaAllTaskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", schemaSet, CompareType.INCLUDE));
        view.setSelector(this.getScheamSelector());
        view.setFilter(filter);
        SCMRobotSchemaCollection schemaCollection = SCMRobotSchemaFactory.getLocalInstance(ctx).getSCMRobotSchemaCollection(view);
        SCMRobotSchemaInfo info = null;
        int seq = 0;
        int size = schemaCollection.size();
        for (int i = 0; i < size; ++i) {
            info = schemaCollection.get(i);
            seq = this.addReportInfo(ctx, uuid, info, seq);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("error", totalResult);
        resultMap.put("guuid", uuid);
        return resultMap;
    }

    private int addReportInfo(Context ctx, String uuid, SCMRobotSchemaInfo info, int seq) throws EASBizException, BOSException {
        SCMRobotSchemaEntryCollection entrys = info.getEntry();
        SCMRobotSchemaEntryInfo entry = null;
        SCMRobotSchemaOrgEntryCollection orgEntrys = null;
        SCMRobotSchemaOrgEntryInfo orgEntry = null;
        SCMRobotExecuteAccountRecoder recoder = new SCMRobotExecuteAccountRecoder();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entry = entrys.get(i);
            orgEntrys = entry.getOrgEntry();
            int orgSize = orgEntrys.size();
            for (int j = 0; j < orgSize; ++j) {
                orgEntry = orgEntrys.get(j);
                recoder.addNewReport(ctx, info, entry, orgEntry, ContextUtil.getCurrentUserInfo((Context)ctx), uuid, ++seq, null);
            }
        }
        return seq;
    }

    private SCMRobotTask buildSCMRobotTask(Context ctx, String reportID, String periodNum) throws EASBizException, BOSException {
        SCMRobotExecuteAccountInfo reportInfo = SCMRobotExecuteAccountFactory.getLocalInstance(ctx).getSCMRobotExecuteAccountInfo((IObjectPK)new ObjectUuidPK(reportID), this.getReportSelector());
        UserInfo currUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        SCMRobotSchemaEntryInfo entryInfo = reportInfo.getSchemaEntry();
        SCMRobotSchemaOrgEntryInfo orgEntry = reportInfo.getSchemaOrgEntry();
        SCMRobotOperationInfo operationInfo = entryInfo.getOperation();
        String orgID = orgEntry.getOrgUnit().getId().toString();
        SCMRobotTask task = new SCMRobotTask(reportInfo);
        task.setExecutor(currUser);
        task.setReportInfo(reportInfo);
        CompanyOrgUnitInfo company = null;
        if (operationInfo.getOrgType() != OrgType.Company) {
            OrgUnitCollection companyCol = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)operationInfo.getOrgType(), (OrgType)OrgType.Company, (String)orgID);
            company = (CompanyOrgUnitInfo)companyCol.get(0);
        } else {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        }
        if (company == null) {
            throw new SCMRobotException(SCMRobotException.COMPANYORGNULL);
        }
        PeriodInfo periodInfo = null;
        if (company != null) {
            if (!StringUtils.isEmpty((String)periodNum) && !periodNum.equals("null") && company.getAccountPeriodType() != null) {
                int periodNumb = Integer.valueOf(periodNum);
                periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(periodNumb / 100, periodNumb % 100, company.getAccountPeriodType());
            } else {
                SystemEnum subSystem = operationInfo.getSubSystem();
                if (subSystem != SystemEnum.ACCOUNTSRECEIVABLE && subSystem != SystemEnum.ACCOUNTSPAYABLE) {
                    subSystem = SystemEnum.INVENTORYMANAGEMENT;
                }
                periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)subSystem, (CompanyOrgUnitInfo)company);
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("curOrgUnitID", orgID);
        params.put("periodInfo", (String)periodInfo);
        if (operationInfo.isHasParam()) {
            String paramSql = entryInfo.getParamSql();
            HashMap praseParam = JSONUtils.convertJsonToObject((Context)ctx, (String)paramSql);
            params.putAll(praseParam);
        }
        task.setParams(params);
        task.setPeriodInfo(periodInfo);
        task.setReportId(reportID);
        task.setCompanyId(company.getId().toString());
        return task;
    }

    public SelectorItemCollection getScheamSelector() {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("name"));
        sics.add(new SelectorItemInfo("status"));
        sics.add(new SelectorItemInfo("schedule.creator"));
        sics.add(new SelectorItemInfo("entry.filterSql"));
        sics.add(new SelectorItemInfo("entry.botp"));
        sics.add(new SelectorItemInfo("entry.paramSql"));
        sics.add(new SelectorItemInfo("entry.operation.operationType"));
        sics.add(new SelectorItemInfo("entry.operation.businessNumber"));
        sics.add(new SelectorItemInfo("entry.operation.bussinessName"));
        sics.add(new SelectorItemInfo("entry.operation.billBosType"));
        sics.add(new SelectorItemInfo("entry.operation.operationName"));
        sics.add(new SelectorItemInfo("entry.operation.operationNumber"));
        sics.add(new SelectorItemInfo("entry.operation.classNameFull"));
        sics.add(new SelectorItemInfo("entry.operation.orgType"));
        sics.add(new SelectorItemInfo("entry.operation.hasParam"));
        sics.add(new SelectorItemInfo("entry.operation.status"));
        sics.add(new SelectorItemInfo("entry.operation.desBillBosType"));
        sics.add(new SelectorItemInfo("entry.operation.desBillName"));
        sics.add(new SelectorItemInfo("entry.operation.queryInfo"));
        sics.add(new SelectorItemInfo("entry.operation.subSystem"));
        sics.add(new SelectorItemInfo("entry.orgEntry.orgUnit.id"));
        sics.add(new SelectorItemInfo("entry.orgEntry.orgUnit.number"));
        sics.add(new SelectorItemInfo("entry.orgEntry.orgUnit.name"));
        return sics;
    }

    public SelectorItemCollection getOrgEntrySelector() {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("parent1.parent.id"));
        sics.add(new SelectorItemInfo("parent1.parent.number"));
        sics.add(new SelectorItemInfo("parent1.parent.name"));
        sics.add(new SelectorItemInfo("parent1.parent.status"));
        sics.add(new SelectorItemInfo("parent1.parent.schedule.creator"));
        sics.add(new SelectorItemInfo("parent1.filterSql"));
        sics.add(new SelectorItemInfo("parent1.botp"));
        sics.add(new SelectorItemInfo("parent1.paramSql"));
        sics.add(new SelectorItemInfo("parent1.operation.operationType"));
        sics.add(new SelectorItemInfo("parent1.operation.businessNumber"));
        sics.add(new SelectorItemInfo("parent1.operation.bussinessName"));
        sics.add(new SelectorItemInfo("parent1.operation.billBosType"));
        sics.add(new SelectorItemInfo("parent1.operation.operationName"));
        sics.add(new SelectorItemInfo("parent1.operation.operationNumber"));
        sics.add(new SelectorItemInfo("parent1.operation.classNameFull"));
        sics.add(new SelectorItemInfo("parent1.operation.orgType"));
        sics.add(new SelectorItemInfo("parent1.operation.hasParam"));
        sics.add(new SelectorItemInfo("parent1.operation.status"));
        sics.add(new SelectorItemInfo("parent1.operation.desBillBosType"));
        sics.add(new SelectorItemInfo("parent1.operation.desBillName"));
        sics.add(new SelectorItemInfo("parent1.operation.queryInfo"));
        sics.add(new SelectorItemInfo("parent1.operation.subSystem"));
        sics.add(new SelectorItemInfo("orgUnit.id"));
        sics.add(new SelectorItemInfo("orgUnit.number"));
        sics.add(new SelectorItemInfo("orgUnit.name"));
        return sics;
    }

    public SelectorItemCollection getReportSelector() {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("seq"));
        sics.add(new SelectorItemInfo("schemaNumber"));
        sics.add(new SelectorItemInfo("schemaName"));
        sics.add(new SelectorItemInfo("operationId"));
        sics.add(new SelectorItemInfo("businessName"));
        sics.add(new SelectorItemInfo("operationNumber"));
        sics.add(new SelectorItemInfo("operationName"));
        sics.add(new SelectorItemInfo("orgUnit"));
        sics.add(new SelectorItemInfo("guuID"));
        sics.add(new SelectorItemInfo("schema.name"));
        sics.add(new SelectorItemInfo("schema.number"));
        sics.add(new SelectorItemInfo("schema.status"));
        sics.add(new SelectorItemInfo("schema.schedule.creator"));
        sics.add(new SelectorItemInfo("schemaEntry.filterSql"));
        sics.add(new SelectorItemInfo("schemaEntry.botp"));
        sics.add(new SelectorItemInfo("schemaEntry.paramSql"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.operationType"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.businessNumber"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.bussinessName"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.billBosType"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.operationName"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.operationNumber"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.classNameFull"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.orgType"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.hasParam"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.status"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.desBillBosType"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.desBillName"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.queryInfo"));
        sics.add(new SelectorItemInfo("schemaEntry.operation.subSystem"));
        sics.add(new SelectorItemInfo("schemaOrgEntry.orgUnit.id"));
        sics.add(new SelectorItemInfo("schemaOrgEntry.orgUnit.number"));
        sics.add(new SelectorItemInfo("schemaOrgEntry.orgUnit.name"));
        return sics;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK userPk = ctx.getCaller();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        permission.checkFunctionPermission(userPk, null, "scmrobot_delete");
        SCMRobotSchemaInfo schemaInfo = SCMRobotSchemaFactory.getLocalInstance(ctx).getSCMRobotSchemaInfo(pk);
        if (UseStatusEnum.SAVED != schemaInfo.getStatus()) {
            throw new SCMRobotException(SCMRobotException.NOTSAVE2DELETE);
        }
        if (schemaInfo.getSchedule() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scmRobotSchema", (Object)schemaInfo.getId().toString(), CompareType.EQUALS));
            SCMRobotScheduleFactory.getLocalInstance(ctx).delete(filter);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected List _deleteSchema(Context ctx, String ids) throws BOSException, EASBizException {
        IObjectPK userPk = ctx.getCaller();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        permission.checkFunctionPermission(userPk, null, "scmrobot_delete");
        ArrayList<String> result = new ArrayList<String>();
        String[] schemaArr = ids.split(",");
        String error = "";
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < schemaArr.length; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(schemaArr[i]);
            SCMRobotSchemaInfo schemaInfo = SCMRobotSchemaFactory.getLocalInstance(ctx).getSCMRobotSchemaInfo((IObjectPK)pk);
            if (UseStatusEnum.SAVED != schemaInfo.getStatus()) {
                error = MessageFormat.format(EASResource.getString((String)RES, (String)"notSave2Delete"), schemaInfo.getNumber());
                result.add(error);
                continue;
            }
            idSet.add(schemaArr[i]);
        }
        if (idSet != null && idSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scmRobotSchema", idSet, CompareType.INCLUDE));
            SCMRobotScheduleFactory.getLocalInstance(ctx).delete(filter);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            SCMRobotSchemaFactory.getLocalInstance(ctx).delete(filter);
        }
        return result;
    }
}

