/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app.executor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.app.dap.BotEngineNew;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryInfo;
import com.kingdee.eas.scm.framework.robot.app.executor.ISCMRobotExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotTask;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public abstract class AbstractSCMRobotExecutor
implements ISCMRobotExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.robot.app.executor.AbstractSCMRobotExecutor");
    protected static final String RES = "com.kingdee.eas.scm.framework.SCMRobotResource";

    protected int getMaxBillNumber(Context ctx) {
        return 5000;
    }

    @Override
    public abstract Map excute(Context var1, SCMRobotTask var2) throws EASBizException, BOSException;

    protected Object[] splitAry(IObjectPK[] ary, int subSize) {
        int count = ary.length % subSize == 0 ? ary.length / subSize : ary.length / subSize + 1;
        ArrayList subAryList = new ArrayList();
        for (int i = 0; i < count; ++i) {
            int index = i * subSize;
            ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
            for (int j = 0; j < subSize && index < ary.length; ++j) {
                list.add(ary[index++]);
            }
            subAryList.add(list);
        }
        Object[] subAry = new Object[subAryList.size()];
        for (int i = 0; i < subAryList.size(); ++i) {
            List subList = (List)subAryList.get(i);
            IObjectPK[] subAryItem = new IObjectPK[subList.size()];
            for (int j = 0; j < subList.size(); ++j) {
                subAryItem[j] = (IObjectPK)subList.get(j);
            }
            subAry[i] = subAryItem;
        }
        return subAry;
    }

    protected boolean checkRebuild(Context ctx, List srcBillIdList, List destBillIdList, String mappingId) throws BOSException, EASBizException {
        String destId;
        BOSObjectType destType;
        if (srcBillIdList == null || srcBillIdList.size() == 0 || StringUtils.isEmpty((String)mappingId)) {
            throw new BOSException("Invalid parameter! SrcBillIdList or mappingId is invalid!");
        }
        BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(mappingId, ctx);
        BOSObjectType srcBosType = null;
        srcBosType = mappingInfo.getDestEntity() == null ? BOSObjectType.create((String)mappingInfo.getSrcEntityName()) : mappingInfo.getSrcEntity().getBOSType();
        if ("B84FB1E2".equals(srcBosType.toString())) {
            return true;
        }
        BOSObjectType destBosType = null;
        destBosType = mappingInfo.getDestEntity() == null ? BOSObjectType.create((String)mappingInfo.getDestEntityName()) : mappingInfo.getDestEntity().getBOSType();
        if (destBillIdList != null && destBillIdList.size() > 0 && !destBosType.equals((Object)(destType = BOSUuid.read((String)(destId = destBillIdList.get(0).toString())).getType()))) {
            throw new BOSException("Invalid parameter! DestBillId doesn't match the mappingInfo!");
        }
        String reBuildControl = "";
        String extconfig = mappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
        if (extconfig != null && !extconfig.equals("")) {
            try {
                info = processor.marshallingExtConfig(extconfig);
                reBuildControl = info.getReBuildControl();
                if (reBuildControl.equals("2") && this.hasReBuild(ctx, srcBillIdList, destBillIdList, destBosType.toString())) {
                    return false;
                }
            }
            catch (DocumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean hasReBuild(Context ctx, List idlist, List destList, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        if (destList != null && destList.size() > 0) {
            String destbillIds = StringUtils.arrayToString((Object[])destList.toArray(), (String)",");
            filterBill.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destbillIds, CompareType.NOTINCLUDE));
        }
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    public Set getOperationBillSet(Context ctx, SCMRobotTask task) throws BOSException, EASBizException {
        SCMRobotSchemaEntryInfo entryInfo = task.getEntryInfo();
        SCMRobotSchemaOrgEntryInfo orgEntryInfo = task.getOrgEntryInfo();
        SCMRobotOperationInfo operationInfo = task.getOperation();
        PeriodInfo period = task.getPeriodInfo();
        String filterSql = entryInfo.getFilterSql();
        String queryPK = operationInfo.getQueryInfo();
        Set result = new HashSet();
        FullOrgUnitInfo orgUnit = orgEntryInfo.getOrgUnit();
        String companyId = orgUnit.getId().toString();
        filterSql = this.getFilter(ctx, operationInfo, companyId, (OrgUnitInfo)orgUnit, filterSql, period);
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id where " + filterSql;
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        result = this.getBillIdSet(ctx, iexec.getSQL());
        return result;
    }

    public String getFilter(Context ctx, SCMRobotOperationInfo operationInfo, String companyID, OrgUnitInfo orgInfo, String filterSql, PeriodInfo periodInfo) throws BOSException, EASBizException {
        String className = operationInfo.getClassNameFull();
        if (className == null || "".equals(className)) {
            return null;
        }
        if (periodInfo == null) {
            try {
                SystemEnum subSystem = operationInfo.getSubSystem();
                if (subSystem != SystemEnum.ACCOUNTSRECEIVABLE && subSystem != SystemEnum.ACCOUNTSPAYABLE) {
                    subSystem = SystemEnum.INVENTORYMANAGEMENT;
                }
                periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)subSystem, (IObjectPK)new ObjectUuidPK(companyID));
            }
            catch (Exception e) {
                periodInfo = null;
            }
        }
        String billIDFilter = this.getBillFilter(ctx, orgInfo, periodInfo, className);
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ( ").append(filterSql).append(" )");
            }
        } else {
            result.append(filterSql);
        }
        return result.toString();
    }

    public String getBillFilter(Context ctx, OrgUnitInfo orgInfo, PeriodInfo periodInfo, String className) throws BOSException {
        return null;
    }

    public Set getBillIdSet(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        HashSet<String> idsSet = new HashSet<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String exeSql = KSqlUtil.optimize((String)sql);
            statement = conn.createStatement();
            rs = statement.executeQuery(exeSql);
            while (rs.next()) {
                idsSet.add(rs.getString("id"));
            }
        }
        catch (Exception exc) {
            try {
                throw new BOSException(EASResource.getString((String)RES, (String)"SCMRobot_GetSQL_Error"), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return idsSet;
    }

    public IQueryExecutor getQueryExecutor(Context ctx, IMetaDataPK queryPK, String oql) throws BOSException {
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(oql);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        return exec;
    }

    public Map getProcessResultCount(Context ctx, String reportID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fstate,count(1) FresultCount FROM T_SCM_SCMRobotExecuteDetail where fparentid = ? group by fstate");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{reportID});
        int successCount = 0;
        int failCount = 0;
        try {
            while (rs.next()) {
                if (rs.getInt("fstate") == 1) {
                    failCount = rs.getInt("FresultCount");
                }
                if (rs.getInt("fstate") != 0) continue;
                successCount = rs.getInt("FresultCount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("successCount", successCount);
        resultMap.put("failCount", failCount);
        return resultMap;
    }

    protected List getSplitidList(Context ctx, String billBosType, Set idSet, String desType, String botpRuleId) throws EASBizException, BOSException {
        BotEngineNew botEngineNew = new BotEngineNew();
        String[] idArr = idSet.toArray(new String[0]);
        Map transGroups = botEngineNew.preMerge(ctx, idArr, botpRuleId);
        Set entrySet = transGroups.entrySet();
        Iterator it = null;
        ObjectUuidPK rulePk = new ObjectUuidPK(botpRuleId);
        BOSObjectType bosType = BOSObjectType.create((String)billBosType);
        BOSObjectType desBosType = BOSObjectType.create((String)desType);
        int maxNumber = this.getMaxBillNumber(ctx);
        ArrayList<IObjectPK[]> result = new ArrayList<IObjectPK[]>();
        for (Map.Entry entry : entrySet) {
            IObjectPK[] srcBillPks = new IObjectPK[]{};
            srcBillPks = ((List)entry.getValue()).toArray(srcBillPks);
            Object[] splitAry = null;
            if (srcBillPks.length > maxNumber) {
                splitAry = this.splitAry(srcBillPks, maxNumber);
                result.addAll(Arrays.asList((Object[])splitAry));
                continue;
            }
            result.add(srcBillPks);
        }
        return result;
    }
}

