/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillTransProcessor;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;

public abstract class SCMRobotBillTransImpl
implements ISCMRobotBillTransProcessor {
    @Override
    public String getSouceBillFilter(Context ctx, OrgUnitInfo orgUnit, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct bill.fid from ").append(this.getBillTable()).append(" bill \n");
        sql.append(" left  join ").append(this.getEntryTable()).append(" entry on bill.fid = entry.fparentid \n");
        sql.append(" where bill.").append(this.getMainBizOrgField()).append(" = '");
        sql.append(orgUnit.getId().toString()).append("' \n");
        Boolean isBack = (Boolean)ctx.get((Object)"isBack");
        if (isBack == null || !isBack.booleanValue()) {
            if (this.usePeriodNumber()) {
                sql.append(" and bill.fyear = ").append(periodInfo.getPeriodYear()).append(" \n");
                sql.append(" and bill.fperiod = ").append(periodInfo.getPeriodNumber()).append(" \n");
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String beginDate = dateFormat.format(periodInfo.getBeginDate());
                String endDate = dateFormat.format(periodInfo.getEndDate());
                sql.append(" and bill.fbizdate >= to_date('").append(beginDate).append("') \n");
                sql.append(" and bill.fbizdate <= to_date('").append(endDate).append("') \n");
            }
        }
        if (!StringUtils.isEmpty((String)this.getStatusFilter())) {
            sql.append(" and ").append(this.getStatusFilter()).append(" \n");
        }
        if (!StringUtils.isEmpty((String)this.getExtendFilter())) {
            sql.append(" and ").append(this.getExtendFilter());
        }
        return sql.toString();
    }

    public boolean usePeriodNumber() {
        return true;
    }

    protected abstract String getBillTable();

    protected abstract String getEntryTable();

    public abstract String getMainBizOrgField();

    protected String getExtendFilter() {
        return null;
    }

    public String getStatusFilter() {
        return " bill.fbasestatus =  4";
    }
}

