/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.CustomizedSelect;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessLoader;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.PropertySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CommonQuery;
import com.kingdee.eas.base.commonquery.CommonQuerySelect;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommonUtils {
    public static IMetaDataLoader loader = null;
    public static final String PROPERTY_FULLNAME_KEY = "fullName";
    public static final String PROPERTY_LINK_TABLE = "linkTable";
    public static final String PROPERTY_LINK_FIELD = "linkField";
    public static final String PROPERTY_SEQNO_KEY = "sequenceNumber";
    public static final String PROPERTY_FULLALIAS_KEY = "fullAlias";
    public static final String PROPERTY_LINKEDBOSTYPE = "linkedBosType";
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat SIMPLE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static synchronized void initLoader(Context ctx) {
        if (loader == null) {
            loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        }
    }

    public static EntityObjectInfo getEntityByBosType(String bosType) {
        return CommonUtils.getEntityByBosType(null, bosType);
    }

    public static EntityObjectInfo getEntityByBosType(Context ctx, String bosType) {
        if (loader == null) {
            CommonUtils.initLoader(ctx);
        }
        return loader.getEntity(BOSObjectType.create((String)bosType));
    }

    public static HashMap getEntityAllInfo(String bosType) {
        return CommonUtils.getEntityAllInfo(null, bosType);
    }

    public static HashMap getEntityAllInfo(Context ctx, String bosType) {
        if (loader == null) {
            CommonUtils.initLoader(ctx);
        }
        EntityObjectInfo parentEntityObjInfo = null;
        HashMap entityPropertyInfo = new HashMap();
        HashMap<String, EntityObjectInfo> entityTypeInfo = new HashMap<String, EntityObjectInfo>();
        HashMap entityInfo = new HashMap();
        parentEntityObjInfo = loader.getEntity(BOSObjectType.create((String)bosType));
        entityTypeInfo.put(bosType, parentEntityObjInfo);
        CommonUtils.getEntityInfoByRecursionCall(entityInfo, parentEntityObjInfo, entityPropertyInfo, entityTypeInfo);
        return entityInfo;
    }

    private static void getEntityInfoByRecursionCall(HashMap entityInfo, EntityObjectInfo parentEntityObjInfo, HashMap entityPropertyInfo, HashMap entityTypeInfo) {
        PropertyInfo property = null;
        PropertyCollection col = parentEntityObjInfo.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!CommonUtils.isEntryProperty(parentEntityObjInfo, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo entryEntityObjInfo = relation.getSupplierObject();
            entityPropertyInfo.put(entryEntityObjInfo.get("bosType"), property.getName());
            entityTypeInfo.put(entryEntityObjInfo.get("bosType"), entryEntityObjInfo);
            CommonUtils.getEntityInfoByRecursionCall(entityInfo, entryEntityObjInfo, entityPropertyInfo, entityTypeInfo);
        }
        entityInfo.put("type", entityTypeInfo);
        entityInfo.put("property", entityPropertyInfo);
    }

    public static EntityObjectInfo getEntryEntityObject(EntityObjectInfo parentObject) {
        if (parentObject == null) {
            return null;
        }
        EntityObjectInfo entryEntity = null;
        PropertyCollection col = parentObject.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!CommonUtils.isEntryProperty(parentObject, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            return relation.getSupplierObject();
        }
        return entryEntity;
    }

    public static String getBillEntryPropertyName(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!CommonUtils.isEntryProperty(billEntity, property)) continue;
            return property.getName();
        }
        return entryPropertyName;
    }

    public static Map<String, EntityObjectInfo> getEntryName(EntityObjectInfo entity) {
        HashMap<String, EntityObjectInfo> map = new HashMap<String, EntityObjectInfo>();
        PropertyCollection headProColl = entity.getProperties();
        for (PropertyInfo property : headProColl) {
            RelationshipInfo relation;
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"))) continue;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                map.put(property.getName(), relation.getSupplierObject());
                continue;
            }
            if (!relation.getSupplierObject().getFullName().equals(entity.getFullName()) || relation.getClientCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getClientCardinality() != CardinalityType.ZERO_TO_UNBOUNDED) continue;
            map.put(property.getName(), relation.getClientObject());
        }
        return map;
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static EntityObjectInfo getEntityByProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        EntityObjectInfo result = null;
        if (parent != null && property != null && property instanceof LinkPropertyInfo && ((relation = ((LinkPropertyInfo)property).getRelationship()).getType() == RelationshipType.COMPOSITION || Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"))) && relation.getClientObject().getFullName().equals(parent.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
            return relation.getSupplierObject();
        }
        return result;
    }

    public static PropertyInfo getSeqNoPropertyInfo() {
        PropertyInfo seqProperty = new PropertyInfo();
        seqProperty.setName(PROPERTY_SEQNO_KEY);
        seqProperty.setAlias(EASResource.getString((String)"com.kingdee.eas.scm.barcode.BARCODEAutoGenerateResource", (String)"81_BarcodeUtils"));
        seqProperty.put("dataType", (Object)"String");
        return seqProperty;
    }

    public static PropertyInfo getPropertyByMuch(String property, EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        if (property.equals(PROPERTY_SEQNO_KEY)) {
            return CommonUtils.getSeqNoPropertyInfo();
        }
        PropertyInfo propertyInfo = entity.getPropertyByName(property);
        if (property.indexOf(".") > -1) {
            String[] ss = property.split("\\.");
            propertyInfo = entity.getPropertyByName(ss[0]);
            EntityObjectInfo entry = CommonUtils.getEntityByProperty(entity, propertyInfo);
            property = property.substring(property.indexOf(".") + 1, property.length());
            return CommonUtils.getPropertyByMuch(property, entry);
        }
        return (PropertyInfo)propertyInfo.clone();
    }

    public static Object getEnum(List emList, String value) {
        for (int i = 0; i < emList.size(); ++i) {
            com.kingdee.util.enums.Enum e = (com.kingdee.util.enums.Enum)emList.get(i);
            String compare1 = e.getName();
            String compare2 = e.getAlias();
            String compare3 = null;
            if (e instanceof IntEnum) {
                compare3 = ((IntEnum)e).getValue() + "";
            }
            if (value == null || !value.equals(compare1) && !value.equals(compare2) && !value.equals(compare3)) continue;
            return emList.get(i);
        }
        return null;
    }

    public static Object getValue(IObjectValue easValue, PropertyInfo propertyInfo, String key) {
        String dataType = propertyInfo.getString("dataType");
        Object value = easValue.get(key);
        if (value != null) {
            if (propertyInfo instanceof LinkPropertyInfo) {
                return easValue.get("number");
            }
            if ("Enum".equals(dataType)) {
                return ((com.kingdee.util.enums.Enum)value).getName();
            }
            if ("Boolean".equals(dataType)) {
                return value;
            }
            if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                String date = null;
                date = SIMPLE_DATE_FORMAT.format(value);
                return date;
            }
            if ("BigDeciaml".equals(dataType)) {
                return new BigDecimal(value.toString());
            }
            if ("Integer".equals(dataType)) {
                return Integer.parseInt(value.toString());
            }
            return value;
        }
        return null;
    }

    public static String replaceValueForEntityView(EntityObjectInfo entity, String whereSql, Object propertyValue, FilterItemInfo itemInfo, int filterItemIdex, boolean isEntryProperty) {
        Object compareValue = itemInfo.getCompareValue();
        String propertyName = itemInfo.getPropertyName();
        CompareType compareType = itemInfo.getCompareType();
        String expression = "";
        String realPropertyName = propertyName;
        if (isEntryProperty) {
            realPropertyName = propertyName.substring(propertyName.indexOf(".") + 1);
        }
        String dataType = null;
        PropertyInfo property = entity.getPropertyByName(realPropertyName);
        if (realPropertyName.split("\\.").length == 1) {
            dataType = property.getString("dataType");
        }
        if (propertyValue == null || compareValue == null) {
            expression = CommonUtils.analysisToExpression(propertyValue, compareValue, compareType);
        } else if ("Enum".equals(dataType)) {
            expression = CommonUtils.analysisToExpression(propertyValue, compareValue, compareType);
        } else if ("Boolean".equals(dataType)) {
            int value = (Boolean)propertyValue == true ? 1 : 0;
            expression = CommonUtils.analysisToExpression(value, compareValue, compareType);
        } else if ("TimeStamp".equals(dataType)) {
            long timeProperty = ((Date)propertyValue).getTime();
            long timeCompare = ((Date)compareValue).getTime();
            expression = CommonUtils.analysisToExpression(timeProperty, timeCompare, compareType);
        } else {
            expression = "Date".equals(dataType) ? CommonUtils.analysisToExpression(CommonUtils.getTime(propertyValue), CommonUtils.getTime(compareValue), compareType) : ("Integer".equals(dataType) ? CommonUtils.analysisToExpression((int)((Integer)propertyValue), (int)((Integer)compareValue), compareType) : ("BigDeciaml".equals(dataType) ? CommonUtils.analysisToExpression(((BigDecimal)propertyValue).doubleValue(), ((BigDecimal)compareValue).doubleValue(), compareType) : CommonUtils.analysisToExpression(propertyValue, compareValue, compareType)));
        }
        whereSql = whereSql.replaceFirst("#" + filterItemIdex, expression);
        return whereSql;
    }

    public static String analysisToExpression(Object propertyValue, Object compareValue, CompareType compareType) {
        String expression = null;
        if (propertyValue instanceof String || compareValue instanceof String) {
            propertyValue = propertyValue == null ? "''" : "'" + propertyValue + "'";
            compareValue = compareValue == null ? "''" : "'" + compareValue + "'";
        }
        if (compareType == CompareType.EQUALS) {
            if (propertyValue == null) {
                propertyValue = "''";
                compareValue = compareValue == null ? "''" : "'" + compareValue + "'";
            }
            expression = propertyValue + " == " + compareValue;
        } else if (compareType == CompareType.NOTEQUALS) {
            expression = propertyValue + " != " + compareValue;
        } else if (compareType == CompareType.GREATER) {
            expression = propertyValue + " > " + compareValue;
        } else if (compareType == CompareType.LESS) {
            expression = propertyValue + " < " + compareValue;
        } else if (compareType == CompareType.GREATER_EQUALS) {
            expression = propertyValue + " >= " + compareValue;
        } else if (compareType == CompareType.LESS_EQUALS) {
            expression = propertyValue + " <= " + compareValue;
        } else if (compareType == CompareType.EMPTY) {
            expression = propertyValue + " == null ";
        } else if (compareType == CompareType.NOTEMPTY) {
            expression = propertyValue + " != null ";
        } else if (compareType == CompareType.LIKE) {
            int length = compareValue.toString().length();
            int beginIndex = compareValue.toString().indexOf("%") == 0 ? 1 : 0;
            int endIndex = compareValue.toString().indexOf(37, 1) > 0 ? length - 1 : length;
            String containsString = compareValue.toString().substring(beginIndex + 2, endIndex - 1);
            expression = propertyValue.toString().contains(containsString) ? "1 == 1" : "1 != 1";
        } else if (compareType == CompareType.NOTLIKE) {
            int length = compareValue.toString().length();
            int beginIndex = compareValue.toString().indexOf("%") == 0 ? 1 : 0;
            int endIndex = compareValue.toString().indexOf(37, 1) > 0 ? length - 1 : length;
            String containsString = compareValue.toString().substring(beginIndex + 2, endIndex - 1);
            expression = propertyValue.toString().contains(containsString) ? "1 != 1" : "1 == 1";
        }
        return expression;
    }

    public static long getTime(Object propertyValue) {
        Calendar c = Calendar.getInstance();
        c.setTime((Date)propertyValue);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTimeInMillis();
    }

    public static void putValue(IObjectValue easValue, PropertyInfo propertyInfo, String key, Object value) throws BOSException {
        String dataType = propertyInfo.getString("dataType");
        if (value == null) {
            easValue.put(key, null);
        } else if ("Enum".equals(dataType)) {
            if (value instanceof Enum) {
                easValue.put(key, value);
            } else {
                String enumClass = (String)propertyInfo.get("metadataRef");
                if (enumClass != null) {
                    List emList = EnumUtils.getEnumList((String)enumClass);
                    easValue.put(key, CommonUtils.getEnum(emList, value.toString()));
                }
            }
        } else if ("Boolean".equals(dataType)) {
            if (value instanceof Boolean) {
                easValue.put(key, value);
            } else if ("1".equals(value.toString()) || "true".equalsIgnoreCase(value.toString()) || EASResource.getString((String)"com.kingdee.eas.scm.barcode.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value.toString())) {
                easValue.put(key, (Object)Boolean.TRUE);
            } else {
                easValue.put(key, (Object)Boolean.FALSE);
            }
        } else if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
            if (value instanceof Date) {
                easValue.put(key, value);
            } else {
                try {
                    Date date = SIMPLE_DATE_FORMAT.parse(value.toString());
                    easValue.put(key, (Object)date);
                }
                catch (ParseException e) {
                    throw new BOSException(e.getMessage(), e.getCause());
                }
            }
        } else if ("BigDecimal".equals(dataType)) {
            if (value instanceof BigDecimal) {
                easValue.put(key, value);
            } else {
                easValue.put(key, (Object)new BigDecimal(value.toString()));
            }
        } else if ("Integer".equals(dataType)) {
            if (value instanceof Integer) {
                easValue.put(key, value);
            } else {
                easValue.put(key, (Object)Integer.parseInt(value.toString()));
            }
        } else {
            easValue.put(key, value);
        }
    }

    public static String unicodeEncode(String str) {
        str = str == null ? "" : str;
        StringBuffer sb = new StringBuffer(1000);
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append("\\u");
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return new String(sb);
    }

    public static String unicodeDecode(String strText) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strText.length()) {
            char c = strText.charAt(i);
            if (c == '\\' && i + 1 != strText.length() && strText.charAt(i + 1) == 'u') {
                sb.append((char)Integer.parseInt(strText.substring(i + 2, i + 6), 16));
                i += 6;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static void updateLikeRowObject(RowObject rowObject, Object compValue, CompareType type) {
        String compareValue = compValue.toString();
        Vector<String> vec = CommonUtils.processStringValue(compareValue);
        for (int i = 0; i < vec.size(); ++i) {
            compareValue = vec.get(i);
            if (compareValue.indexOf("%") != -1 && (rowObject == null || rowObject.getCompare() == null || rowObject.getCompare().toLowerCase().indexOf("like") > 0)) continue;
            rowObject.setCompareValue(compValue);
            rowObject.setCompare(type.getName());
        }
    }

    public static Vector<String> processStringValue(String str) {
        Vector<String> vect = new Vector<String>();
        if (str.indexOf(",") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else {
            vect.add(str);
        }
        return vect;
    }

    public static MetaDataAccessLoader.Description getCustomQueryLoader(MetaDataPK queryPK) {
        if (queryPK != null) {
            return (MetaDataAccessLoader.Description)queryPK.getKeyValue("CustomQueryLoader");
        }
        return null;
    }

    public static Object getValue(Object object) {
        Object value = "";
        if (object != null) {
            value = object instanceof com.kingdee.util.enums.Enum ? CommonUtils.getEnumValue((com.kingdee.util.enums.Enum)object) : (object instanceof Date ? object : (object instanceof DataObject ? ((DataObject)object).getValue() : object.toString()));
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            value = value == null ? "" : ((String)value).trim();
        }
        return value;
    }

    public static Object getEnumValue(com.kingdee.util.enums.Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }

    public static boolean isEnumType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.ENUM.getName());
    }

    public static boolean isBooleanType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.BOOLEAN.getName());
    }

    public static boolean isIntType(String typeName) {
        return typeName.equals(DataType.SHORT.getName()) || typeName.equals(DataType.INTEGER.getName()) || typeName.equals(DataType.LONG.getName()) || typeName.equals(DataType.FLOAT.getName()) || typeName.equals(DataType.DOUBLE.getName()) || typeName.equals(DataType.DECIMAL.getName());
    }

    public static boolean isDateType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.DATE.getName()) || typeName.equalsIgnoreCase(DataType.TIMESTAMP.getName()) || typeName.equalsIgnoreCase(DataType.TIME.getName());
    }

    public static boolean isF7Type(String typeName) {
        return typeName.equalsIgnoreCase("F7");
    }

    public static boolean isSimpleEntityType(String typeName) {
        return typeName.equalsIgnoreCase("SIMPLE_ENTITY");
    }

    public static boolean isDateCompareSign(String signValue) {
        return signValue != null && (signValue.equalsIgnoreCase("YESTERDAY") || signValue.equalsIgnoreCase("TODAY") || signValue.equalsIgnoreCase("TOMORROW") || signValue.equalsIgnoreCase("LASTWEEK") || signValue.equalsIgnoreCase("THISWEEK") || signValue.equalsIgnoreCase("NEXTWEEK") || signValue.equalsIgnoreCase("LASTMONTH") || signValue.equalsIgnoreCase("THISMONTH") || signValue.equalsIgnoreCase("NEXTMONTH") || signValue.equalsIgnoreCase("BEFORETODAY") || signValue.equalsIgnoreCase("AFTERTODAY"));
    }

    public static IObjectValue getBizF7Data(MetaDataPK entityPK, String propertyName, Object propertyValue) throws BOSException {
        IObjectValue bizF7Data = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo(propertyName, propertyValue);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.setMaskString(" #0 ");
        entityViewInfo.setFilter(filterInfo);
        IObjectCollection collection = DynamicObjectFactory.getRemoteInstance().getCollection(MDContextFactory.getRemoteInstance().entityMapping.getProperty(entityPK.getFullName()), entityViewInfo);
        if (collection.size() > 0) {
            bizF7Data = collection.getObject(0);
        }
        return bizF7Data;
    }

    public static IObjectValue getBizF7Data(MetaDataPK queryInfo, String entityName, String queryField, Object value) throws BOSException {
        String entityPropertyName = CommonUtils.getEntityPropertyName(MetaDataPK.create((String)queryInfo.getFullName()), queryField);
        return CommonUtils.getBizF7Data(MetaDataPK.create((String)entityName), entityPropertyName, value);
    }

    public static String getEntityPropertyName(MetaDataPK queryPK, String queryFieldName) throws BOSException {
        QuerySelect select = new QuerySelect(queryPK.getFullName());
        select.propertyUnitSelect().select(queryFieldName, null).refPropertySelect().select(null, new String[0]);
        SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
        SimpleProperty[] props = query.propertyUnit(queryFieldName).getRefProperties();
        if (props != null && props.length > 0) {
            return props[0].getName();
        }
        return null;
    }

    public static String[] getDisplayFormat(MetaDataPK pk, String[] propertyName, boolean isEntity) throws BOSException {
        String[] formats = new String[propertyName.length];
        if (isEntity) {
            EntitySelect select = new EntitySelect(pk.getFullName());
            PropertySelect propSelect = select.propertySelect().select(propertyName, null);
            propSelect.extendPropertySelect().select(new String[]{"displayFormat"});
            propSelect.relatedEntitySelect().extendPropertySelect().select("defaultDisplayField");
            SimpleEntity entity = MetaDataAccessFactory.getRemoteInstance().select(select);
            for (int i = 0; i < propertyName.length; ++i) {
                SimpleEntity tmp;
                SimpleProperty prop = entity.property(propertyName[i]);
                formats[i] = prop.getExtendedProperty("displayFormat");
                if (formats[i] != null && !formats[i].trim().equalsIgnoreCase("") || (tmp = prop.getRelatedEntity()) == null) continue;
                formats[i] = "$" + tmp.getExtendedProperty("defaultDisplayField") + "$";
            }
        } else {
            CommonQuerySelect select = new CommonQuerySelect(pk.getFullName());
            select.setAccessLoader(CommonUtils.getCustomQueryLoader(pk));
            select.selectFieldFormat(propertyName, 1);
            CommonQuery query = (CommonQuery)MetaDataAccessFactory.getRemoteInstance().select((CustomizedSelect)select);
            String[][] whole = query.getFieldFormat();
            for (int i = 0; i < propertyName.length; ++i) {
                formats[i] = whole[i][0];
            }
        }
        return formats;
    }

    public static String getTimeFormatForTable(String dateType) {
        String format = "%{" + QueryUtils.getTimeFormat((String)dateType) + "}t";
        return format;
    }

    public static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    public static Set<String> processIncludeValue(String str) {
        HashSet<String> value = new HashSet<String>();
        if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                value.add(temp);
            }
        } else {
            value.add(str);
        }
        return value;
    }

    public static SimplePropertyUnit getQueryFieldInfo(MetaDataPK queryInfo, String queryFieldName) throws BOSException {
        QuerySelect select = new QuerySelect(queryInfo.getFullName());
        select.setAccessLoader(CommonUtils.getCustomQueryLoader(queryInfo));
        select.propertyUnitSelect().select(new String[]{queryFieldName}, new String[]{"displayName", "returnType"}).extendPropertySelect().select(new String[]{"displayFormat", "editFormat", "commitFormat"});
        SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
        return query.propertyUnit(queryFieldName);
    }

    public static String getEntryParentColumnField(EntityObjectInfo entryEntity, String bosType) {
        if (entryEntity == null || StringUtils.isEmpty((String)bosType)) {
            return "";
        }
        PropertyCollection col = entryEntity.getEntityProperties();
        PropertyInfo property = null;
        ColumnInfo parentColumn = null;
        String field = "";
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            RelationshipInfo relation;
            property = col.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()) == null || relation.getType() != RelationshipType.COMPOSITION || relation.getClientObject() == null || !bosType.equals(relation.getClientObject().getType().toString())) continue;
            parentColumn = property.getMappingField();
            if (parentColumn == null || StringUtils.isEmpty((String)parentColumn.getName())) break;
            field = parentColumn.getName();
            break;
        }
        return field;
    }

    public static boolean getSourceBillIDByEntityObject(IObjectValue model) {
        IObjectCollection objectColl;
        Object value;
        String entryProperyName;
        boolean hasValue = false;
        if (model == null || model.getBOSType() == null) {
            return hasValue;
        }
        String bosType = model.getBOSType().toString();
        if (("FA44FD5B".equals(bosType) || "40284E81".equals(bosType) || "9CA9D08F".equals(bosType)) && !StringUtils.isEmpty((String)(entryProperyName = CommonUtils.getBillEntryPropertyName(CommonUtils.getEntityByBosType(bosType)))) && (value = model.get(entryProperyName)) != null && value instanceof IObjectCollection && (objectColl = (IObjectCollection)value).getObject(0) != null && !StringUtils.isEmpty((String)objectColl.getObject(0).getString("sourceBillID"))) {
            hasValue = true;
        }
        return hasValue;
    }

    public static boolean isBotpBillBySourceEntryId(IObjectValue model) {
        IObjectCollection objectColl;
        Object value;
        if (model == null || model.getBOSType() == null) {
            return false;
        }
        String entryProperyName = CommonUtils.getBillEntryPropertyName(CommonUtils.getEntityByBosType(model.getBOSType().toString()));
        return !StringUtils.isEmpty((String)entryProperyName) && (value = model.get(entryProperyName)) != null && value instanceof IObjectCollection && (objectColl = (IObjectCollection)value) != null && objectColl.size() > 0 && objectColl.getObject(0) != null && objectColl.getObject(0).get("sourceBillEntryID") != null;
    }

    public static Set<String> getSourceEntryIdsByModel(IObjectValue model) {
        IObjectCollection objectColl;
        Object value;
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        String entryProperyName = CommonUtils.getBillEntryPropertyName(CommonUtils.getEntityByBosType(model.getBOSType().toString()));
        if (!StringUtils.isEmpty((String)entryProperyName) && (value = model.get(entryProperyName)) != null && value instanceof IObjectCollection && (objectColl = (IObjectCollection)value) != null && objectColl.size() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            int size = objectColl.size();
            for (int i = 0; i < size; ++i) {
                if (objectColl.getObject(i) == null || objectColl.getObject(i).get("sourceBillEntryID") == null) continue;
                idSet.add(objectColl.getObject(i).get("sourceBillEntryID").toString());
            }
            return idSet;
        }
        return null;
    }

    public static String getEntryParentName(EntityObjectInfo entryEntity, String bosType) {
        PropertyCollection col = entryEntity.getEntityProperties();
        PropertyInfo property = null;
        String field = "";
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            RelationshipInfo relation;
            property = col.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()) == null || relation.getType() != RelationshipType.COMPOSITION || relation.getClientObject() == null || !bosType.equals(relation.getClientObject().getType().toString())) continue;
            field = property.getName();
            break;
        }
        return field;
    }

    public static String getEntryParentName(EntityObjectInfo entryEntity, Map bosTypeMap) {
        if (entryEntity == null) {
            return null;
        }
        PropertyCollection col = entryEntity.getEntityProperties();
        PropertyInfo property = null;
        String field = "";
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            RelationshipInfo relation;
            property = col.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()) == null || relation.getType() != RelationshipType.COMPOSITION || relation.getClientObject() == null || entryEntity.getType().toString().equals(relation.getClientObject().getType().toString()) || !bosTypeMap.containsKey(relation.getClientObject().getType().toString())) continue;
            field = property.getName();
            break;
        }
        return field;
    }

    public static String getInID(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static boolean hasCFField(Context ctx) throws BOSException {
        String tempsql = "select 1 from ksql_usercolumns  where KSQL_COL_TABNAME = 'T_IM_PURINWAREHSENTRY'";
        tempsql = tempsql + " and KSQL_COL_NAME = 'CFISCONTRASTDREW'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tempsql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

