/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.writeoff.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.security.util.SCMSqlUtil;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.framework.util.SCMThreadLocalUtil;
import com.kingdee.eas.scm.framework.writeoff.AbstractWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonException;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.scm.framework.writeoff.app.AbstractWriteOffCommonFacadeControllerBean;
import com.kingdee.eas.scm.framework.writeoff.app.WriteOffStrategyFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class WriteOffCommonFacadeControllerBean
extends AbstractWriteOffCommonFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.writeoff");
    String tmpTable = null;

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        int queryType = params.getInt("WRITEOFF_QUERY_TYPE");
        RptParams para = new RptParams();
        List filedsList = (List)params.getObject("WRITEOFF_QUERY_SELECT_FIELD");
        FilterInfo filter = null;
        SorterItemCollection orderColl = null;
        if (queryType == 2) {
            filter = (FilterInfo)params.getObject("upQueryFilter");
            orderColl = (SorterItemCollection)params.getObject("upOrder");
        } else if (queryType == 3) {
            filter = (FilterInfo)params.getObject("downQueryFilter");
            orderColl = (SorterItemCollection)params.getObject("downOrder");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo(params.getString("EntryIdField").split("\\.")[0] + ".seq"));
        if (filedsList != null && filedsList.size() > 0) {
            Iterator iterator = filedsList.iterator();
            String fieldName = null;
            while (iterator.hasNext()) {
                fieldName = iterator.next().toString();
                sic.add(new SelectorItemInfo(fieldName));
            }
        }
        String sql = this.getExecutorSql(ctx, params.getString("WRITEOFF_QUERY_NAME"), sic, filter, orderColl, params.getString("EntryIdField").split("\\.")[0]);
        sql = this.getExecutorSql(sql, params);
        sql = this.getOptimizeSql(sql, params.getString("EntryIdField").split("\\.")[0], false);
        logger.debug((Object)((queryType == 2 ? "MAIN" : "SEC") + " QUERY SQL: " + sql));
        RptRowSet rptrs = this.executeQuery(sql, null, from, len, ctx);
        para.setObject("WRITEOFF_QUERY_ROWSET", (Object)rptrs);
        return para;
    }

    protected String getExecutorSql(String sql, RptParams params) {
        return sql;
    }

    private String getExecutorSql(Context context, String queryName, SelectorItemCollection sic, FilterInfo filter, SorterItemCollection orderColl, String entryFieldName, String billFilter) throws BOSException {
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        EntityViewInfo entityView = new EntityViewInfo();
        if (sic != null) {
            entityView.setSelector(sic);
        }
        if (filter != null) {
            entityView.setFilter(filter);
        }
        EntityViewInfo view = null;
        try {
            if (!StringUtils.isEmpty((String)billFilter)) {
                view = new EntityViewInfo(billFilter);
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        if (view != null) {
            if (entityView.getFilter() == null) {
                entityView.setFilter(view.getFilter());
            } else {
                entityView.getFilter().mergeFilter(view.getFilter(), "AND");
            }
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.option().isIgnorePermissionCheck = true;
        if (orderColl != null && orderColl.size() > 0) {
            entityView.setSorter(orderColl);
            exec.option().isIgnoreOrder = true;
        } else {
            exec.option().isIgnoreOrder = false;
        }
        exec.setObjectView(entityView);
        String sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") == -1) {
            sql = sql + " ORDER BY \"NUMBER\" ASC, \"" + entryFieldName.toUpperCase() + ".SEQ\" ASC";
        } else {
            String orderSql = sql.substring(sql.indexOf("ORDER BY"));
            if (orderSql.indexOf("\"NUMBER\"") == -1) {
                sql = sql + ", \"NUMBER\" ASC";
            }
            if (orderSql.indexOf("\"" + entryFieldName.toUpperCase() + ".SEQ\"") == -1) {
                sql = sql + ", \"" + entryFieldName.toUpperCase() + ".SEQ\" ASC";
            }
        }
        return sql;
    }

    private String getExecutorSql(Context context, String queryName, SelectorItemCollection sic, FilterInfo filter, SorterItemCollection orderColl, String entryFieldName) throws BOSException {
        return this.getExecutorSql(context, queryName, sic, filter, orderColl, entryFieldName, null);
    }

    private String getOptimizeSql(String sql, String entryFieldName, boolean isChangeDrivingTable) {
        String optimizedSQL = sql;
        try {
            optimizedSQL = KSqlUtil.optimize((String)sql);
        }
        catch (SqlTranslateException e) {
            logger.error((Object)"\u4f18\u5316sql\u7ed3\u6784\u5931\u8d25!");
            e.printStackTrace();
        }
        return optimizedSQL;
    }

    protected FilterInfo getFilter(FilterInfo filter, List list, String entryIdField, boolean isHeadView) throws BOSException {
        FilterInfo resFilter = (FilterInfo)filter.clone();
        if (list != null) {
            FilterInfo idFilter = new FilterInfo();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add("NULL");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                idSet.add(isHeadView ? ((WriteOffCommonInfo)list.get(i)).getBillId() : ((WriteOffCommonInfo)list.get(i)).getEntryId());
            }
            if (idSet.size() > 1000) {
                String[] idStr = idSet.toArray(new String[0]);
                this.tmpTable = SCMSqlUtil.convertIdArrToTempTab((Context)ContextUtils.getContextFromSession(), (String[])idStr);
                String oql = "select FID from " + this.tmpTable;
                idFilter.getFilterItems().add(new FilterItemInfo(isHeadView ? "id" : entryIdField, (Object)oql, CompareType.INCLUDE));
            } else {
                idFilter.getFilterItems().add(new FilterItemInfo(isHeadView ? "id" : entryIdField, idSet, CompareType.INCLUDE));
            }
            if (resFilter == null) {
                resFilter = new FilterInfo();
            }
            resFilter.mergeFilter(idFilter, "AND");
        }
        return resFilter;
    }

    protected boolean dateEquals(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null || date2 == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date1Str = sdf.format(date1);
        String date2Str = sdf.format(date2);
        return date1Str.equals(date2Str);
    }

    protected Map getWriteOffMapping(Context ctx, IRowSet rs, List list, MappingFieldCollection fieldColl, IWriteOffStrategy strategy, WriteOffCommonParams params, boolean isMainField, List requestLockList) throws BOSException, EASBizException {
        boolean isHeadView = params.get("isHeadView") instanceof Boolean && (Boolean)params.get("isHeadView") != false;
        LinkedHashMap map = new LinkedHashMap();
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer key = new StringBuffer("");
        WriteOffCommonInfo info = null;
        IObjectValue entryInfo = null;
        HashMap<String, WriteOffCommonInfo> wInfoMap = new HashMap<String, WriteOffCommonInfo>();
        for (int i = 0; i < list.size(); ++i) {
            info = (WriteOffCommonInfo)list.get(i);
            if (isHeadView) {
                wInfoMap.put(info.getBillId(), info);
                continue;
            }
            wInfoMap.put(info.getEntryId(), info);
        }
        String idValue = null;
        try {
            if (isMainField && !CollectionUtils.isEmpty((Collection)params.getMainList()) && rs.size() == 0 || !isMainField && !CollectionUtils.isEmpty((Collection)params.getSecList()) && rs.size() == 0) {
                throw new WriteOffCommonException(WriteOffCommonException.HAS_NOT_DATA);
            }
            while (rs.next()) {
                idSet.add(rs.getString("id"));
                idValue = rs.getString("id");
                if (!isHeadView) {
                    idValue = rs.getString(isMainField ? params.getMainEntryIdField() : params.getSecEntryIdField());
                }
                if ((info = (WriteOffCommonInfo)wInfoMap.get(idValue)) == null) continue;
                if (!this.dateEquals(info.getLastUpdateTime(), rs.getDate("lastUpdateTime"))) {
                    throw new WriteOffCommonException(WriteOffCommonException.DATABASE_DATA_CHANGE, new String[]{info.getBillNumber()});
                }
                key.setLength(0);
                String field = null;
                int size = fieldColl.size();
                for (int i = 0; i < size; ++i) {
                    field = rs.getString(isMainField ? fieldColl.get(i).getMainField() : fieldColl.get(i).getSecField());
                    if (field == null && !fieldColl.get(i).isIsMappingNull()) {
                        key.append(rs.getString(isMainField ? params.getMainEntryIdField() : params.getSecEntryIdField()));
                        continue;
                    }
                    key.append(field);
                }
                if (!map.containsKey(key.toString())) {
                    map.put(key.toString(), new ArrayList());
                }
                if ((entryInfo = strategy.buildWriteOffEntryInfo(ctx, rs, info, params)) == null) continue;
                ((List)map.get(key.toString())).add(entryInfo);
            }
            requestLockList.addAll(idSet);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    protected Map getAutoWriteOffMapping(Context ctx, IRowSet rs, MappingFieldCollection fieldColl, IWriteOffStrategy strategy, WriteOffCommonParams params, boolean isMainField, List requestLockList) throws BOSException, EASBizException {
        LinkedHashMap map = new LinkedHashMap();
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer key = new StringBuffer("");
        IObjectValue entryInfo = null;
        try {
            WriteOffCommonInfo info;
            boolean isUsePreMatch = false;
            boolean isSupportSpecifyVerify = false;
            if (strategy instanceof AbstractWriteOffStrategy) {
                isUsePreMatch = ((AbstractWriteOffStrategy)strategy).isUsePreMatch(ctx, params);
                isSupportSpecifyVerify = true;
            }
            List list = isMainField ? params.getMainList() : params.getSecList();
            boolean isHeadView = params.get("isHeadView") instanceof Boolean && (Boolean)params.get("isHeadView") != false;
            HashMap<String, WriteOffCommonInfo> wInfoMap = new HashMap<String, WriteOffCommonInfo>();
            if (null != list && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    info = (WriteOffCommonInfo)list.get(i);
                    if (isHeadView) {
                        wInfoMap.put(info.getBillId(), info);
                        continue;
                    }
                    wInfoMap.put(info.getEntryId(), info);
                }
            }
            rs.beforeFirst();
            while (rs.next()) {
                String idValue = rs.getString("id");
                idSet.add(idValue);
                if (!isHeadView) {
                    idValue = rs.getString(isMainField ? params.getMainEntryIdField() : params.getSecEntryIdField());
                }
                info = (WriteOffCommonInfo)wInfoMap.get(idValue);
                if (!isSupportSpecifyVerify) {
                    info = null;
                }
                key.setLength(0);
                String field = null;
                int size = fieldColl.size();
                for (int i = 0; i < size; ++i) {
                    field = rs.getString(isMainField ? fieldColl.get(i).getMainField() : fieldColl.get(i).getSecField());
                    if (field == null && !fieldColl.get(i).isIsMappingNull()) {
                        key.append(rs.getString(isMainField ? params.getMainEntryIdField() : params.getSecEntryIdField()));
                        continue;
                    }
                    key.append(field);
                }
                if (!map.containsKey(key.toString())) {
                    map.put(key.toString(), new ArrayList());
                }
                if (isUsePreMatch) {
                    AbstractWriteOffStrategy preStrategy = (AbstractWriteOffStrategy)strategy;
                    entryInfo = preStrategy.buildBasicWriteOffEntryInfo(ctx, rs, info, params);
                } else {
                    entryInfo = strategy.buildWriteOffEntryInfo(ctx, rs, info, params);
                }
                if (entryInfo == null) continue;
                ((List)map.get(key.toString())).add(entryInfo);
            }
            requestLockList.addAll(idSet);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    protected Map getPositiveAutoWriteOffMapping(Context ctx, IRowSet rs, MappingFieldCollection fieldColl, MappingConditionEntryCollection mappingEntryColl, IWriteOffStrategy strategy, WriteOffCommonParams params, boolean isMainField, List requestLockList) throws BOSException, EASBizException {
        HashMap cacheMap = new HashMap();
        LinkedHashMap map = new LinkedHashMap();
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer key = new StringBuffer("");
        IObjectValue entryInfo = null;
        ArrayList[] cacheList = new ArrayList[rs.size()];
        try {
            int index = 0;
            rs.beforeFirst();
            while (rs.next()) {
                idSet.add(rs.getString("id"));
                key.setLength(0);
                String field = null;
                int size = fieldColl.size();
                for (int i = 0; i < size; ++i) {
                    field = rs.getString(isMainField ? fieldColl.get(i).getMainField() : fieldColl.get(i).getSecField());
                    if (field == null && !fieldColl.get(i).isIsMappingNull()) {
                        key.append(rs.getString(isMainField ? params.getMainEntryIdField() : params.getSecEntryIdField()));
                        continue;
                    }
                    key.append(field);
                }
                if (!map.containsKey(key.toString())) {
                    map.put(key.toString(), new ArrayList());
                }
                if ((entryInfo = strategy.buildWriteOffEntryInfo(ctx, rs, null, params)) != null) {
                    ((List)map.get(key.toString())).add(entryInfo);
                }
                cacheList[index] = (List)map.get(key.toString());
                ++index;
            }
            cacheMap.put("sameSideWriteOffMap", map);
            int size1 = mappingEntryColl.size();
            for (int i = 0; i < size1; ++i) {
                MappingConditionEntryInfo conditionEntryInfo = mappingEntryColl.get(i);
                fieldColl = conditionEntryInfo.getMappingField();
                index = 0;
                rs.beforeFirst();
                map = new LinkedHashMap();
                while (rs.next()) {
                    key.setLength(0);
                    String field = null;
                    int size = fieldColl.size();
                    for (int j = 0; j < size; ++j) {
                        field = rs.getString(isMainField ? fieldColl.get(j).getMainField() : fieldColl.get(j).getSecField());
                        if (field == null && !fieldColl.get(j).isIsMappingNull()) {
                            key.append(rs.getString(isMainField ? params.getMainEntryIdField() : params.getSecEntryIdField()));
                            continue;
                        }
                        key.append(field);
                    }
                    if (!map.containsKey(key.toString())) {
                        map.put(key.toString(), new ArrayList());
                    }
                    if ((entryInfo = strategy.buildWriteOffEntryInfo(ctx, rs, null, params)) != null) {
                        ((List)map.get(key.toString())).add(entryInfo);
                    }
                    ++index;
                }
                cacheMap.put(mappingEntryColl.get(i).getId().toString(), map);
            }
            requestLockList.addAll(idSet);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cacheMap;
    }

    protected void addKeyFields(MappingFieldCollection fieldColl, WriteOffCommonParams params, SelectorItemCollection sic, boolean isMain, boolean isManualVerify) {
        if (null == sic) {
            return;
        }
        sic.add(new SelectorItemInfo("id"));
        String entryIdField = isMain ? params.getMainEntryIdField() : params.getSecEntryIdField();
        sic.add(new SelectorItemInfo(entryIdField));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo(entryIdField.split("\\.")[0] + ".seq"));
        if (isManualVerify) {
            sic.add(new SelectorItemInfo("lastUpdateTime"));
        }
        int size = fieldColl.size();
        for (int i = 0; i < size; ++i) {
            String matchField = isMain ? fieldColl.get(i).getMainField() : fieldColl.get(i).getSecField();
            sic.add(new SelectorItemInfo(matchField));
        }
    }

    protected IRowSet getRowSetForAutoVerify(Context ctx, IWriteOffStrategy strategy, MappingFieldCollection fieldColl, String bosType, String entryIdField, String sql, WriteOffCommonParams params) throws EASBizException, BOSException {
        IRowSet rs = null;
        if (null == ctx || null == strategy || null == fieldColl || StringUtils.isEmpty((String)bosType) || StringUtils.isEmpty((String)entryIdField) || StringUtils.isEmpty((String)sql) || null == params) {
            return rs;
        }
        boolean isUsePreMatch = false;
        if (strategy instanceof AbstractWriteOffStrategy) {
            isUsePreMatch = ((AbstractWriteOffStrategy)strategy).isUsePreMatch(ctx, params);
        }
        if (isUsePreMatch) {
            AbstractWriteOffStrategy preStrategy = (AbstractWriteOffStrategy)strategy;
            String tmpTable = preStrategy.fetchDataIntoTempTable(ctx, bosType, entryIdField, sql);
            SelectorItemCollection preSic = preStrategy.getPreMatchSelector(bosType, params);
            boolean isMain = bosType.equals(params.getMainEntityId());
            this.addKeyFields(fieldColl, params, preSic, isMain, false);
            String orderSql = sql.substring(sql.lastIndexOf("ORDER BY"));
            rs = preStrategy.getPreMatchRowSet(ctx, preSic, tmpTable, orderSql);
            Map<String, Object> map = SCMThreadLocalUtil.getThreadObject();
            map.put("isUsePreMatch", true);
            map.put(isMain ? "mainTmpTable" : "secTmpTable", tmpTable);
            map.put(isMain ? "mainBosType" : "secBosType", bosType);
            map.put(isMain ? "mainEntryIDField" : "secEntryIDField", entryIdField);
            SCMThreadLocalUtil.addThreadObject(map);
        } else {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _writeOff(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        if (params.get("upQueryFilter") == null && params.get("downQueryFilter") == null) {
            return null;
        }
        MappingFieldCollection fieldColl = new MappingFieldCollection();
        MappingConditionEntryInfo conditionEntryInfo = null;
        if (params.getMappingEntryId() != null && !"".equals(params.getMappingEntryId())) {
            conditionEntryInfo = MappingConditionEntryFactory.getLocalInstance(ctx).getMappingConditionEntryInfo("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE id = '" + params.getMappingEntryId() + "'");
            fieldColl.addCollection(conditionEntryInfo.getMappingField());
        }
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        String mainBosType = params.getMainEntityId();
        SelectorItemCollection mainSelectors = strategy.getSelector(mainBosType, params);
        this.addKeyFields(fieldColl, params, mainSelectors, true, false);
        String secBosType = params.getSecEntityId();
        SelectorItemCollection secSelectors = strategy.getSelector(secBosType, params);
        this.addKeyFields(fieldColl, params, secSelectors, false, false);
        boolean isHeadView = params.get("isHeadView") instanceof Boolean && (Boolean)params.get("isHeadView") != false;
        ArrayList requestLockList = new ArrayList();
        ArrayList thisLockList = new ArrayList();
        ArrayList otherLockList = new ArrayList();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List result = null;
        try {
            String sql = null;
            Map mainMap = new LinkedHashMap();
            Map secMap = new LinkedHashMap();
            if (params.get("upQueryFilter") != null) {
                String mainEntryIdField = params.getMainEntryIdField();
                sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, this.getFilter((FilterInfo)params.get("upQueryFilter"), params.getMainList(), mainEntryIdField, isHeadView), (SorterItemCollection)params.get("upOrder"), mainEntryIdField.split("\\.")[0], conditionEntryInfo != null ? conditionEntryInfo.getMainBillFilter() : "");
                sql = this.getOptimizeSql(sql, mainEntryIdField.split("\\.")[0], false);
                logger.debug((Object)("MAIN WRITEOFF SQL: " + sql));
                SCMSqlUtil.releasTempTable((Context)ctx, (String)this.tmpTable);
                IRowSet mainRs = this.getRowSetForAutoVerify(ctx, strategy, fieldColl, mainBosType, mainEntryIdField, sql, params);
                mainMap = this.getAutoWriteOffMapping(ctx, mainRs, fieldColl, strategy, params, true, requestLockList);
                mainRs = null;
                System.gc();
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            }
            if (params.get("downQueryFilter") != null) {
                String secEntryIdField = params.getSecEntryIdField();
                sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, this.getFilter((FilterInfo)params.get("downQueryFilter"), params.getSecList(), secEntryIdField, isHeadView), (SorterItemCollection)params.get("downOrder"), secEntryIdField.split("\\.")[0], conditionEntryInfo != null ? conditionEntryInfo.getSecBillFilter() : "");
                sql = this.getOptimizeSql(sql, secEntryIdField.split("\\.")[0], false);
                logger.debug((Object)("SEC WRITEOFF SQL: " + sql));
                IRowSet secRs = this.getRowSetForAutoVerify(ctx, strategy, fieldColl, secBosType, secEntryIdField, sql, params);
                requestLockList.clear();
                secMap = this.getAutoWriteOffMapping(ctx, secRs, fieldColl, strategy, params, false, requestLockList);
                secRs = null;
                System.gc();
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            }
            logger.debug((Object)("WRITEOFF MAIN MAP: " + mainMap));
            logger.debug((Object)("WRITEOFF SEC MAP: " + secMap));
            result = strategy.buildWriteOffBillInfo(ctx, mainMap, secMap, conditionEntryInfo, params);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
            SCMSqlUtil.releasTempTable((Context)ctx, (String)this.tmpTable);
            this.cleanResource4PreMatch(ctx);
        }
        return result;
    }

    private String getString(Map<String, Object> map, String key) {
        return null != map.get(key) ? map.get(key).toString() : null;
    }

    private void cleanResource4PreMatch(Context ctx) {
        Map<String, Object> map = SCMThreadLocalUtil.getThreadObject();
        String mainTmpTable = this.getString(map, "mainTmpTable");
        String secTmpTable = this.getString(map, "secTmpTable");
        SCMThreadLocalUtil.cleanThreadObject();
        if (!StringUtils.isEmpty((String)mainTmpTable)) {
            try {
                DbUtil.execute((Context)ctx, (String)("DROP TABLE " + mainTmpTable));
            }
            catch (BOSException e) {
                logger.error((Object)("cleanResource4PreMatch : DROP TABLE " + mainTmpTable + " error :" + (Object)((Object)e)));
            }
        }
        if (!StringUtils.isEmpty((String)secTmpTable)) {
            try {
                DbUtil.execute((Context)ctx, (String)("DROP TABLE " + secTmpTable));
            }
            catch (BOSException e) {
                logger.error((Object)("cleanResource4PreMatch : DROP TABLE " + secTmpTable + " error :" + (Object)((Object)e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _flowWriteOff(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        MappingConditionEntryInfo conditionEntryInfo = (MappingConditionEntryInfo)params.get("mappingEntryInfo");
        MappingFieldCollection fieldColl = conditionEntryInfo.getMappingField();
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        SelectorItemCollection mainSelectors = strategy.getSelector(params.getMainEntityId(), params);
        SelectorItemCollection secSelectors = strategy.getSelector(params.getSecEntityId(), params);
        mainSelectors.add(new SelectorItemInfo("id"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("id"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        mainSelectors.add(new SelectorItemInfo("number"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField().split("\\.")[0] + ".seq"));
        secSelectors.add(new SelectorItemInfo("number"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField().split("\\.")[0] + ".seq"));
        int size = fieldColl.size();
        for (int i = 0; i < size; ++i) {
            mainSelectors.add(new SelectorItemInfo(fieldColl.get(i).getMainField()));
            secSelectors.add(new SelectorItemInfo(fieldColl.get(i).getSecField()));
        }
        Map mainMap = null;
        Map secMap = null;
        ArrayList requestLockList = new ArrayList();
        ArrayList thisLockList = new ArrayList();
        ArrayList otherLockList = new ArrayList();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List result = null;
        try {
            if (params.isFromMain()) {
                FilterInfo mainFilter = (FilterInfo)((FilterInfo)params.get("mainFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("MAIN FLOW WRITEOFF SQL: " + sql));
                IRowSet mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (mainRs.size() == 0) {
                    List list = null;
                    return list;
                }
                FilterInfo secFilter2 = this.getAutoWriteOffValueFilter(ctx, mainRs, fieldColl, true, false);
                secFilter2.mergeFilter((FilterInfo)params.get("secFilter"), "AND");
                sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter2, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], true);
                sql = this.getOptimizeSql2Verify(sql, params);
                logger.debug((Object)("SEC FLOW WRITEOFF SQL: " + sql));
                IRowSet secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (secRs.size() == 0) {
                    List list = null;
                    return list;
                }
                mainMap = this.getAutoWriteOffMapping(ctx, mainRs, fieldColl, strategy, params, true, requestLockList);
                if (mainMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                secMap = this.getAutoWriteOffMapping(ctx, secRs, fieldColl, strategy, params, false, requestLockList);
                if (secMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            } else {
                FilterInfo secFilter = (FilterInfo)((FilterInfo)params.get("secFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("SEC FLOW WRITEOFF SQL: " + sql));
                IRowSet secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (secRs.size() == 0) {
                    List secFilter2 = null;
                    return secFilter2;
                }
                FilterInfo mainFilter = this.getAutoWriteOffValueFilter(ctx, secRs, fieldColl, false, true);
                mainFilter.mergeFilter((FilterInfo)params.get("mainFilter"), "AND");
                sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("MAIN FLOW WRITEOFF SQL: " + sql));
                IRowSet mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (mainRs.size() == 0) {
                    List list = null;
                    return list;
                }
                secMap = this.getAutoWriteOffMapping(ctx, secRs, fieldColl, strategy, params, false, requestLockList);
                if (secMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                mainMap = this.getAutoWriteOffMapping(ctx, mainRs, fieldColl, strategy, params, true, requestLockList);
                if (mainMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            }
            logger.debug((Object)("FLOW WRITEOFF MAIN MAP: " + mainMap));
            logger.debug((Object)("FLOW WRITEOFF SEC MAP: " + secMap));
            result = strategy.buildWriteOffBillInfo(ctx, mainMap, secMap, conditionEntryInfo, params);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _flowWriteOff(Context ctx, WriteOffCommonParams params, MappingConditionEntryCollection mappingEntryColl, Map cacheMap) throws BOSException, EASBizException {
        MappingConditionEntryInfo conditionEntryInfo = null;
        MappingFieldCollection fieldColl = null;
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        SelectorItemCollection mainSelectors = strategy.getSelector(params.getMainEntityId(), params);
        SelectorItemCollection secSelectors = strategy.getSelector(params.getSecEntityId(), params);
        this.prepareWriteOff(params, mappingEntryColl, conditionEntryInfo, fieldColl, mainSelectors, secSelectors);
        conditionEntryInfo = (MappingConditionEntryInfo)params.get("mappingEntryInfo");
        fieldColl = conditionEntryInfo.getMappingField();
        Map mainMap = null;
        Map secMap = null;
        ArrayList requestLockList = new ArrayList();
        ArrayList thisLockList = new ArrayList();
        ArrayList otherLockList = new ArrayList();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List result = null;
        try {
            if (params.isFromMain()) {
                IRowSet mainRs = (IRowSet)cacheMap.get("RowSet");
                FilterInfo mainFilter = (FilterInfo)((FilterInfo)params.get("mainFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("MAIN FLOW WRITEOFF SQL: " + sql));
                mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (mainRs.size() == 0) {
                    List list = null;
                    return list;
                }
                Map tempMap = this.getPositiveAutoWriteOffMapping(ctx, mainRs, fieldColl, mappingEntryColl, strategy, params, true, requestLockList);
                cacheMap.putAll(tempMap);
                mainMap = new HashMap();
                mainMap = (Map)cacheMap.get(conditionEntryInfo.getId().toString());
                cacheMap.put("RowSet", mainRs);
                FilterInfo secFilter = null;
                secFilter = this.getAutoWriteOffValueFilter(ctx, mainRs, fieldColl, true, false);
                secFilter.mergeFilter((FilterInfo)params.get("secFilter"), "AND");
                sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("SEC FLOW WRITEOFF SQL: " + sql));
                IRowSet secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (secRs.size() == 0) {
                    List list = null;
                    return list;
                }
                if (mainMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                secMap = this.getAutoWriteOffMapping(ctx, secRs, fieldColl, strategy, params, false, requestLockList);
                if (secMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            } else {
                IRowSet secRs = (IRowSet)cacheMap.get("RowSet");
                FilterInfo secFilter = (FilterInfo)((FilterInfo)params.get("secFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("SEC FLOW WRITEOFF SQL: " + sql));
                secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (secRs.size() == 0) {
                    List tempMap = null;
                    return tempMap;
                }
                Map tempMap = this.getPositiveAutoWriteOffMapping(ctx, secRs, fieldColl, mappingEntryColl, strategy, params, false, requestLockList);
                cacheMap.putAll(tempMap);
                secMap = new HashMap();
                secMap = (Map)cacheMap.get(conditionEntryInfo.getId().toString());
                cacheMap.put("RowSet", secRs);
                FilterInfo mainFilter = null;
                mainFilter = this.getAutoWriteOffValueFilter(ctx, secRs, fieldColl, false, true);
                mainFilter.mergeFilter((FilterInfo)params.get("mainFilter"), "AND");
                sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("MAIN FLOW WRITEOFF SQL: " + sql));
                IRowSet mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (mainRs.size() == 0) {
                    List list = null;
                    return list;
                }
                if (secMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                mainMap = this.getAutoWriteOffMapping(ctx, mainRs, fieldColl, strategy, params, true, requestLockList);
                if (mainMap.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            }
            logger.debug((Object)("FLOW WRITEOFF MAIN MAP: " + mainMap));
            logger.debug((Object)("FLOW WRITEOFF SEC MAP: " + secMap));
            result = strategy.buildWriteOffBillInfo(ctx, mainMap, secMap, conditionEntryInfo, params);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
        return result;
    }

    protected void prepareWriteOff(WriteOffCommonParams params, MappingConditionEntryCollection mappingEntryColl, MappingConditionEntryInfo conditionEntryInfo, MappingFieldCollection fieldColl, SelectorItemCollection mainSelectors, SelectorItemCollection secSelectors) {
        int i;
        mainSelectors.add(new SelectorItemInfo("id"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("id"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        mainSelectors.add(new SelectorItemInfo("number"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField().split("\\.")[0] + ".seq"));
        secSelectors.add(new SelectorItemInfo("number"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField().split("\\.")[0] + ".seq"));
        if (fieldColl != null) {
            int size = fieldColl.size();
            for (i = 0; i < size; ++i) {
                mainSelectors.add(new SelectorItemInfo(fieldColl.get(i).getMainField()));
                secSelectors.add(new SelectorItemInfo(fieldColl.get(i).getSecField()));
            }
        }
        int size1 = mappingEntryColl.size();
        for (i = 0; i < size1; ++i) {
            conditionEntryInfo = mappingEntryColl.get(i);
            fieldColl = conditionEntryInfo.getMappingField();
            int size2 = fieldColl.size();
            for (int j = 0; j < size2; ++j) {
                mainSelectors.add(new SelectorItemInfo(fieldColl.get(j).getMainField()));
                secSelectors.add(new SelectorItemInfo(fieldColl.get(j).getSecField()));
            }
        }
    }

    protected FilterInfo getAutoWriteOffValueFilter(Context ctx, IRowSet rs, MappingFieldCollection fieldColl, boolean isMainField, boolean isMainFilter) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.setMaskString("1 = 1");
        try {
            int i;
            int size;
            rs.beforeFirst();
            HashSet[] value = new HashSet[fieldColl.size()];
            while (rs.next()) {
                size = fieldColl.size();
                for (i = 0; i < size; ++i) {
                    if (value[i] == null) {
                        value[i] = new HashSet();
                    }
                    value[i].add(String.valueOf(isMainField ? rs.getObject(fieldColl.get(i).getMainField()) : rs.getObject(fieldColl.get(i).getSecField())));
                }
            }
            size = fieldColl.size();
            for (i = 0; i < size; ++i) {
                filter.getFilterItems().add(new FilterItemInfo(isMainFilter ? fieldColl.get(i).getMainField() : fieldColl.get(i).getSecField(), (Object)value[i], CompareType.INCLUDE));
                filter.setMaskString(filter.getMaskString() + " AND (#" + (filter.getFilterItems().size() - 1));
                if (value[i].contains("null") && fieldColl.get(i).isIsMappingNull()) {
                    filter.getFilterItems().add(new FilterItemInfo(isMainFilter ? fieldColl.get(i).getMainField() : fieldColl.get(i).getSecField(), null, CompareType.IS));
                    filter.setMaskString(filter.getMaskString() + " OR #" + (filter.getFilterItems().size() - 1));
                }
                filter.setMaskString(filter.getMaskString() + ")");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _flowWriteOffSameSide(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        MappingConditionEntryInfo conditionEntryInfo = (MappingConditionEntryInfo)params.get("mappingEntryInfo");
        MappingFieldCollection fieldColl = conditionEntryInfo.getMappingField();
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        SelectorItemCollection mainSelectors = strategy.getSelector(params.getMainEntityId(), params);
        SelectorItemCollection secSelectors = strategy.getSelector(params.getSecEntityId(), params);
        mainSelectors.add(new SelectorItemInfo("id"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("id"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        mainSelectors.add(new SelectorItemInfo("number"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField().split("\\.")[0] + ".seq"));
        secSelectors.add(new SelectorItemInfo("number"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField().split("\\.")[0] + ".seq"));
        int size = fieldColl.size();
        for (int i = 0; i < size; ++i) {
            mainSelectors.add(new SelectorItemInfo(fieldColl.get(i).getMainField()));
            secSelectors.add(new SelectorItemInfo(fieldColl.get(i).getSecField()));
        }
        LinkedHashMap mainMap = null;
        LinkedHashMap secMap = null;
        ArrayList requestLockList = new ArrayList();
        ArrayList thisLockList = new ArrayList();
        ArrayList otherLockList = new ArrayList();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List result = null;
        try {
            if (params.isFromMain()) {
                FilterInfo mainFilter = (FilterInfo)((FilterInfo)params.get("mainFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("MAIN FLOW WRITEOFF SAMESIDE SQL1: " + sql));
                IRowSet mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (mainRs.size() == 0) {
                    List list = null;
                    return list;
                }
                int size22 = mainFilter.getFilterItems().size();
                for (int i = 0; i < size22; ++i) {
                    if (!"id".equals(mainFilter.getFilterItems().get(i).getPropertyName())) continue;
                    mainFilter.getFilterItems().get(i).setCompareType(CompareType.NOTEQUALS);
                    break;
                }
                mainFilter.mergeFilter(this.getAutoWriteOffValueFilter(ctx, mainRs, fieldColl, true, true), "AND");
                sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("MAIN FLOW WRITEOFF SAMESIDE SQL2: " + sql));
                IRowSet sameSideRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (sameSideRs.size() == 0) {
                    List size22 = null;
                    return size22;
                }
                mainMap = this.getAutoWriteOffMapping(ctx, mainRs, fieldColl, strategy, params, true, requestLockList);
                if (mainMap.size() == 0) {
                    List size22 = null;
                    return size22;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                Map sameSide = this.getAutoWriteOffMapping(ctx, sameSideRs, fieldColl, strategy, params, true, requestLockList);
                if (sameSide.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                Map.Entry me2 = null;
                for (Map.Entry me2 : sameSide.entrySet()) {
                    if (!mainMap.containsKey(me2.getKey())) continue;
                    ((List)mainMap.get(me2.getKey())).addAll((List)me2.getValue());
                }
                secMap = new LinkedHashMap();
            } else {
                FilterInfo secFilter = (FilterInfo)((FilterInfo)params.get("secFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("SEC FLOW WRITEOFF SAMESIDE SQL1: " + sql));
                IRowSet secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (secRs.size() == 0) {
                    List sameSideRs = null;
                    return sameSideRs;
                }
                int size32 = secFilter.getFilterItems().size();
                for (int i = 0; i < size32; ++i) {
                    if (!"id".equals(secFilter.getFilterItems().get(i).getPropertyName())) continue;
                    secFilter.getFilterItems().get(i).setCompareType(CompareType.NOTEQUALS);
                    break;
                }
                secFilter.mergeFilter(this.getAutoWriteOffValueFilter(ctx, secRs, fieldColl, false, false), "AND");
                sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("SEC FLOW WRITEOFF SAMESIDE SQL2: " + sql));
                IRowSet sameSideRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (sameSideRs.size() == 0) {
                    List size32 = null;
                    return size32;
                }
                secMap = this.getAutoWriteOffMapping(ctx, secRs, fieldColl, strategy, params, false, requestLockList);
                if (secMap.size() == 0) {
                    List size32 = null;
                    return size32;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                Map sameSide = this.getAutoWriteOffMapping(ctx, sameSideRs, fieldColl, strategy, params, false, requestLockList);
                if (sameSide.size() == 0) {
                    List me2 = null;
                    return me2;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                Map.Entry me3 = null;
                for (Map.Entry me3 : sameSide.entrySet()) {
                    if (!secMap.containsKey(me3.getKey())) continue;
                    ((List)secMap.get(me3.getKey())).addAll((List)me3.getValue());
                }
                mainMap = new LinkedHashMap();
            }
            logger.debug((Object)("FLOW WRITEOFF SAMESIDE MAIN MAP: " + mainMap));
            logger.debug((Object)("FLOW WRITEOFF SAMESIDE SEC MAP: " + secMap));
            params.setSameSideFirst(true);
            result = strategy.buildWriteOffBillInfo(ctx, mainMap, secMap, conditionEntryInfo, params);
            params.setSameSideFirst(false);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _flowWriteOffSameSide(Context ctx, WriteOffCommonParams params, MappingConditionEntryCollection mappingEntryColl, Map cacheMap) throws BOSException, EASBizException {
        MappingConditionEntryInfo conditionEntryInfo = (MappingConditionEntryInfo)params.get("mappingEntryInfo");
        MappingFieldCollection fieldColl = conditionEntryInfo.getMappingField();
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        SelectorItemCollection mainSelectors = strategy.getSelector(params.getMainEntityId(), params);
        SelectorItemCollection secSelectors = strategy.getSelector(params.getSecEntityId(), params);
        this.prepareWriteOff(params, mappingEntryColl, conditionEntryInfo, fieldColl, mainSelectors, secSelectors);
        fieldColl = conditionEntryInfo.getMappingField();
        Map mainMap = null;
        Map secMap = null;
        ArrayList requestLockList = new ArrayList();
        ArrayList thisLockList = new ArrayList();
        ArrayList otherLockList = new ArrayList();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List result = null;
        try {
            if (params.isFromMain()) {
                FilterInfo mainFilter = (FilterInfo)((FilterInfo)params.get("mainFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("MAIN FLOW WRITEOFF SAMESIDE SQL1: " + sql));
                IRowSet mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (mainRs.size() == 0) {
                    List list = null;
                    return list;
                }
                int size = mainFilter.getFilterItems().size();
                for (int i = 0; i < size; ++i) {
                    if (!"id".equals(mainFilter.getFilterItems().get(i).getPropertyName())) continue;
                    mainFilter.getFilterItems().get(i).setCompareType(CompareType.NOTEQUALS);
                    break;
                }
                mainFilter.mergeFilter(this.getAutoWriteOffValueFilter(ctx, mainRs, fieldColl, true, true), "AND");
                sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, mainFilter, (SorterItemCollection)params.get("mainSorter"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("MAIN FLOW WRITEOFF SAMESIDE SQL2: " + sql));
                IRowSet sameSideRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                Map tempMap = this.getPositiveAutoWriteOffMapping(ctx, mainRs, fieldColl, mappingEntryColl, strategy, params, true, requestLockList);
                cacheMap.putAll(tempMap);
                mainMap = new HashMap();
                mainMap = (Map)cacheMap.get("sameSideWriteOffMap");
                cacheMap.put("RowSet", mainRs);
                if (mainMap.size() == 0) {
                    List list = null;
                    return list;
                }
                if (sameSideRs.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                Map sameSide = this.getAutoWriteOffMapping(ctx, sameSideRs, fieldColl, strategy, params, true, requestLockList);
                if (sameSide.size() == 0) {
                    List list = null;
                    return list;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                Map.Entry me2 = null;
                for (Map.Entry me2 : sameSide.entrySet()) {
                    if (!mainMap.containsKey(me2.getKey())) continue;
                    ((List)mainMap.get(me2.getKey())).addAll((List)me2.getValue());
                }
                secMap = new LinkedHashMap();
            } else {
                FilterInfo secFilter = (FilterInfo)((FilterInfo)params.get("secFilter")).clone();
                String sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("SEC FLOW WRITEOFF SAMESIDE SQL1: " + sql));
                IRowSet secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (secRs.size() == 0) {
                    List sameSideRs = null;
                    return sameSideRs;
                }
                int size = secFilter.getFilterItems().size();
                for (int i = 0; i < size; ++i) {
                    if (!"id".equals(secFilter.getFilterItems().get(i).getPropertyName())) continue;
                    secFilter.getFilterItems().get(i).setCompareType(CompareType.NOTEQUALS);
                    break;
                }
                if (params.get("isBotpWriteOff") != null) {
                    secFilter.mergeFilter(this.getAutoWriteOffValueFilter(ctx, secRs, fieldColl, false, true), "AND");
                } else {
                    secFilter.mergeFilter(this.getAutoWriteOffValueFilter(ctx, secRs, fieldColl, false, false), "AND");
                }
                sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, secFilter, (SorterItemCollection)params.get("secSorter"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], true);
                logger.debug((Object)("SEC FLOW WRITEOFF SAMESIDE SQL2: " + sql));
                IRowSet sameSideRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                Map tempMap = this.getPositiveAutoWriteOffMapping(ctx, secRs, fieldColl, mappingEntryColl, strategy, params, false, requestLockList);
                cacheMap.putAll(tempMap);
                secMap = new HashMap();
                secMap = (Map)cacheMap.get("sameSideWriteOffMap");
                cacheMap.put("RowSet", secRs);
                if (secMap.size() == 0) {
                    List sameSide = null;
                    return sameSide;
                }
                if (sameSideRs.size() == 0) {
                    List sameSide = null;
                    return sameSide;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                requestLockList.clear();
                Map sameSide = this.getAutoWriteOffMapping(ctx, sameSideRs, fieldColl, strategy, params, false, requestLockList);
                if (sameSide.size() == 0) {
                    List me2 = null;
                    return me2;
                }
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
                Map.Entry me3 = null;
                for (Map.Entry me3 : sameSide.entrySet()) {
                    if (!secMap.containsKey(me3.getKey())) continue;
                    ((List)secMap.get(me3.getKey())).addAll((List)me3.getValue());
                }
                mainMap = new LinkedHashMap();
            }
            logger.debug((Object)("FLOW WRITEOFF SAMESIDE MAIN MAP: " + mainMap));
            logger.debug((Object)("FLOW WRITEOFF SAMESIDE SEC MAP: " + secMap));
            params.setSameSideFirst(true);
            conditionEntryInfo = (MappingConditionEntryInfo)params.get("mappingEntryInfo");
            result = strategy.buildWriteOffBillInfo(ctx, mainMap, secMap, conditionEntryInfo, params);
            params.setSameSideFirst(false);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
        return result;
    }

    @Override
    protected List _manualWriteOff(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        MappingFieldCollection fieldColl = new MappingFieldCollection();
        MappingConditionEntryInfo conditionEntryInfo = null;
        if (params.getMappingEntryId() != null && !"".equals(params.getMappingEntryId())) {
            conditionEntryInfo = MappingConditionEntryFactory.getLocalInstance(ctx).getMappingConditionEntryInfo("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE id = '" + params.getMappingEntryId() + "'");
            fieldColl.addCollection(conditionEntryInfo.getMappingField());
        }
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        SelectorItemCollection mainSelectors = strategy.getSelector(params.getMainEntityId(), params);
        SelectorItemCollection secSelectors = strategy.getSelector(params.getSecEntityId(), params);
        mainSelectors.add(new SelectorItemInfo("id"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("id"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        mainSelectors.add(new SelectorItemInfo("number"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField().split("\\.")[0] + ".seq"));
        secSelectors.add(new SelectorItemInfo("number"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField().split("\\.")[0] + ".seq"));
        mainSelectors.add(new SelectorItemInfo("lastUpdateTime"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("lastUpdateTime"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        int size = fieldColl.size();
        for (int i = 0; i < size; ++i) {
            mainSelectors.add(new SelectorItemInfo(fieldColl.get(i).getMainField()));
            secSelectors.add(new SelectorItemInfo(fieldColl.get(i).getSecField()));
        }
        if (null == conditionEntryInfo) {
            throw new BOSException("_manualWriteOff => conditionEntryInfo(MappingConditionEntryInfo) is null.");
        }
        String conditionEntryId = conditionEntryInfo.getId().toString();
        if ("dBC/vlCCS6W9QaL2vxItOZVAboA=".equals(conditionEntryId) || "8WnzVtwxT3+e8q7GN0ycTJVAboA=".equals(conditionEntryId) || "3GxASeje51XgU5cHEayqOJVAboA=".equals(conditionEntryId)) {
            mainSelectors.add(new SelectorItemInfo("ENTRY.COREBILLENTRYID"));
        }
        int maxCountPerWriteOff = this.getMaxCountPerWriteOff(ctx);
        List mainList = params.getMainList();
        if ("saleExpenseApportion".equals(params.getStrategy()) && mainList.size() > 1) {
            throw new WriteOffCommonException(WriteOffCommonException.SALE_EXPENSE_NOT_SUPPORT_MULTI);
        }
        List secList = params.getSecList();
        boolean isCommonWriteOff = this.isCommonWriteOff(conditionEntryInfo) && (mainList.size() > maxCountPerWriteOff || secList.size() > maxCountPerWriteOff);
        List result = new ArrayList();
        if (isCommonWriteOff) {
            List splitResult = new ArrayList();
            ArrayList mainListSplited = new ArrayList();
            int size2 = mainList.size();
            for (int i = 0; i < size2; ++i) {
                mainListSplited.add(mainList.get(i));
                if ((i + 1) % maxCountPerWriteOff != 0) continue;
                splitResult = this.doWriteOff(ctx, params, fieldColl, conditionEntryInfo, strategy, mainSelectors, secSelectors, mainListSplited, isCommonWriteOff);
                mainListSplited.clear();
                if (splitResult == null || splitResult.size() <= 0) continue;
                result.addAll(splitResult);
            }
            if (mainListSplited.size() > 0 && (splitResult = this.doWriteOff(ctx, params, fieldColl, conditionEntryInfo, strategy, mainSelectors, secSelectors, mainListSplited, isCommonWriteOff)) != null && splitResult.size() > 0) {
                result.addAll(splitResult);
            }
        } else {
            result = this.doWriteOff(ctx, params, fieldColl, conditionEntryInfo, strategy, mainSelectors, secSelectors, mainList, isCommonWriteOff);
        }
        return result;
    }

    private boolean isCommonWriteOff(MappingConditionEntryInfo conditionEntryInfo) {
        String conditionEntryId = conditionEntryInfo.getId().toString();
        return "uZllwXK5SyqpkGYx6BGKNZVAboA=".equals(conditionEntryId) || "dBC/vlCCS6W9QaL2vxItOZVAboA=".equals(conditionEntryId) || "62l4P/XTRz+KchgVHxywn5VAboA=".equals(conditionEntryId) || "8WnzVtwxT3+e8q7GN0ycTJVAboA=".equals(conditionEntryId) || "3GxASeje51XgU5cHEayqOJVAboA=".equals(conditionEntryId) || "3GxASejj51XgU5cHEayqOJVAboA=".equals(conditionEntryId);
    }

    private int getMaxCountPerWriteOff(Context ctx) throws BOSException {
        int maxCount = 5000;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FVALUE FROM T_DT_DTTEMPPARAM WHERE FKEY ='MAXCOUNTPERWRITEOFF' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                maxCount = Integer.parseInt(rs.getString("FVALUE"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return maxCount;
    }

    private List doWriteOff(Context ctx, WriteOffCommonParams params, MappingFieldCollection fieldColl, MappingConditionEntryInfo conditionEntryInfo, IWriteOffStrategy strategy, SelectorItemCollection mainSelectors, SelectorItemCollection secSelectors, List mainList, boolean isCommonWriteOff) throws BOSException, EASBizException, WriteOffCommonException {
        boolean isHeadView = params.get("isHeadView") instanceof Boolean && (Boolean)params.get("isHeadView") != false;
        ArrayList requestLockList = new ArrayList();
        ArrayList<String> thisLockList = new ArrayList<String>();
        ArrayList<String> otherLockList = new ArrayList<String>();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestLockMap = null;
        String id = null;
        List result = null;
        try {
            int i;
            String sql = null;
            Map mainMap = new LinkedHashMap();
            Map secMap = new LinkedHashMap();
            ArrayList<WriteOffCommonInfo> secRealList = params.getSecList();
            HashSet<String> billIdSet = new HashSet<String>();
            for (i = 0; i < mainList.size(); ++i) {
                billIdSet.add(((WriteOffCommonInfo)mainList.get(i)).getBillId());
            }
            if (billIdSet.size() > 0) {
                this.lockDbBill(ctx, billIdSet, params.getMainEntityId());
            }
            billIdSet.clear();
            for (i = 0; i < secRealList.size(); ++i) {
                billIdSet.add(((WriteOffCommonInfo)secRealList.get(i)).getBillId());
            }
            if (billIdSet.size() > 0) {
                this.lockDbBill(ctx, billIdSet, params.getSecEntityId());
            }
            String[] requestLockArr = null;
            if (params.get("upQueryFilter") != null) {
                sql = this.getExecutorSql(ctx, params.getMainQueryName(), mainSelectors, this.getFilter((FilterInfo)params.get("upQueryFilter"), mainList, params.getMainEntryIdField(), isHeadView), (SorterItemCollection)params.get("upOrder"), params.getMainEntryIdField().split("\\.")[0], conditionEntryInfo.getMainBillFilter());
                sql = this.getOptimizeSql(sql, params.getMainEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("MAIN MANUAL WRITEOFF SQL: " + sql));
                IRowSet mainRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                SCMSqlUtil.releasTempTable((Context)ctx, (String)this.tmpTable);
                mainMap = this.getWriteOffMapping(ctx, mainRs, mainList, fieldColl, strategy, params, true, requestLockList);
                if (isCommonWriteOff) {
                    secRealList = new ArrayList<WriteOffCommonInfo>();
                    String conditionId = conditionEntryInfo.getId().toString();
                    String secOrderFiled = "";
                    if ("uZllwXK5SyqpkGYx6BGKNZVAboA=".equals(conditionId) || "dBC/vlCCS6W9QaL2vxItOZVAboA=".equals(conditionId)) {
                        secOrderFiled = "ENTRY.PURORDERENTRY";
                    }
                    if ("62l4P/XTRz+KchgVHxywn5VAboA=".equals(conditionId) || "8WnzVtwxT3+e8q7GN0ycTJVAboA=".equals(conditionId) || "3GxASeje51XgU5cHEayqOJVAboA=".equals(conditionId) || "3GxASejj51XgU5cHEayqOJVAboA=".equals(conditionId)) {
                        secOrderFiled = "ENTRY.SALEORDERENTRY";
                    }
                    mainRs.beforeFirst();
                    HashSet<String> orderIdSet = new HashSet<String>();
                    orderIdSet.add("NULL");
                    String orderEntryId = null;
                    while (mainRs.next()) {
                        orderEntryId = mainRs.getString("ENTRY.COREBILLENTRYID");
                        if (StringUtils.isEmpty((String)orderEntryId)) continue;
                        orderIdSet.add(mainRs.getString("ENTRY.COREBILLENTRYID"));
                    }
                    SelectorItemCollection sics = new SelectorItemCollection();
                    sics.add(new SelectorItemInfo(params.getSecEntryIdField()));
                    FilterInfo downFilter = (FilterInfo)((FilterInfo)params.get("downQueryFilter")).clone();
                    FilterInfo orderFilter = new FilterInfo();
                    orderFilter.getFilterItems().add(new FilterItemInfo(secOrderFiled, orderIdSet, CompareType.INCLUDE));
                    downFilter.mergeFilter(orderFilter, "AND");
                    sql = this.getExecutorSql(ctx, params.getSecQueryName(), sics, this.getFilter(downFilter, params.getSecList(), params.getSecEntryIdField(), isHeadView), (SorterItemCollection)params.get("downOrder"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                    sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], false);
                    if (sql.indexOf("ORDER BY") > 0) {
                        sql = sql.substring(0, sql.indexOf("ORDER BY"));
                    }
                    logger.debug((Object)("SEC MANUAL WRITEOFF SQL: " + sql));
                    IRowSet idRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    SCMSqlUtil.releasTempTable((Context)ctx, (String)this.tmpTable);
                    HashSet<String> idSet = new HashSet<String>();
                    while (idRs.next()) {
                        idSet.add(idRs.getString(params.getSecEntryIdField()));
                    }
                    List secList = params.getSecList();
                    String secEntryId = null;
                    int size = secList.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        secEntryId = ((WriteOffCommonInfo)secList.get(i2)).getEntryId();
                        if (!idSet.contains(secEntryId)) continue;
                        secRealList.add((WriteOffCommonInfo)secList.get(i2));
                    }
                }
                SQLUtils.cleanup((ResultSet)mainRs);
                requestLockArr = requestLockList.toArray(new String[requestLockList.size()]);
                if (!SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getIsBillMultiapprove(requestLockArr)) {
                    requestLockMap = iMutexServiceControl.batchRequestObjIDForUpdate(requestLockList);
                    int size = requestLockList.size();
                    for (int i3 = 0; i3 < size; ++i3) {
                        id = (String)requestLockList.get(i3);
                        if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                            thisLockList.add(id);
                            continue;
                        }
                        otherLockList.add(id);
                    }
                    if (otherLockList.size() > 0) {
                        throw new WriteOffCommonException(WriteOffCommonException.BILL_LOCKED);
                    }
                }
            }
            if (params.get("downQueryFilter") != null) {
                sql = this.getExecutorSql(ctx, params.getSecQueryName(), secSelectors, this.getFilter((FilterInfo)params.get("downQueryFilter"), secRealList, params.getSecEntryIdField(), isHeadView), (SorterItemCollection)params.get("downOrder"), params.getSecEntryIdField().split("\\.")[0], conditionEntryInfo.getSecBillFilter());
                sql = this.getOptimizeSql(sql, params.getSecEntryIdField().split("\\.")[0], false);
                logger.debug((Object)("SEC MANUAL WRITEOFF SQL: " + sql));
                IRowSet secRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                SCMSqlUtil.releasTempTable((Context)ctx, (String)this.tmpTable);
                if (isCommonWriteOff && secRs.size() == 0) {
                    List i3 = null;
                    return i3;
                }
                requestLockList.clear();
                secMap = this.getWriteOffMapping(ctx, secRs, secRealList, fieldColl, strategy, params, false, requestLockList);
                SQLUtils.cleanup((ResultSet)secRs);
                this.handleLockList(ctx, requestLockList, thisLockList, otherLockList);
            }
            logger.debug((Object)("MANUAL WRITEOFF MAIN MAP: " + mainMap));
            logger.debug((Object)("MANUAL WRITEOFF SEC MAP: " + secMap));
            result = strategy.buildWriteOffBillInfo(ctx, mainMap, secMap, conditionEntryInfo, params);
            for (int i4 = 0; i4 < result.size(); ++i4) {
                String writeOffID = result.get(i4).toString();
                String woSql = "select FBillID,FBillEntryID,fparentid from t_cl_writeoffrecord where fparentid ='" + writeOffID + "' and FBillTypeNumber='330'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)woSql);
                if (!rs.next()) continue;
                String arBillID = rs.getString("FBillID");
                ctx.put((Object)"ArBillEntryID", (Object)rs.getString("FBillEntryID"));
                ctx.put((Object)"writeOffID", (Object)rs.getString("fparentid"));
                CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{arBillID}, CreditOperationEnum.ManualWriteOff);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
            ctx.remove((Object)"ArBillEntryID");
            ctx.remove((Object)"writeOffID");
        }
        return result;
    }

    private void handleLockList(Context ctx, List requestLockList, List thisLockList, List otherLockList) throws BOSException, EASBizException {
        String[] requestLockArr = requestLockList.toArray(new String[requestLockList.size()]);
        int waitTime = this.getWaitTime(ctx);
        if (!SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getIsBillMultiapprove(requestLockArr)) {
            if (0 != waitTime && this.hashOtherLock(ctx, requestLockList)) {
                try {
                    Thread.sleep(waitTime * 1000);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            Map requestLockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(requestLockList);
            int size = requestLockList.size();
            for (int i = 0; i < size; ++i) {
                String id = (String)requestLockList.get(i);
                if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                    thisLockList.add(id);
                    continue;
                }
                otherLockList.add(id);
            }
            if (otherLockList.size() > 0) {
                throw new WriteOffCommonException(WriteOffCommonException.BILL_LOCKED);
            }
        }
    }

    private boolean hashOtherLock(Context ctx, List requestLockList) throws BOSException, WriteOffCommonException {
        Map requestLockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(requestLockList);
        int size = requestLockList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)requestLockList.get(i);
            if (((Boolean)requestLockMap.get(id)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Map _getAutoCarryInvBillFilter(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        MappingFieldCollection fieldColl = new MappingFieldCollection();
        MappingConditionEntryInfo conditionEntryInfo = null;
        if (params.getMappingEntryId() != null && !"".equals(params.getMappingEntryId())) {
            conditionEntryInfo = MappingConditionEntryFactory.getLocalInstance(ctx).getMappingConditionEntryInfo("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.* WHERE id = '" + params.getMappingEntryId() + "'");
            fieldColl.addCollection(conditionEntryInfo.getMappingField());
        }
        if (fieldColl.size() == 0) {
            return null;
        }
        IWriteOffStrategy strategy = WriteOffStrategyFactory.getInstance().getWriteOffStrategy(params.getStrategy());
        SelectorItemCollection mainSelectors = strategy.getSelector(params.getMainEntityId(), params);
        SelectorItemCollection secSelectors = strategy.getSelector(params.getSecEntityId(), params);
        mainSelectors.add(new SelectorItemInfo("id"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("id"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        mainSelectors.add(new SelectorItemInfo("number"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField().split("\\.")[0] + ".seq"));
        secSelectors.add(new SelectorItemInfo("number"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField().split("\\.")[0] + ".seq"));
        mainSelectors.add(new SelectorItemInfo("lastUpdateTime"));
        mainSelectors.add(new SelectorItemInfo(params.getMainEntryIdField()));
        secSelectors.add(new SelectorItemInfo("lastUpdateTime"));
        secSelectors.add(new SelectorItemInfo(params.getSecEntryIdField()));
        int size = fieldColl.size();
        for (int i = 0; i < size; ++i) {
            mainSelectors.add(new SelectorItemInfo(fieldColl.get(i).getMainField()));
            secSelectors.add(new SelectorItemInfo(fieldColl.get(i).getSecField()));
        }
        HashMap resultMap = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        String tempTable = null;
        try {
            boolean isHeadView = params.get("isHeadView") instanceof Boolean && (Boolean)params.get("isHeadView") != false;
            String mainSql = this.getExecutorSql2Filter(ctx, params.getMainQueryName(), mainSelectors, this.getFilter((FilterInfo)params.get("upQueryFilter"), params.getMainList(), params.getMainEntryIdField(), isHeadView));
            mainSql = this.getOptimizeSql2Filter(mainSql, params.getMainEntryIdField().split("\\.")[0], false);
            String secSql = this.getExecutorSql2Filter(ctx, params.getSecQueryName(), secSelectors, this.getFilter((FilterInfo)params.get("downQueryFilter"), params.getSecList(), params.getSecEntryIdField(), isHeadView));
            secSql = this.getOptimizeSql2Filter(secSql, params.getSecEntryIdField().split("\\.")[0], false);
            StringBuffer sql = new StringBuffer();
            MappingFieldInfo fieldInfo = null;
            sql.append(" SELECT T1.\"ID\" as FID FROM (").append(mainSql).append(") T0 ");
            sql.append(" INNER JOIN (").append(secSql).append(") T1 on ");
            int size2 = fieldColl.size();
            for (int i = 0; i < size2; ++i) {
                fieldInfo = (MappingFieldInfo)fieldColl.getObject(i);
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("T0.\"" + fieldInfo.getMainField().toUpperCase() + "\"").append("=").append("T1.\"" + fieldInfo.getSecField().toUpperCase() + "\"");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                ids.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SCMSqlUtil.releasTempTable((Context)ctx, tempTable);
            SCMSqlUtil.releasTempTable((Context)ctx, (String)this.tmpTable);
        }
        resultMap.put("ids", ids);
        return resultMap;
    }

    private String getExecutorSql2Filter(Context context, String queryName, SelectorItemCollection sic, FilterInfo filter) throws BOSException {
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        EntityViewInfo entityView = new EntityViewInfo();
        if (sic != null) {
            entityView.setSelector(sic);
        }
        if (filter != null) {
            entityView.setFilter(filter);
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.option().isIgnorePermissionCheck = true;
        exec.option().isIgnoreOrder = true;
        exec.setObjectView(entityView);
        String sql = exec.getSQL();
        return sql;
    }

    private String getOptimizeSql2Filter(String sql, String entryFieldName, boolean isChangeDrivingTable) {
        Pattern from = Pattern.compile("FROM[^\"]+\"[^\"]+\"", 2);
        Pattern join = Pattern.compile("(LEFT|INNER|RIGHT).+JOIN[^\"]+\"[^\"]+\"", 2);
        Pattern on = Pattern.compile("ON\\s\"[^\"]+\"\\..+[^(LEFT|INNER|RIGHT|WHERE)]", 2);
        Matcher fromMatcher = from.matcher(sql);
        Matcher joinMatcher = join.matcher(sql);
        Matcher onMatcher = on.matcher(sql);
        ArrayList<String> joinList = new ArrayList<String>();
        while (joinMatcher.find()) {
            joinList.add(joinMatcher.group());
        }
        ArrayList<String> onList = new ArrayList<String>();
        while (onMatcher.find()) {
            onList.add(onMatcher.group());
        }
        if (fromMatcher.find() && joinList.size() > 0 && joinList.size() == onList.size()) {
            String selectSql = sql.substring(0, sql.indexOf("FROM"));
            String fromSql = fromMatcher.group();
            String joinSql = sql.substring(sql.indexOf("FROM"), sql.indexOf("WHERE"));
            String whereSql = sql.substring(sql.indexOf("WHERE"), sql.length());
            StringBuilder sb = new StringBuilder(selectSql);
            if (isChangeDrivingTable) {
                String entryTable = null;
                String entryJoin = null;
                int size = joinList.size();
                for (int i = 0; i < size; ++i) {
                    if (((String)joinList.get(i)).indexOf(entryFieldName.toUpperCase()) == -1) continue;
                    entryTable = ((String)joinList.get(i)).substring(((String)joinList.get(i)).indexOf("JOIN") + 4);
                    entryJoin = (String)onList.get(i);
                    joinList.remove(i);
                    onList.remove(i);
                    break;
                }
                sb.append("FROM ").append(entryTable).append("\n");
                sb.append("INNER JOIN ").append(fromSql.substring(4)).append("\n");
                sb.append(entryJoin).append("\n");
            } else {
                sb.append(fromSql).append("\n");
            }
            String tableName = null;
            int size = joinList.size();
            for (int i = 0; i < size; ++i) {
                tableName = ((String)joinList.get(i)).substring(((String)joinList.get(i)).indexOf("\""));
                if (selectSql.indexOf(tableName) == -1 && joinSql.indexOf(tableName, joinSql.indexOf((String)onList.get(i)) + ((String)onList.get(i)).length()) == -1 && whereSql.indexOf(tableName) == -1) continue;
                sb.append((String)joinList.get(i)).append("\n").append((String)onList.get(i));
            }
            sb.append(whereSql);
            sql = sb.toString();
        }
        return sql;
    }

    private String getOptimizeSql2Verify(String sql, WriteOffCommonParams params) {
        String retSql = sql;
        String strategy = params.getStrategy();
        if ("verification".equals(strategy) && sql.toLowerCase().indexOf("t_cas_paymentbillentry") > 0 && params.isFlowWriteOff()) {
            retSql = sql.replace("SELECT ", "select /*+ LEADING(ENTRIES) */ ");
        }
        return retSql;
    }

    public int getWaitTime(Context ctx) throws BOSException {
        int waitTime = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fvalue FROM T_DT_DTTEMPPARAM where fkey = 'writeWaitTime'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                waitTime = rs.getInt("fvalue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return waitTime;
    }

    private void lockDbBill(Context ctx, Set<String> idSet, String bosType) throws SCMBillException, BOSException {
        String ids = "(" + CalculateUtil.getSqlInString(idSet) + ")";
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        if ("48DA3A71".equals(bosType)) {
            sql.append("t_ap_otherbill");
        } else if ("FC910EF3".equals(bosType)) {
            sql.append("T_AR_OtherBill");
        } else if ("CC3E933B".equals(bosType)) {
            sql.append("T_IM_SaleIssueBill");
        } else if ("783061E3".equals(bosType)) {
            sql.append("T_IM_PurInWarehsBill");
        } else if ("A8378ABC".equals(bosType)) {
            sql.append("T_AR_IncomeConfimBill");
        } else if ("FA44FD5B".equals(bosType)) {
            sql.append("T_CAS_ReceivingBill");
        } else if ("40284E81".equals(bosType)) {
            sql.append("T_CAS_PaymentBill");
        } else {
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{"type not support"});
        }
        sql.append(" set fid = fid where fid in").append(ids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _synUnWriteOffQty(Context ctx, String billTypeNumber, List billIds) throws BOSException, EASBizException {
        List purInBillIdList = this._getPurInIdsByWOffRecord(ctx, billTypeNumber, billIds);
        this._synUnWriteOffQty(ctx, purInBillIdList);
    }

    @Override
    protected void _synUnWriteOffQty(Context ctx, List purInBillIdList) throws BOSException {
        if (purInBillIdList == null || purInBillIdList.size() == 0) {
            return;
        }
        if (!CommonUtils.hasCFField(ctx)) {
            return;
        }
        Method method = null;
        Object[] values = new Object[4];
        try {
            Class<?> cla = Class.forName("com.kingdee.eas.scm.nsrm.app.frombiz.SendFromBizServiceImpl");
            Class[] paramType = new Class[]{Context.class, String.class, String.class, Boolean.TYPE};
            method = cla.getMethod("execute", paramType);
            values[0] = ctx;
            values[1] = "Sys_PurInwarehs_UnWriteOffQty";
            values[3] = Boolean.FALSE;
        }
        catch (ClassNotFoundException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            for (int i = 0; i < purInBillIdList.size(); ++i) {
                values[2] = purInBillIdList.get(i);
                method.invoke(null, values);
            }
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List _getPurInIdsByWOffRecord(Context ctx, String billTypeNumber, List idList) throws BOSException, EASBizException {
        return this._getPurInIdsByWOffRecord(ctx, billTypeNumber, idList, true);
    }

    @Override
    protected List _getPurInIdsByWOffRecord(Context ctx, String billTypeNumber, List idList, boolean isNeedRed) throws BOSException, EASBizException {
        String ids;
        if (idList == null || idList.size() == 0) {
            return null;
        }
        if (!CommonUtils.hasCFField(ctx)) {
            return null;
        }
        String idWhere = ids = this.getIdStr(idList);
        if ("103".equals(billTypeNumber) || "230".equals(billTypeNumber)) {
            idWhere = "select distinct FPARENTID from T_CL_WRITEOFFRECORD where FBILLID in (" + ids + ")";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct en.FPARENTID as billId from T_CL_WRITEOFFRECORD r ");
        sql.append("inner join T_IM_PURINWAREHSENTRY en on en.fid = r.FBILLENTRYID ");
        sql.append("inner join T_BD_SUPPLIER s on s.fid = r.FSUPPLIERID ");
        sql.append("where r.FPARENTID in (" + idWhere + ")");
        sql.append("and r.FBILLTYPENUMBER = '103' and isnull(en.CFIsContrastDrew,0) = 0 ");
        sql.append("and s.CFIsSrm = 1 ");
        if (!isNeedRed) {
            sql.append("and r.FCURRWRITTENOFFQTY > 0 ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> purInBillIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                purInBillIdList.add(rs.getString("billId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return purInBillIdList;
    }

    private String getIdStr(List idList) {
        String ids = "";
        for (int i = 0; i < idList.size(); ++i) {
            if (i != 0) {
                ids = ids + ",";
            }
            ids = ids + "'" + idList.get(i) + "'";
        }
        return ids;
    }

    @Override
    protected List _getRedPurInIds(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        if (!CommonUtils.hasCFField(ctx)) {
            return null;
        }
        String ids = this.getIdStr(idList);
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FID as billId from T_IM_PURINWAREHSBILL b ");
        sql.append("inner join T_SCM_TRANSACTIONTYPE t on b.FTRANSACTIONTYPEID = t.FID ");
        sql.append("inner join T_IM_RECISSUETYPE r on r.fid = t.FRITYPEID ");
        sql.append("where b.fid in (" + ids + ") ");
        sql.append("and r.FBIZDIRECTION = -1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> purInBillIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                purInBillIdList.add(rs.getString("billId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return purInBillIdList;
    }
}

