/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.graphml;

import com.mxgraph.io.graphml.mxGraphMlConstants;
import com.mxgraph.io.graphml.mxGraphMlData;
import com.mxgraph.io.graphml.mxGraphMlEdge;
import com.mxgraph.io.graphml.mxGraphMlKey;
import com.mxgraph.io.graphml.mxGraphMlKeyManager;
import com.mxgraph.io.graphml.mxGraphMlNode;
import com.mxgraph.io.graphml.mxGraphMlShapeEdge;
import com.mxgraph.io.graphml.mxGraphMlUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGraphMlGraph {
    private static HashMap<String, Object> cellsMap = new HashMap();
    private String id = "";
    private String edgedefault = "";
    private List<mxGraphMlNode> nodes = new ArrayList<mxGraphMlNode>();
    private List<mxGraphMlEdge> edges = new ArrayList<mxGraphMlEdge>();

    public mxGraphMlGraph(String id, String edgedefault) {
        this.id = id;
        this.edgedefault = edgedefault;
    }

    public mxGraphMlGraph() {
    }

    public mxGraphMlGraph(Element graphElement) {
        this.id = graphElement.getAttribute(mxGraphMlConstants.ID);
        this.edgedefault = graphElement.getAttribute(mxGraphMlConstants.EDGE_DEFAULT);
        List<Element> nodeElements = mxGraphMlUtils.childsTags(graphElement, mxGraphMlConstants.NODE);
        for (Element nodeElem : nodeElements) {
            mxGraphMlNode node = new mxGraphMlNode(nodeElem);
            this.nodes.add(node);
        }
        List<Element> edgeElements = mxGraphMlUtils.childsTags(graphElement, mxGraphMlConstants.EDGE);
        for (Element edgeElem : edgeElements) {
            mxGraphMlEdge edge = new mxGraphMlEdge(edgeElem);
            if (edge.getEdgeDirected().equals("")) {
                if (this.edgedefault.equals(mxGraphMlConstants.EDGE_DIRECTED)) {
                    edge.setEdgeDirected("true");
                } else if (this.edgedefault.equals(mxGraphMlConstants.EDGE_UNDIRECTED)) {
                    edge.setEdgeDirected("false");
                }
            }
            this.edges.add(edge);
        }
    }

    public void addGraph(mxGraph graph, Object parent) {
        List<mxGraphMlNode> nodeList = this.getNodes();
        for (mxGraphMlNode node : nodeList) {
            this.addNode(graph, parent, node);
        }
        List<mxGraphMlEdge> edgeList = this.getEdges();
        for (mxGraphMlEdge edge : edgeList) {
            mxGraphMlGraph.addEdge(graph, parent, edge);
        }
    }

    public static boolean hasData(mxGraphMlNode node) {
        boolean ret = false;
        ret = node.getNodeDataMap() != null;
        return ret;
    }

    public static mxGraphMlData dataNodeKey(mxGraphMlNode node) {
        String keyId = "";
        HashMap<String, mxGraphMlKey> keyMap = mxGraphMlKeyManager.getInstance().getKeyMap();
        for (mxGraphMlKey key : keyMap.values()) {
            if (!key.getKeyName().equals(mxGraphMlConstants.KEY_NODE_NAME)) continue;
            keyId = key.getKeyId();
        }
        mxGraphMlData data = null;
        HashMap<String, mxGraphMlData> nodeDataMap = node.getNodeDataMap();
        data = nodeDataMap.get(keyId);
        return data;
    }

    public static mxGraphMlData dataEdgeKey(mxGraphMlEdge edge) {
        String keyId = "";
        HashMap<String, mxGraphMlKey> keyMap = mxGraphMlKeyManager.getInstance().getKeyMap();
        for (mxGraphMlKey key : keyMap.values()) {
            if (!key.getKeyName().equals(mxGraphMlConstants.KEY_EDGE_NAME)) continue;
            keyId = key.getKeyId();
        }
        mxGraphMlData data = null;
        HashMap<String, mxGraphMlData> nodeDataMap = edge.getEdgeDataMap();
        data = nodeDataMap.get(keyId);
        return data;
    }

    private mxCell addNode(mxGraph graph, Object parent, mxGraphMlNode node) {
        mxCell v1;
        String id = node.getNodeId();
        mxGraphMlData data = mxGraphMlGraph.dataNodeKey(node);
        if (data != null && data.getDataShapeNode() != null) {
            Double x = Double.valueOf(data.getDataShapeNode().getDataX());
            Double y = Double.valueOf(data.getDataShapeNode().getDataY());
            Double h = Double.valueOf(data.getDataShapeNode().getDataHeight());
            Double w = Double.valueOf(data.getDataShapeNode().getDataWidth());
            String label = data.getDataShapeNode().getDataLabel();
            String style = data.getDataShapeNode().getDataStyle();
            v1 = (mxCell)graph.insertVertex(parent, id, label, x, y, w, h, style);
        } else {
            v1 = (mxCell)graph.insertVertex(parent, id, "", 0.0, 0.0, 100.0, 100.0);
        }
        cellsMap.put(id, v1);
        List<mxGraphMlGraph> graphs = node.getNodeGraph();
        for (mxGraphMlGraph gmlGraph : graphs) {
            gmlGraph.addGraph(graph, v1);
        }
        return v1;
    }

    private static mxPoint portValue(String source) {
        mxPoint fromConstraint = null;
        if (source != null && !source.equals("")) {
            if (source.equals("North")) {
                fromConstraint = new mxPoint(0.5, 0.0);
            } else if (source.equals("South")) {
                fromConstraint = new mxPoint(0.5, 1.0);
            } else if (source.equals("East")) {
                fromConstraint = new mxPoint(1.0, 0.5);
            } else if (source.equals("West")) {
                fromConstraint = new mxPoint(0.0, 0.5);
            } else if (source.equals("NorthWest")) {
                fromConstraint = new mxPoint(0.0, 0.0);
            } else if (source.equals("SouthWest")) {
                fromConstraint = new mxPoint(0.0, 1.0);
            } else if (source.equals("SouthEast")) {
                fromConstraint = new mxPoint(1.0, 1.0);
            } else if (source.equals("NorthEast")) {
                fromConstraint = new mxPoint(1.0, 0.0);
            } else {
                try {
                    String[] s = source.split(",");
                    Double x = Double.valueOf(s[0]);
                    Double y = Double.valueOf(s[1]);
                    fromConstraint = new mxPoint(x, y);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return fromConstraint;
    }

    private static mxCell addEdge(mxGraph graph, Object parent, mxGraphMlEdge edge) {
        mxPoint fromConstraint = null;
        mxPoint toConstraint = null;
        Object source = cellsMap.get(edge.getEdgeSource());
        Object target = cellsMap.get(edge.getEdgeTarget());
        String sourcePort = edge.getEdgeSourcePort();
        String targetPort = edge.getEdgeTargetPort();
        fromConstraint = mxGraphMlGraph.portValue(sourcePort);
        toConstraint = mxGraphMlGraph.portValue(targetPort);
        mxGraphMlData data = mxGraphMlGraph.dataEdgeKey(edge);
        String style = "";
        String label = "";
        if (data != null) {
            mxGraphMlShapeEdge shEdge = data.getDataShapeEdge();
            style = shEdge.getStyle();
            label = shEdge.getText();
        } else {
            style = edge.getEdgeStyle();
        }
        mxCell e = (mxCell)graph.insertEdge(parent, null, label, source, target, style);
        graph.setConnectionConstraint(e, source, true, new mxConnectionConstraint(fromConstraint, false));
        graph.setConnectionConstraint(e, target, false, new mxConnectionConstraint(toConstraint, false));
        return e;
    }

    public String getEdgedefault() {
        return this.edgedefault;
    }

    public void setEdgedefault(String edgedefault) {
        this.edgedefault = edgedefault;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<mxGraphMlNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<mxGraphMlNode> node) {
        this.nodes = node;
    }

    public List<mxGraphMlEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<mxGraphMlEdge> edge) {
        this.edges = edge;
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0 && this.edges.size() == 0;
    }

    public Element generateElement(Document document) {
        Element graph = document.createElement(mxGraphMlConstants.GRAPH);
        if (!this.id.equals("")) {
            graph.setAttribute(mxGraphMlConstants.ID, this.id);
        }
        if (!this.edgedefault.equals("")) {
            graph.setAttribute(mxGraphMlConstants.EDGE_DEFAULT, this.edgedefault);
        }
        for (mxGraphMlNode node : this.nodes) {
            Element nodeElement = node.generateElement(document);
            graph.appendChild(nodeElement);
        }
        for (mxGraphMlEdge edge : this.edges) {
            Element edgeElement = edge.generateElement(document);
            graph.appendChild(edgeElement);
        }
        return graph;
    }
}

