/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.graphml;

import com.mxgraph.io.graphml.mxGraphMlConstants;
import com.mxgraph.io.graphml.mxGraphMlData;
import com.mxgraph.io.graphml.mxGraphMlGraph;
import com.mxgraph.io.graphml.mxGraphMlPort;
import com.mxgraph.io.graphml.mxGraphMlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGraphMlNode {
    private String nodeId;
    private mxGraphMlData nodeData;
    private List<mxGraphMlGraph> nodeGraphList = new ArrayList<mxGraphMlGraph>();
    private HashMap<String, mxGraphMlData> nodeDataMap = new HashMap();
    private HashMap<String, mxGraphMlPort> nodePortMap = new HashMap();

    public mxGraphMlNode(String nodeId, mxGraphMlData nodeData) {
        this.nodeId = nodeId;
        this.nodeData = nodeData;
    }

    public mxGraphMlNode(Element nodeElement) {
        this.nodeId = nodeElement.getAttribute(mxGraphMlConstants.ID);
        List<Element> dataList = mxGraphMlUtils.childsTags(nodeElement, mxGraphMlConstants.DATA);
        for (Element element : dataList) {
            mxGraphMlData data = new mxGraphMlData(element);
            String key = data.getDataKey();
            this.nodeDataMap.put(key, data);
        }
        List<Element> graphList = mxGraphMlUtils.childsTags(nodeElement, mxGraphMlConstants.GRAPH);
        for (Element graphElem : graphList) {
            mxGraphMlGraph graph = new mxGraphMlGraph(graphElem);
            this.nodeGraphList.add(graph);
        }
        List<Element> list = mxGraphMlUtils.childsTags(nodeElement, mxGraphMlConstants.PORT);
        for (Element portElem : list) {
            mxGraphMlPort port = new mxGraphMlPort(portElem);
            String name = port.getName();
            this.nodePortMap.put(name, port);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public HashMap<String, mxGraphMlData> getNodeDataMap() {
        return this.nodeDataMap;
    }

    public void setNodeDataMap(HashMap<String, mxGraphMlData> nodeDataMap) {
        this.nodeDataMap = nodeDataMap;
    }

    public List<mxGraphMlGraph> getNodeGraph() {
        return this.nodeGraphList;
    }

    public void setNodeGraph(List<mxGraphMlGraph> nodeGraph) {
        this.nodeGraphList = nodeGraph;
    }

    public HashMap<String, mxGraphMlPort> getNodePort() {
        return this.nodePortMap;
    }

    public void setNodePort(HashMap<String, mxGraphMlPort> nodePort) {
        this.nodePortMap = nodePort;
    }

    public Element generateElement(Document document) {
        Element node = document.createElement(mxGraphMlConstants.NODE);
        node.setAttribute(mxGraphMlConstants.ID, this.nodeId);
        Element dataElement = this.nodeData.generateNodeElement(document);
        node.appendChild(dataElement);
        for (mxGraphMlPort port : this.nodePortMap.values()) {
            Element portElement = port.generateElement(document);
            node.appendChild(portElement);
        }
        for (mxGraphMlGraph graph : this.nodeGraphList) {
            Element graphElement = graph.generateElement(document);
            node.appendChild(graphElement);
        }
        return node;
    }

    public mxGraphMlData getNodeData() {
        return this.nodeData;
    }

    public void setNodeData(mxGraphMlData nodeData) {
        this.nodeData = nodeData;
    }
}

