/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.io.graphml.mxGraphMlConstants;
import com.mxgraph.io.graphml.mxGraphMlData;
import com.mxgraph.io.graphml.mxGraphMlEdge;
import com.mxgraph.io.graphml.mxGraphMlGraph;
import com.mxgraph.io.graphml.mxGraphMlKey;
import com.mxgraph.io.graphml.mxGraphMlKeyManager;
import com.mxgraph.io.graphml.mxGraphMlNode;
import com.mxgraph.io.graphml.mxGraphMlShapeEdge;
import com.mxgraph.io.graphml.mxGraphMlShapeNode;
import com.mxgraph.io.graphml.mxGraphMlUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class mxGraphMlCodec {
    public static void decode(Document document, mxGraph graph) {
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        mxGraphMlKeyManager.getInstance().initialise(document);
        NodeList graphs = document.getElementsByTagName(mxGraphMlConstants.GRAPH);
        if (graphs.getLength() > 0) {
            Element graphElement = (Element)graphs.item(0);
            mxGraphMlGraph gmlGraph = new mxGraphMlGraph(graphElement);
            gmlGraph.addGraph(graph, parent);
        }
        graph.getModel().endUpdate();
        mxGraphMlCodec.cleanMaps();
    }

    private static void cleanMaps() {
        mxGraphMlKeyManager.getInstance().getKeyMap().clear();
    }

    public static Document encodeXML(mxGraphMlGraph gmlGraph) {
        Document doc = mxDomUtils.createDocument();
        Element graphml = doc.createElement(mxGraphMlConstants.GRAPHML);
        graphml.setAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        graphml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        graphml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jGraph", mxGraphMlConstants.JGRAPH_URL);
        graphml.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        HashMap<String, mxGraphMlKey> keyMap = mxGraphMlKeyManager.getInstance().getKeyMap();
        for (mxGraphMlKey key : keyMap.values()) {
            Element keyElement = key.generateElement(doc);
            graphml.appendChild(keyElement);
        }
        Element graphE = gmlGraph.generateElement(doc);
        graphml.appendChild(graphE);
        doc.appendChild(graphml);
        mxGraphMlCodec.cleanMaps();
        return doc;
    }

    public static Document encode(mxGraph graph) {
        mxGraphMlGraph gmlGraph = new mxGraphMlGraph();
        Object parent = graph.getDefaultParent();
        mxGraphMlCodec.createKeyElements();
        gmlGraph = mxGraphMlCodec.decodeGraph(graph, parent, gmlGraph);
        gmlGraph.setEdgedefault(mxGraphMlConstants.EDGE_DIRECTED);
        Document document = mxGraphMlCodec.encodeXML(gmlGraph);
        return document;
    }

    private static void createKeyElements() {
        HashMap<String, mxGraphMlKey> keyMap = mxGraphMlKeyManager.getInstance().getKeyMap();
        mxGraphMlKey keyNode = new mxGraphMlKey(mxGraphMlConstants.KEY_NODE_ID, mxGraphMlKey.keyForValues.NODE, mxGraphMlConstants.KEY_NODE_NAME, mxGraphMlKey.keyTypeValues.STRING);
        keyMap.put(mxGraphMlConstants.KEY_NODE_ID, keyNode);
        mxGraphMlKey keyEdge = new mxGraphMlKey(mxGraphMlConstants.KEY_EDGE_ID, mxGraphMlKey.keyForValues.EDGE, mxGraphMlConstants.KEY_EDGE_NAME, mxGraphMlKey.keyTypeValues.STRING);
        keyMap.put(mxGraphMlConstants.KEY_EDGE_ID, keyEdge);
        mxGraphMlKeyManager.getInstance().setKeyMap(keyMap);
    }

    public static mxGraphMlGraph decodeGraph(mxGraph graph, Object parent, mxGraphMlGraph gmlGraph) {
        Object[] vertexes = graph.getChildVertices(parent);
        List<mxGraphMlEdge> gmlEdges = gmlGraph.getEdges();
        gmlEdges = mxGraphMlCodec.encodeEdges(gmlEdges, parent, graph);
        gmlGraph.setEdges(gmlEdges);
        for (Object vertex : vertexes) {
            List<mxGraphMlNode> Gmlnodes = gmlGraph.getNodes();
            mxCell v = (mxCell)vertex;
            String id = v.getId();
            mxGraphMlNode gmlNode = new mxGraphMlNode(id, null);
            mxGraphMlCodec.addNodeData(gmlNode, v);
            Gmlnodes.add(gmlNode);
            gmlGraph.setNodes(Gmlnodes);
            mxGraphMlGraph gmlGraphx = new mxGraphMlGraph();
            gmlGraphx = mxGraphMlCodec.decodeGraph(graph, vertex, gmlGraphx);
            if (gmlGraphx.isEmpty()) continue;
            List<mxGraphMlGraph> nodeGraphs = gmlNode.getNodeGraph();
            nodeGraphs.add(gmlGraphx);
            gmlNode.setNodeGraph(nodeGraphs);
        }
        return gmlGraph;
    }

    public static void addNodeData(mxGraphMlNode gmlNode, mxCell v) {
        mxGraphMlData data = new mxGraphMlData();
        mxGraphMlShapeNode dataShapeNode = new mxGraphMlShapeNode();
        data.setDataKey(mxGraphMlConstants.KEY_NODE_ID);
        dataShapeNode.setDataHeight(String.valueOf(v.getGeometry().getHeight()));
        dataShapeNode.setDataWidth(String.valueOf(v.getGeometry().getWidth()));
        dataShapeNode.setDataX(String.valueOf(v.getGeometry().getX()));
        dataShapeNode.setDataY(String.valueOf(v.getGeometry().getY()));
        dataShapeNode.setDataLabel(v.getValue() != null ? v.getValue().toString() : "");
        dataShapeNode.setDataStyle(v.getStyle() != null ? v.getStyle() : "");
        data.setDataShapeNode(dataShapeNode);
        gmlNode.setNodeData(data);
    }

    public static void addEdgeData(mxGraphMlEdge gmlEdge, mxCell v) {
        mxGraphMlData data = new mxGraphMlData();
        mxGraphMlShapeEdge dataShapeEdge = new mxGraphMlShapeEdge();
        data.setDataKey(mxGraphMlConstants.KEY_EDGE_ID);
        dataShapeEdge.setText(v.getValue() != null ? v.getValue().toString() : "");
        dataShapeEdge.setStyle(v.getStyle() != null ? v.getStyle() : "");
        data.setDataShapeEdge(dataShapeEdge);
        gmlEdge.setEdgeData(data);
    }

    private static String pointToPortString(mxPoint point) {
        String port = "";
        if (point != null) {
            double x = point.getX();
            double y = point.getY();
            port = x == 0.0 && y == 0.0 ? "NorthWest" : (x == 0.5 && y == 0.0 ? "North" : (x == 1.0 && y == 0.0 ? "NorthEast" : (x == 1.0 && y == 0.5 ? "East" : (x == 1.0 && y == 1.0 ? "SouthEast" : (x == 0.5 && y == 1.0 ? "South" : (x == 0.0 && y == 1.0 ? "SouthWest" : (x == 0.0 && y == 0.5 ? "West" : "" + x + "," + y)))))));
        }
        return port;
    }

    private static List<mxGraphMlEdge> encodeEdges(List<mxGraphMlEdge> Gmledges, Object parent, mxGraph graph) {
        Object[] edges;
        for (Object edge : edges = graph.getChildEdges(parent)) {
            HashMap<String, Object> styleMap;
            String endArrow;
            mxCell e = (mxCell)edge;
            mxCell source = (mxCell)e.getSource();
            mxCell target = (mxCell)e.getTarget();
            String sourceName = "";
            String targetName = "";
            String sourcePort = "";
            String targetPort = "";
            sourceName = source != null ? source.getId() : "";
            targetName = target != null ? target.getId() : "";
            mxGraphView view = graph.getView();
            mxPoint sourceConstraint = null;
            mxPoint targetConstraint = null;
            if (view != null) {
                mxCellState targetState;
                mxConnectionConstraint tcc;
                mxCellState sourceState;
                mxCellState edgeState = view.getState(edge);
                mxConnectionConstraint scc = graph.getConnectionConstraint(edgeState, sourceState = view.getState(source), true);
                if (scc != null) {
                    sourceConstraint = scc.getPoint();
                }
                if ((tcc = graph.getConnectionConstraint(edgeState, targetState = view.getState(target), false)) != null) {
                    targetConstraint = tcc.getPoint();
                }
            }
            targetPort = mxGraphMlCodec.pointToPortString(targetConstraint);
            sourcePort = mxGraphMlCodec.pointToPortString(sourceConstraint);
            mxGraphMlEdge Gmledge = new mxGraphMlEdge(sourceName, targetName, sourcePort, targetPort);
            String style = e.getStyle();
            if (style == null) {
                style = "horizontal";
            }
            if ((endArrow = (String)(styleMap = mxGraphMlUtils.getStyleMap(style, "=")).get(mxConstants.STYLE_ENDARROW)) != null && !endArrow.equals(mxConstants.NONE) || endArrow == null) {
                Gmledge.setEdgeDirected("true");
            } else {
                Gmledge.setEdgeDirected("false");
            }
            mxGraphMlCodec.addEdgeData(Gmledge, e);
            Gmledges.add(Gmledge);
        }
        return Gmledges;
    }
}

