/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class mxGraphTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -6443287704811197675L;
    public static boolean DEFAULT_TRANSFER_IMAGE_ENABLED = true;
    public static Color DEFAULT_BACKGROUNDCOLOR = Color.WHITE;
    protected Object[] originalCells;
    protected Transferable lastImported;
    protected int initialImportCount = 1;
    protected int importCount = 0;
    protected boolean transferImageEnabled = DEFAULT_TRANSFER_IMAGE_ENABLED;
    protected Color transferImageBackground = DEFAULT_BACKGROUNDCOLOR;
    protected Point location;
    protected Point offset;

    public int getImportCount() {
        return this.importCount;
    }

    public void setImportCount(int value) {
        this.importCount = value;
    }

    public void setTransferImageEnabled(boolean transferImageEnabled) {
        this.transferImageEnabled = transferImageEnabled;
    }

    public boolean isTransferImageEnabled() {
        return this.transferImageEnabled;
    }

    public void setTransferImageBackground(Color transferImageBackground) {
        this.transferImageBackground = transferImageBackground;
    }

    public Color getTransferImageBackground() {
        return this.transferImageBackground;
    }

    public boolean isLocalDrag() {
        return this.originalCells != null;
    }

    public void setLocation(Point value) {
        this.location = value;
    }

    public void setOffset(Point value) {
        this.offset = value;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i] == null || !flavors[i].equals(mxGraphTransferable.dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        mxGraphComponent graphComponent;
        mxGraph graph;
        if (c instanceof mxGraphComponent && !(graph = (graphComponent = (mxGraphComponent)c).getGraph()).isSelectionEmpty()) {
            this.originalCells = graphComponent.getExportableCells(graph.getSelectionCells());
            if (this.originalCells.length > 0) {
                ImageIcon icon = this.transferImageEnabled ? this.createTransferableImage(graphComponent, this.originalCells) : null;
                return this.createGraphTransferable(graphComponent, this.originalCells, icon);
            }
        }
        return null;
    }

    public mxGraphTransferable createGraphTransferable(mxGraphComponent graphComponent, Object[] cells, ImageIcon icon) {
        mxGraph graph = graphComponent.getGraph();
        mxPoint tr = graph.getView().getTranslate();
        double scale = graph.getView().getScale();
        mxRectangle bounds = graph.getPaintBounds(cells);
        bounds.setX(bounds.getX() / scale - tr.getX());
        bounds.setY(bounds.getY() / scale - tr.getY());
        bounds.setWidth(bounds.getWidth() / scale);
        bounds.setHeight(bounds.getHeight() / scale);
        return this.createGraphTransferable(graphComponent, cells, bounds, icon);
    }

    public mxGraphTransferable createGraphTransferable(mxGraphComponent graphComponent, Object[] cells, mxRectangle bounds, ImageIcon icon) {
        return new mxGraphTransferable(graphComponent.getGraph().cloneCells(cells), bounds, icon);
    }

    public ImageIcon createTransferableImage(mxGraphComponent graphComponent, Object[] cells) {
        ImageIcon icon = null;
        Color bg = this.transferImageBackground != null ? this.transferImageBackground : graphComponent.getBackground();
        BufferedImage img = mxCellRenderer.createBufferedImage(graphComponent.getGraph(), cells, 1.0, bg, graphComponent.isAntiAlias(), null, graphComponent.getCanvas());
        if (img != null) {
            icon = new ImageIcon(img);
        }
        return icon;
    }

    @Override
    public void exportDone(JComponent c, Transferable data, int action) {
        this.initialImportCount = 1;
        if (c instanceof mxGraphComponent && data instanceof mxGraphTransferable) {
            boolean isLocalDrop;
            boolean bl = isLocalDrop = this.location != null;
            if (action == 2 && !isLocalDrop) {
                this.removeCells((mxGraphComponent)c, this.originalCells);
                this.initialImportCount = 0;
            }
        }
        this.originalCells = null;
        this.location = null;
        this.offset = null;
    }

    protected void removeCells(mxGraphComponent graphComponent, Object[] cells) {
        graphComponent.getGraph().removeCells(cells);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        boolean result = false;
        if (this.isLocalDrag()) {
            result = true;
        } else {
            try {
                mxGraphTransferable gt;
                mxGraphComponent graphComponent;
                this.updateImportCount(t);
                if (c instanceof mxGraphComponent && (graphComponent = (mxGraphComponent)c).isEnabled() && t.isDataFlavorSupported(mxGraphTransferable.dataFlavor) && (gt = (mxGraphTransferable)t.getTransferData(mxGraphTransferable.dataFlavor)).getCells() != null) {
                    result = this.importGraphTransferable(graphComponent, gt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    protected void updateImportCount(Transferable t) {
        this.importCount = this.lastImported != t ? this.initialImportCount : ++this.importCount;
        this.lastImported = t;
    }

    protected boolean importGraphTransferable(mxGraphComponent graphComponent, mxGraphTransferable gt) {
        boolean result = false;
        try {
            mxGraph graph = graphComponent.getGraph();
            double scale = graph.getView().getScale();
            mxRectangle bounds = gt.getBounds();
            double dx = 0.0;
            double dy = 0.0;
            if (this.location != null && bounds != null) {
                mxPoint translate = graph.getView().getTranslate();
                dx = this.location.getX() - (bounds.getX() + translate.getX()) * scale;
                dy = this.location.getY() - (bounds.getY() + translate.getY()) * scale;
                dx = graph.snap(dx / scale);
                dy = graph.snap(dy / scale);
            } else {
                int gs = graph.getGridSize();
                dx = this.importCount * gs;
                dy = this.importCount * gs;
            }
            if (this.offset != null) {
                dx += (double)this.offset.x;
                dy += (double)this.offset.y;
            }
            this.importCells(graphComponent, gt, dx, dy);
            this.location = null;
            this.offset = null;
            result = true;
            graphComponent.requestFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object getDropTarget(mxGraphComponent graphComponent, mxGraphTransferable gt) {
        Object[] cells = gt.getCells();
        Object target = null;
        if (this.location != null) {
            target = graphComponent.getGraph().getDropTarget(cells, this.location, graphComponent.getCellAt(this.location.x, this.location.y));
            if (cells.length > 0 && graphComponent.getGraph().getModel().getParent(cells[0]) == target) {
                target = null;
            }
        }
        return target;
    }

    protected Object[] importCells(mxGraphComponent graphComponent, mxGraphTransferable gt, double dx, double dy) {
        Object target = this.getDropTarget(graphComponent, gt);
        mxGraph graph = graphComponent.getGraph();
        Object[] cells = gt.getCells();
        cells = graphComponent.getImportableCells(cells);
        if (graph.isSplitEnabled() && graph.isSplitTarget(target, cells)) {
            graph.splitEdge(target, cells, dx, dy);
        } else {
            cells = graphComponent.importCells(cells, dx, dy, target, this.location);
            graph.setSelectionCells(cells);
        }
        return cells;
    }
}

