/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class mxPanningHandler
extends mxMouseAdapter {
    private static final long serialVersionUID = 7969814728058376339L;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected transient Point start;

    public mxPanningHandler(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.getGraphControl().addMouseListener(this);
        graphComponent.getGraphControl().addMouseMotionListener(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEnabled() && !e.isConsumed() && this.graphComponent.isPanningEvent(e) && !e.isPopupTrigger()) {
            this.start = e.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && this.start != null) {
            int dx = e.getX() - this.start.x;
            int dy = e.getY() - this.start.y;
            Rectangle r = this.graphComponent.getViewport().getViewRect();
            int right = r.x + (dx > 0 ? 0 : r.width) - dx;
            int bottom = r.y + (dy > 0 ? 0 : r.height) - dy;
            this.graphComponent.getGraphControl().scrollRectToVisible(new Rectangle(right, bottom, 0, 0));
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int dy;
        int dx;
        if (!e.isConsumed() && this.start != null && this.graphComponent.isSignificant(dx = Math.abs(this.start.x - e.getX()), dy = Math.abs(this.start.y - e.getY()))) {
            e.consume();
        }
        this.start = null;
    }

    public boolean isActive() {
        return this.start != null;
    }
}

