/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.cal.app.transferbill.BillTransferService;
import com.kingdee.eas.scm.common.ISCMBizChainParams;
import com.kingdee.eas.scm.common.SCMBizChainParamsFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.util.CalBillHelper;
import org.apache.log4j.Logger;

public class AutoCreateCalBillProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 7609882146098754063L;
    private Logger logger = Logger.getLogger(AutoCreateCalBillProcessor.class);

    public AutoCreateCalBillProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public AutoCreateCalBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public AutoCreateCalBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (null == collection) {
            return;
        }
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            return;
        }
        ISCMBizChainParams iSCMBizChainParams = SCMBizChainParamsFactory.getLocalInstance((Context)this.ctx);
        boolean isStartUsed = iSCMBizChainParams.isStartUsed(this.bosType.toString(), this.batchAction.getBizAction(), "AutoCreateCalBillProcessor");
        if (!isStartUsed) {
            return;
        }
        try {
            BillTransferService service = new BillTransferService();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                this.autoCreateCalBill(collection.getObject(i), service);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void autoCreateCalBill(IObjectValue model, BillTransferService service) throws BOSException, EASBizException {
        int period;
        int year;
        String sourceBillTypeid;
        String storageOrgUnitid;
        InvBillBaseInfo billInfo = (InvBillBaseInfo)model;
        String billId = billInfo.getId().toString();
        int updateCount = service.createBill(this.ctx, billId, storageOrgUnitid = billInfo.getStorageOrgUnit().getId().toString(), sourceBillTypeid = billInfo.getBillType().getId().toString(), year = billInfo.getYear(), period = billInfo.getPeriod());
        if (updateCount > 0) {
            CalBillHelper.setIsGenCalFlag((Context)this.ctx, (IObjectValue)model, (int)1);
        }
    }
}

