/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;

public class CalculateProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 6135538299844530985L;

    public CalculateProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public CalculateProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public CalculateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!this.isCalculateAction()) {
            return;
        }
        IObjectCollection objCollection = batchResults.getObjCollection();
        ICalculateFacade iCalculateFacade = CalculateFacadeFactory.getLocalInstance((Context)this.ctx);
        int size = objCollection.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)objCollection.getObject(i);
            if (this.isJumpOrg(invBillBaseInfo.getBizType()) && invBillBaseInfo instanceof MaterialReqBillInfo) continue;
            iCalculateFacade.calculate((CoreBillBaseInfo)invBillBaseInfo);
        }
    }

    private boolean isCalculateAction() {
        return BatchActionEnum.AUDIT.equals((Object)this.batchAction) || BatchActionEnum.UNAUDIT.equals((Object)this.batchAction);
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }
}

