/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.im.inv.IInvCreateVirtualBillFacade;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.IVirtualBillFacade;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCreateVirtualBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.VirtualBillFacadeFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class CreateVirtualBillProcessor
extends AbstractBusinessProcessor {
    public CreateVirtualBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public CreateVirtualBillProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public CreateVirtualBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        IVirtualBillFacade iv = VirtualBillFacadeFactory.getLocalInstance((Context)this.ctx);
        IInvCreateVirtualBillFacade iic = InvCreateVirtualBillFacadeFactory.getLocalInstance((Context)this.ctx);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            ObjectUuidPK pk = new ObjectUuidPK(aInvBillBaseInfo.getId().toString());
            if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                if (aInvBillBaseInfo.getBillType().equals((Object)"50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                    iic.createVirtualBill((IObjectValue)aInvBillBaseInfo);
                    continue;
                }
                if (!aInvBillBaseInfo.getBillType().equals((Object)"50957179-0105-1000-e000-015bc0a812fd463ED552")) continue;
                boolean flag = iv.createVirtualBill((IObjectValue)aInvBillBaseInfo);
                SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
                if (saleIssueBillInfo.getEntry().get(0).isIsSquareBalance()) {
                    return;
                }
                if (flag) continue;
                iic.createVirtualBill((IObjectValue)aInvBillBaseInfo);
                continue;
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) continue;
            this.unAuditVirtualBill(this.ctx, (IObjectPK)pk, aInvBillBaseInfo);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    protected void unAuditVirtualBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        IManualWriteOffFacade iManualWriteOffFacade;
        String[] strIDs;
        if (!(aInvBillBaseInfo instanceof SaleIssueBillInfo) && !(aInvBillBaseInfo instanceof PurInWarehsBillInfo)) {
            return;
        }
        Vector vecPurVisualBill = (Vector)aInvBillBaseInfo.get("purInWarehsVirtualBill");
        Vector vecSaleVisualBill = (Vector)aInvBillBaseInfo.get("purSaleIssueVirtualBill");
        if (vecSaleVisualBill.size() > 0) {
            strIDs = new String[vecSaleVisualBill.size()];
            ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
            iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
            for (int j = 0; j < vecSaleVisualBill.size(); ++j) {
                strIDs[j] = (String)vecSaleVisualBill.get(j);
                SaleIssueBillInfo aSaleIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(strIDs[j]));
                this.updateUnAuditStatus(ctx, (IObjectValue)aSaleIssueBillInfo);
                CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aInvBillBaseInfo);
                iManualWriteOffFacade.inverseWriteOff(new String[]{strIDs[j]});
                iSaleIssueBill.delete((IObjectPK)new ObjectUuidPK(strIDs[j]));
            }
        }
        if (vecPurVisualBill.size() > 0) {
            strIDs = new String[vecPurVisualBill.size()];
            IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
            iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < vecPurVisualBill.size(); ++i) {
                strIDs[i] = (String)vecPurVisualBill.get(i);
                PurInWarehsBillInfo aPurInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                this.updateUnAuditStatus(ctx, (IObjectValue)aPurInWarehsBillInfo);
                CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aInvBillBaseInfo);
                iManualWriteOffFacade.inverseWriteOff(new String[]{strIDs[i]});
                iPurInWarehsBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
    }

    public void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setTimestamp(1, null);
            preStmt.setString(2, null);
            preStmt.setInt(3, 1);
            preStmt.setString(4, aSCMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    public String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }
}

