/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMCommonDataLoadorProcessor;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InvCommonDataLoaderProcessor
extends SCMCommonDataLoadorProcessor {
    private static final long serialVersionUID = 1L;

    public InvCommonDataLoaderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public InvCommonDataLoaderProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        HashSet<String> transactionTypeIds = new HashSet<String>();
        this.orgIds = new String[collection.size()];
        HashSet<Date> bizDates = new HashSet<Date>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            if (aInvBillBaseInfo.getTransactionType() != null) {
                transactionTypeIds.add(aInvBillBaseInfo.getTransactionType().getId().toString());
            }
            if (aInvBillBaseInfo.getStorageOrgUnit() != null) {
                this.orgIds[i] = aInvBillBaseInfo.getStorageOrgUnit().getId().toString();
            }
            bizDates.add(aInvBillBaseInfo.getBizDate());
        }
        Map matInventoryMap = this.getMaterialInventoryCollection(this.getMaterialIDs(collection), this.orgIds);
        this.commonData.getFetchData().addMapMaterialInventory(matInventoryMap);
        HashMap transactiontypes = InvAppUtils.putTransType((Context)this.ctx, transactionTypeIds);
        this.commonData.setTransactionTypes((Map)transactiontypes);
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            if (aInvBillBaseInfo.getTransactionType() == null) continue;
            aInvBillBaseInfo.setTransactionType((TransactionTypeInfo)transactiontypes.get(aInvBillBaseInfo.getTransactionType().getId().toString()));
        }
        super.doProcessing(batchResults);
    }

    protected Integer getBillTypeGroup() {
        return new Integer(12);
    }

    protected Integer getOrgType() {
        return new Integer(4);
    }

    protected String[] getOrgIds() {
        return super.getOrgIds();
    }

    protected String getEntryName() {
        return "entry";
    }

    protected int getSystemName() {
        return 2;
    }
}

