/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvDefaultValueProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = 7942042880896963885L;
    private static final String[] HEAD_NUMBER_FIELDS = new String[]{"totalQty", "totalAmount", "totalStandardCost", "totalActualCost", "totalLocalAmount"};
    private static final String[] ENTRY_NUMBER_FIELDS = new String[]{"receiptQty", "imputedCost", "drewQty", "receiveAmount", "drewBaseQty", "orderPrice", "taxPrice", "actualPrice", "totalMoveQty", "purInvoiceAmount", "saleInvoiceAmount", "totalAccountPayable", "totalAccountReceivable", "localPrice", "localTax", "localAmount", "qualifiedQty", "unqualifiedQty", "concessiveRecBaseQty", "baseQty", "taxRate", "totalinwarehsqty", "faCardQty", "qty", "assistQty", "reverseQty", "returnsQty", "unitStandardCost", "standardCost", "unitActualCost", "actualCost", "reverseBaseQty", "returnBaseQty", "assCoefficient", "associateQty", "price", "amount", "concessiverecqty"};
    private static final String[] HEAD_BOOLEAN_FIELDS = new String[]{"isReversed", "fiVouchered", "isInitBill"};
    private static String[] ENTRY_BOOLEAN_FIELDS = new String[]{"isPresent"};

    protected List<String> getEntryBooleanFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ENTRY_BOOLEAN_FIELDS) {
            list.add(s);
        }
        return list;
    }

    protected List<String> getHeadBooleanFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : HEAD_BOOLEAN_FIELDS) {
            list.add(s);
        }
        return list;
    }

    protected List<String> getEntryNumberFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ENTRY_NUMBER_FIELDS) {
            list.add(s);
        }
        return list;
    }

    protected List<String> getHeadNumberFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : HEAD_NUMBER_FIELDS) {
            list.add(s);
        }
        return list;
    }

    public InvDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public InvDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public InvDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null || batchResults.getObjCollection().size() == 0) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                InvBillBaseInfo invBillInfo = (InvBillBaseInfo)collection.getObject(i);
                this.setNullToZero(invBillInfo);
                this.setNullToFalse(invBillInfo);
                this.setEmptyToNullForLot(invBillInfo);
                this.updateEntryFields((IObjectValue)invBillInfo);
                this.setBillDateFields(invBillInfo);
                this.setEntryCompanyInfo(invBillInfo);
                this.setEntrySeq(invBillInfo);
            }
            if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
                this.doProcess4Save(batchResults);
            } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
                this.doProcess4Submit(batchResults);
            }
        } else if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            this.doProcess4Audit(batchResults);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            this.doProcess4UnAudit(batchResults);
        }
    }

    private void setEntryCompanyInfo(InvBillBaseInfo invBillInfo) throws EASBizException, BOSException {
        StorageOrgUnitInfo sou = invBillInfo.getStorageOrgUnit();
        if (sou == null) {
            return;
        }
        IObjectCollection entrys = invBillInfo.getEntries();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            if (entry.getCompanyOrgUnit() != null) continue;
            entry.setCompanyOrgUnit(this.getSouDelegateCou(sou));
        }
    }

    protected CompanyOrgUnitInfo getSouDelegateCou(StorageOrgUnitInfo info) throws BOSException, EASBizException {
        if (null == info || info.getId() == null) {
            return null;
        }
        IDataCache dataCache = this.getDataCacheFromContext();
        if (dataCache.contain(info.getId().toString(), DataTypeEnum.MAINORGUNIT_2_COMPANY)) {
            return (CompanyOrgUnitInfo)dataCache.get(info.getId().toString(), DataTypeEnum.MAINORGUNIT_2_COMPANY);
        }
        CompanyOrgUnitInfo cou = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection orgCol = iOrgUnitRelation.getToUnit(info.getId().toString(), 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            cou = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        dataCache.put(info.getId().toString(), cou, DataTypeEnum.MAINORGUNIT_2_COMPANY);
        return cou;
    }

    private void setEntrySeq(InvBillBaseInfo info) {
        IObjectCollection entrys = info.getEntries();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            entry.setSeq(i + 1);
        }
    }

    protected void doProcess4Audit(BatchActionResults batchResults) throws EASBizException, BOSException {
    }

    protected void doProcess4UnAudit(BatchActionResults batchResults) throws EASBizException, BOSException {
    }

    protected void setBillDateFields(InvBillBaseInfo invBillInfo) {
        if (invBillInfo.getBizDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(invBillInfo.getBizDate());
            if (invBillInfo.getYear() == 0) {
                invBillInfo.setYear(cal.get(1));
            }
            invBillInfo.setMonth(cal.get(1) * 100 + (cal.get(2) + 1));
            invBillInfo.setDay(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        }
    }

    protected void setNullToZero(InvBillBaseInfo invBillInfo) {
        List<String> fields = this.getHeadNumberFields();
        if (null != fields) {
            for (String f : fields) {
                if (invBillInfo.getBigDecimal(f) != null) continue;
                invBillInfo.setBigDecimal(f, BigDecimal.ZERO);
            }
        }
        if (null != (fields = this.getEntryNumberFields())) {
            IObjectCollection entryCol = invBillInfo.getEntries();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entryCol.getObject(i);
                for (String f : fields) {
                    if (entry.getBigDecimal(f) != null) continue;
                    entry.setBigDecimal(f, BigDecimal.ZERO);
                }
            }
        }
    }

    protected void setNullToFalse(InvBillBaseInfo invBillInfo) {
        List<String> fields = this.getHeadBooleanFields();
        if (null != fields) {
            for (String f : fields) {
                if (invBillInfo.get(f) != null) continue;
                invBillInfo.setBoolean(f, false);
            }
        }
        if (null != (fields = this.getEntryBooleanFields())) {
            IObjectCollection entryCol = invBillInfo.getEntries();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entryCol.getObject(i);
                for (String f : fields) {
                    if (entry.get(f) != null) continue;
                    entry.setBoolean(f, false);
                }
            }
        }
    }

    protected void setEmptyToNullForLot(InvBillBaseInfo invBillInfo) {
        IObjectCollection entryCol = invBillInfo.getEntries();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (!StringUtils.isEmpty((String)entry.getLot())) continue;
            entry.setLot(null);
        }
    }

    protected void updateEntryFields(IObjectValue model) throws BOSException, EASBizException {
        if (this.isNeedSynEntryFields(model)) {
            InvBillBaseInfo invBillInfo = (InvBillBaseInfo)model;
            IObjectCollection entryCol = invBillInfo.getEntries();
            InvBillBaseEntryInfo entryInfo = null;
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
                if (entryInfo != null && invBillInfo.getBizDate() != null) {
                    entryInfo.setDate("bizDate", invBillInfo.getBizDate());
                }
                if (entryInfo == null || entryInfo.getStorageOrgUnit() != null || invBillInfo.getStorageOrgUnit() == null) continue;
                entryInfo.setStorageOrgUnit(invBillInfo.getStorageOrgUnit());
            }
        }
    }

    protected boolean isNeedSynEntryFields(IObjectValue model) {
        String billBosType = model.getBOSType().toString();
        return SCMConstant.BOSTYPE_SALEISSUE.equals(billBosType) || SCMConstant.BOSTYPE_PURINWAREHS.equals(billBosType) || "E3DAFF63".equals(billBosType) || "71D272F1".equals(billBosType) || "FA1292B4".equals(billBosType) || "500AB75E".equals(billBosType) || "A4D04D23".equals(billBosType) || "A4D04D24".equals(billBosType) || "8FA62986".equals(billBosType) || "A4D04D25".equals(billBosType) || SCMConstant.BOSTYPE_STOCKTRANSFER.equals(billBosType);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    protected BillTypeInfo getBillType() {
        return null;
    }

    private void synchronizationBillPrice(Context ctx, boolean isAddNew, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        String sourceTableBill = InvCommonUtils.getBillTableName((String)SCMUtils.getBillTypeNOFormBillTypeID((BillTypeInfo)invBillBaseInfo.getBillType()));
        String sourceTableEntry = InvCommonUtils.getBillEntryTableName((String)SCMUtils.getBillTypeNOFormBillTypeID((BillTypeInfo)invBillBaseInfo.getBillType()));
        String sourceid = invBillBaseInfo.getSourceBillId();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (sourceid == null) {
                StringBuffer sqlid = new StringBuffer();
                sqlid.append("select FSourceBillId from ");
                sqlid.append(sourceTableBill);
                sqlid.append(" WHERE fid='").append(invBillBaseInfo.getId()).append("'");
                JdbcRowSet rsid = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sqlid.toString());
                if (rsid.next()) {
                    sourceid = rsid.getString("FSourceBillId");
                }
            }
            if (sourceid == null) {
                throw new InvBizException(InvBizException.INV_NOSRCBILL);
            }
            JdbcRowSet rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append(" select ENTRY.FID,Entry.FUnitActualCost,Entry.fseq,CURRENCY.FPrecision as fcurrencyPerision from ");
            sql.append(sourceTableEntry).append(" AS Entry");
            sql.append(" INNER JOIN T_ORG_Company AS COMPANY");
            sql.append(" ON Entry.FCompanyOrgUnitID = COMPANY.FID");
            sql.append(" INNER JOIN T_BD_Currency AS CURRENCY");
            sql.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
            sql.append(" WHERE Entry.fparentid='").append(sourceid).append("'");
            sql.append(" order by Entry.fseq");
            rs = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            IObjectCollection coll = (IObjectCollection)invBillBaseInfo.get("entry");
            while (rs.next()) {
                if (rs.getBigDecimal("FUnitActualCost") == null) continue;
                for (int j = 0; j < coll.size(); ++j) {
                    BigDecimal tax;
                    BigDecimal exchangeRate;
                    BigDecimal localTax;
                    PurInWarehsEntryInfo info;
                    InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)coll.getObject(j);
                    if (!rs.getString("FID").equals(aInvBillBaseEntryInfo.getSourceBillEntryId()) || rs.getBigDecimal("FUnitActualCost").compareTo(aInvBillBaseEntryInfo.getUnitActualCost()) == 0) continue;
                    int currencyPerision = rs.getInt("fcurrencyPerision");
                    BigDecimal diffAmt = rs.getBigDecimal("FUnitActualCost").multiply(aInvBillBaseEntryInfo.getQty()).setScale(currencyPerision, 4);
                    diffAmt = aInvBillBaseEntryInfo.getActualCost().abs().subtract(diffAmt.abs());
                    aInvBillBaseEntryInfo.setUnitActualCost(rs.getBigDecimal("FUnitActualCost"));
                    aInvBillBaseEntryInfo.setActualCost(rs.getBigDecimal("FUnitActualCost").multiply(aInvBillBaseEntryInfo.getQty()).setScale(currencyPerision, 4));
                    if (aInvBillBaseEntryInfo instanceof PurInWarehsEntryInfo) {
                        info = (PurInWarehsEntryInfo)aInvBillBaseEntryInfo;
                        info.setWrittenOffAmount(SysConstant.BIGZERO);
                        info.setUnWriteOffAmount(SysConstant.BIGZERO);
                        if (!info.isIsPresent()) {
                            info.setUnWriteOffAmount(info.getPurchaseCost());
                        }
                        localTax = info.getLocalAmount().subtract(info.getActualCost());
                        localTax = localTax.setScale(currencyPerision, 4);
                        info.setLocalTax(localTax);
                        exchangeRate = ((PurInWarehsBillInfo)invBillBaseInfo).getExchangeRate();
                        if (exchangeRate == null) {
                            exchangeRate = new BigDecimal("1.00");
                        }
                        tax = localTax.divide(exchangeRate, info.getTax().scale(), 4);
                        info.setTax(tax);
                    }
                    if (aInvBillBaseEntryInfo instanceof SaleIssueEntryInfo) {
                        info = (SaleIssueEntryInfo)aInvBillBaseEntryInfo;
                        info.setWrittenOffAmount(SysConstant.BIGZERO);
                        if (!info.isIsPresent()) {
                            info.setUnWriteOffAmount(aInvBillBaseEntryInfo.getActualCost());
                        } else {
                            info.setUnWriteOffAmount(SysConstant.BIGZERO);
                        }
                        localTax = info.getLocalAmount().subtract(info.getActualCost());
                        localTax = localTax.setScale(currencyPerision, 4);
                        info.setLocalTax(localTax);
                        exchangeRate = ((SaleIssueBillInfo)invBillBaseInfo).getExchangeRate();
                        if (exchangeRate == null) {
                            exchangeRate = SCMConstant.BIGDECIMAL_ONE;
                        }
                        tax = localTax.divide(exchangeRate, info.getTax().scale(), 4);
                        info.setTax(tax);
                    }
                    if (invBillBaseInfo.getTotalActualCost() == null) {
                        invBillBaseInfo.setTotalActualCost(SysConstant.BIGZERO);
                    }
                    if (invBillBaseInfo.getTotalStandardCost() == null) {
                        invBillBaseInfo.setTotalStandardCost(SysConstant.BIGZERO);
                    }
                    if (invBillBaseInfo.getTotalAmount() == null) {
                        invBillBaseInfo.setTotalAmount(SysConstant.BIGZERO);
                    }
                    invBillBaseInfo.setTotalActualCost(invBillBaseInfo.getTotalActualCost().subtract(diffAmt.multiply(aInvBillBaseEntryInfo.getQty().abs().divide(aInvBillBaseEntryInfo.getQty(), 0, 4))));
                    invBillBaseInfo.setTotalAmount(invBillBaseInfo.getTotalActualCost().add(invBillBaseInfo.getTotalStandardCost()));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected boolean isNeedSourceBillForIndustry() {
        return true;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        IObjectCollection iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        ArrayList<SelectorItemInfo> selectorList = batchResults.getAddedSelector();
        if (selectorList == null) {
            SelectorItemCollection selectors = this.getSelectors();
            selectorList = new ArrayList<SelectorItemInfo>(selectors.size());
            int size = selectors.size();
            for (int i = 0; i < size; ++i) {
                selectorList.add(selectors.get(i));
            }
        }
        batchResults.setAddedSelector((List)selectorList);
        String action = "";
        if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
            action = "save";
        } else if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            action = "submit";
        } else if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            action = "audit";
        } else if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            action = "unaudit";
        }
        IObjectCollection collection = batchResults.getObjCollection();
        BillTypeInfo billTypeInfo = this.getBillType();
        if (collection == null && billTypeInfo != null) {
            BusinessProcessorHelper.batchLoadBizObjectsManual((Context)this.ctx, (BOSObjectType)this.bosType, (String)action, (String)billTypeInfo.getId().toString(), (BatchActionResults)batchResults);
            collection = batchResults.getObjCollection();
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        return super.check(batchResults);
    }

    protected SelectorItemCollection getSelectors() {
        return new SelectorItemCollection();
    }

    protected void doProcess4Save(BatchActionResults batchResults) throws EASBizException, BOSException {
    }

    protected void doProcess4Submit(BatchActionResults batchResults) throws EASBizException, BOSException {
        if (null == batchResults || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        IObjectValue obj = collection.getObject(0);
        boolean isAddNew = this.isAddNew(this.ctx, obj);
        String[] mainOrgIds = new String[collection.size()];
        BigDecimal totalStandardCost = null;
        BigDecimal totalActualCost = null;
        for (int i = 0; i < collection.size(); ++i) {
            totalStandardCost = SysConstant.BIGZERO;
            totalActualCost = SysConstant.BIGZERO;
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo info = (InvBillBaseInfo)vo;
            if (this.isNeedSourceBillForIndustry() && info.isIsReversed() && !(info instanceof PurInWarehsBillInfo) && info.getSourceBillType() != null) {
                this.synchronizationBillPrice(this.ctx, isAddNew, info);
            }
            AbstractObjectCollection entrys = (AbstractObjectCollection)info.get(this.getEntryName());
            HashSet<String> materialIds = new HashSet<String>();
            for (int j = 0; j < entrys.size(); ++j) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
                if (this.isEntryBlank(entry)) {
                    entrys.removeObject(j);
                    --j;
                    continue;
                }
                if (info.getSourceBillType() != null && entry.getSourceBillType() == null) {
                    entry.setSourceBillType(info.getSourceBillType());
                }
                if (entry.getMaterial() != null) {
                    materialIds.add(entry.getMaterial().getId().toString());
                }
                totalStandardCost = totalStandardCost.add(entry.getStandardCost() == null ? SysConstant.BIGZERO : entry.getStandardCost());
                totalActualCost = totalActualCost.add(entry.getActualCost() == null ? SysConstant.BIGZERO : entry.getActualCost());
            }
            Map<String, MeasureUnitInfo> assistUnitMap = this.getMateoralAssitUnitMap(materialIds);
            info.setTotalStandardCost(totalStandardCost);
            info.setTotalActualCost(totalActualCost);
            mainOrgIds[i] = ((OrgUnitInfo)info.get(info.getBizOrgPropertyName())).getId().toString();
            InvBillBaseEntryInfo entryInfo = null;
            int n = entrys.size();
            for (int j = 0; j < n; ++j) {
                entryInfo = (InvBillBaseEntryInfo)entrys.getObject(j);
                if (info.isIsReversed() ^ InvServerUtils.isReturnRIType((Context)this.ctx, (TransactionTypeInfo)info.getTransactionType())) {
                    entryInfo.setAssociateQty(entryInfo.getBaseQty());
                } else {
                    entryInfo.setAssociateQty(entryInfo.getBaseQty().abs());
                }
                MaterialInfo materialInfo = null;
                MeasureUnitInfo assistUnit = null;
                materialInfo = entryInfo.getMaterial();
                if (materialInfo == null) continue;
                assistUnit = assistUnitMap.get(materialInfo.getId().toString());
                if (assistUnit != null) {
                    entryInfo.setAssistUnit(assistUnit);
                    if (entryInfo.getAssistQty() == null) {
                        entryInfo.setAssistQty(BigDecimal.ZERO);
                    }
                } else {
                    entryInfo.setAssistUnit(null);
                    entryInfo.setAssistQty(BigDecimal.ZERO);
                }
                entryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                entryInfo.setUnVmiSettleBaseQty(entryInfo.getBaseQty());
                entryInfo.setTotalVmiSettleBaseQty(SysConstant.BIGZERO);
            }
        }
    }

    protected boolean isEntryBlank(InvBillBaseEntryInfo entry) {
        return entry.getMaterial() == null;
    }

    protected String getEntryName() {
        return "entry";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private Map<String, MeasureUnitInfo> getMateoralAssitUnitMap(Set<String> materialIds) throws BOSException {
        HashMap<String, MeasureUnitInfo> assistUnitMap = new HashMap<String, MeasureUnitInfo>();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("assistUnit.id");
        selectors.add("assistUnit.number");
        selectors.add("assistUnit.name");
        selectors.add("assistUnit.coefficient");
        selectors.add("assistUnit.isBaseUnit");
        selectors.add("assistUnit.isDisabled");
        selectors.add("assistUnit.qtyPrecision");
        selectors.add("assistUnit.CU.id");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialIds, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(selectors);
        MaterialCollection materials = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialCollection(view);
        if (materials != null) {
            for (int j = 0; j < materials.size(); ++j) {
                MaterialInfo materialInfo = materials.get(j);
                if (materialInfo.getAssistUnit() == null) continue;
                assistUnitMap.put(materialInfo.getId().toString(), materialInfo.getAssistUnit());
            }
        }
        return assistUnitMap;
    }
}

