/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LockBillProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -7278875033438946302L;

    public LockBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public LockBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public LockBillProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        assert (batchResults != null);
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol == null || objCol.size() == 0) {
            return;
        }
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction) && !BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseInfo info = (InvBillBaseInfo)objCol.getObject(i);
            this.lockBill(info);
        }
    }

    private void lockBill(InvBillBaseInfo invInfo) throws EASBizException, BOSException {
        String srcTempTable = null;
        String corTempTable = null;
        try {
            String next;
            Iterator ite;
            Set set;
            if (invInfo == null || invInfo.getBillType() == null || "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(invInfo.getBillType().getId().toString())) {
                return;
            }
            TransactionTypeInfo transType = invInfo.getTransactionType();
            String billTypeId = invInfo.getBillType().getId().toString();
            if (!(transType != null || "XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeId) || "50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeId) || "CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(billTypeId) || "CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(billTypeId))) {
                throw new InvBizException(InvBizException.TRANSACTIONTYPE_CANNOTNULL);
            }
            Map coreBillType = null;
            coreBillType = this.getCoreBillType(this.ctx, invInfo);
            Map headBillTypeMap = new HashMap();
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillType = BillTypeUtils.getBillEntryTableName((Context)this.ctx, coreBillType);
                headBillTypeMap = BillTypeUtils.getBillHeadTableName((Context)this.ctx, (Map)coreBillType);
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)this.ctx, (String)invInfo.getBillType().getId().toString());
            ArrayList<String> sqlUpdate = new ArrayList<String>();
            if (billTable != null && billTable.length() > 0) {
                sqlUpdate.add(" UPDATE " + billTable + " SET FID = FID  WHERE FID = '" + invInfo.getId().toString() + "'");
            }
            IObjectCollection entrys = this.getEntryCollection(invInfo);
            String tmp = null;
            StringBuffer createSql = new StringBuffer();
            HashSet<String> srcEntryId = new HashSet<String>(entrys.size());
            String insql = null;
            for (int i = 0; i < entrys.size(); ++i) {
                if (((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId() == null) continue;
                tmp = ((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId().toString();
                srcEntryId.add(tmp);
            }
            if (srcEntryId.size() > 800) {
                createSql.append("create table temptable ( FSrcBillEntryID varchar(44) ); ");
                srcTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSql.toString());
                KsqlUtil.insertTempTable((Context)this.ctx, (String)srcTempTable, (String)"FSrcBillEntryID", srcEntryId);
                insql = "select FSrcBillEntryID from " + srcTempTable;
            } else if (srcEntryId.size() > 0) {
                insql = InvServerUtils.getSqlIdsStrForColl(srcEntryId);
            }
            BillTypeInfo sourceBillType = ((InvBillBaseEntryInfo)entrys.getObject(0)).getSourceBillType();
            if (sourceBillType != null && sourceBillType.getId() != null && srcEntryId.size() > 0 && (tmp = BillTypeUtils.getBillEntryTableName((Context)this.ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0) {
                sqlUpdate.add(" UPDATE " + tmp + " SET FID = FID WHERE FID IN ( " + insql + ")");
            }
            HashSet<String> srcId = new HashSet<String>();
            for (int i = 0; i < entrys.size(); ++i) {
                if (((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillId() == null) continue;
                tmp = ((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillId().toString();
                srcId.add(tmp);
            }
            if (srcId.size() > 800) {
                createSql.setLength(0);
                createSql.append("create table temptable ( FSrcBillID varchar(44) ); ");
                srcTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSql.toString());
                KsqlUtil.insertTempTable((Context)this.ctx, (String)srcTempTable, (String)"FSrcBillID", srcId);
                insql = "select FSrcBillID from " + srcTempTable;
            } else if (srcId.size() > 0) {
                insql = InvServerUtils.getSqlIdsStrForColl(srcId);
            }
            if (sourceBillType != null && sourceBillType.getId() != null && srcId.size() > 0 && (tmp = BillTypeUtils.getBillHeadTableName((Context)this.ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0) {
                sqlUpdate.add(" UPDATE " + tmp + " SET FID = FID WHERE FID IN ( " + insql + ")");
            }
            createSql.setLength(0);
            if (coreBillType != null && coreBillType.size() > 0) {
                Set corId = this.getCoreBillEntryId(this.ctx, invInfo, false);
                if (corId.size() > 800) {
                    createSql.append("create table temptable ( FcorBillID varchar(44) ); ");
                    corTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSql.toString());
                    KsqlUtil.insertTempTable((Context)this.ctx, (String)corTempTable, (String)"FcorBillID", (Set)corId);
                    insql = "select FcorBillID from " + corTempTable;
                } else if (corId.size() > 0) {
                    insql = InvServerUtils.getSqlIdsStrForColl((Collection)corId);
                }
                set = coreBillType.keySet();
                ite = set.iterator();
                next = null;
                while (ite.hasNext()) {
                    next = ((String)ite.next()).toString();
                    if (coreBillType.get(next) == null || corId.size() <= 0) continue;
                    sqlUpdate.add(" UPDATE " + (String)coreBillType.get(next) + " SET FID = FID WHERE FID IN (" + insql + ")");
                }
            }
            if (headBillTypeMap != null && headBillTypeMap.size() > 0) {
                Set corId = this.getCoreBillEntryId(this.ctx, invInfo, true);
                if (corId.size() > 800) {
                    createSql.setLength(0);
                    createSql.append("create table temptable ( FcorBillID varchar(44) ); ");
                    corTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSql.toString());
                    KsqlUtil.insertTempTable((Context)this.ctx, (String)corTempTable, (String)"FcorBillID", (Set)corId);
                    insql = "select FcorBillID from " + corTempTable;
                } else if (corId.size() > 0) {
                    insql = InvServerUtils.getSqlIdsStrForColl((Collection)corId);
                }
                set = headBillTypeMap.keySet();
                ite = set.iterator();
                next = null;
                while (ite.hasNext()) {
                    next = ((String)ite.next()).toString();
                    if (headBillTypeMap.get(next) == null || corId.size() <= 0) continue;
                    sqlUpdate.add(" UPDATE " + (String)headBillTypeMap.get(next) + " SET FID = FID WHERE FID IN (" + insql + ")");
                }
            }
            if (sqlUpdate.size() > 0) {
                String[] updSql = new String[sqlUpdate.size()];
                for (int i = 0; i < sqlUpdate.size(); ++i) {
                    updSql[i] = (String)sqlUpdate.get(i);
                }
                DBUtil.executeBatch((Context)this.ctx, (String[])updSql);
            }
            KsqlUtil.releaseTempTable((Context)this.ctx, (String)srcTempTable);
        }
        catch (EASBizException e1) {
            throw e1;
        }
        catch (BOSException e2) {
            throw e2;
        }
        finally {
            KsqlUtil.releaseTempTable((Context)this.ctx, srcTempTable);
            KsqlUtil.releaseTempTable((Context)this.ctx, corTempTable);
        }
        KsqlUtil.releaseTempTable((Context)this.ctx, corTempTable);
    }

    protected Map<String, String> getCoreBillType(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        if (null == info || info.getEntries() == null || info.getEntries().size() == 0) {
            return null;
        }
        IObjectCollection entryCol = info.getEntries();
        HashMap<String, String> coreBillTypeMap = new HashMap<String, String>(entryCol.size());
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            BillTypeInfo billTypeInfo = (BillTypeInfo)entryCol.getObject(i).get("coreBillType");
            if (null == billTypeInfo || billTypeInfo.getId() == null) continue;
            coreBillTypeMap.put(billTypeInfo.getId().toString(), billTypeInfo.getId().toString());
        }
        return coreBillTypeMap;
    }

    protected IObjectCollection getEntryCollection(InvBillBaseInfo aInvBillBaseInfo) {
        if (aInvBillBaseInfo == null) {
            return new InvBillBaseEntryCollection();
        }
        return aInvBillBaseInfo.getEntries();
    }

    protected Set getCoreBillEntryId(Context ctx, InvBillBaseInfo info, boolean isHead) throws EASBizException, BOSException {
        if (null == info) {
            return null;
        }
        if (info instanceof SaleIssueBillInfo) {
            return this.getCoreBillEntryId((SaleIssueBillInfo)info, isHead);
        }
        if (info instanceof PurInWarehsBillInfo) {
            return this.getCoreBillEntryId((PurInWarehsBillInfo)info, isHead);
        }
        if (info instanceof MaterialReqBillInfo) {
            return this.getCoreBillEntryId((MaterialReqBillInfo)info, isHead);
        }
        return new HashSet();
    }

    protected Set getCoreBillEntryId(SaleIssueBillInfo info, boolean isHead) {
        SaleIssueEntryCollection col = info.getEntry();
        HashSet<String> set = new HashSet<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            if (isHead) {
                if (col.get(i).getSaleOrder() == null) continue;
                set.add(col.get(i).getSaleOrder());
                continue;
            }
            if (col.get(i).getSaleOrderEntry() == null) continue;
            set.add(col.get(i).getSaleOrderEntry());
        }
        return set;
    }

    protected Set getCoreBillEntryId(PurInWarehsBillInfo info, boolean isHead) {
        PurInWarehsEntryCollection col = info.getEntry();
        HashSet<String> set = new HashSet<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            if (isHead) {
                if (col.get(i).getPurOrder() == null) continue;
                set.add(col.get(i).getPurOrder());
                continue;
            }
            if (col.get(i).getPurOrderEntry() == null) continue;
            set.add(col.get(i).getPurOrderEntry());
        }
        return set;
    }

    protected Set getCoreBillEntryId(MaterialReqBillInfo info, boolean isHead) {
        MaterialReqBillEntryCollection col = info.getEntry();
        HashSet<String> set = new HashSet<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            if (isHead) {
                if (col.get(i).getCoreOrderID() == null) continue;
                set.add(col.get(i).getCoreOrderID());
                continue;
            }
            if (col.get(i).getCoreOrderEntryID() == null) continue;
            set.add(col.get(i).getCoreOrderEntryID());
        }
        return set;
    }
}

