/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMExternalFacadeFactory;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBizChainParams;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBizChainParamsFactory;

public class MMExternalServiceProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 3014878725366555848L;

    public MMExternalServiceProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MMExternalServiceProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public MMExternalServiceProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BizActionEnum bizAction;
        ISCMBizChainParams iSCMBizChainParams = SCMBizChainParamsFactory.getLocalInstance((Context)this.ctx);
        boolean isStartUsed = iSCMBizChainParams.isStartUsed(this.bosType.toString(), this.batchAction.getBizAction(), "scm.im.MMExternalServiceProcessor");
        if (!isStartUsed) {
            return;
        }
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.AUDIT;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.UNAUDIT;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol.size() <= 0) {
            return;
        }
        IObjectValue model = objCol.getObject(0);
        String billType = ((SCMBillBaseInfo)model).getBillType().getId().toString();
        String[] ids = new String[objCol.size()];
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
            ids[i] = info.getId().toString();
        }
        this.doService(bizAction, billType, ids);
    }

    private void doService(BizActionEnum bizAction, String billType, String[] ids) throws EASBizException, BOSException {
        MMExternalFacadeFactory.getLocalInstance((Context)this.ctx).doService(bizAction.getValue(), billType, ids);
    }
}

