/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;

public class ReverseBillRelationProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -2709503142017652598L;

    public ReverseBillRelationProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public ReverseBillRelationProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public ReverseBillRelationProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null) {
            return;
        }
        ISCMBillBase iScmBillbase = (ISCMBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)this.bosType);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            String srcId;
            InvBillBaseInfo info = (InvBillBaseInfo)collection.getObject(i);
            if (!info.isIsReversed() || info.getId() != null && iScmBillbase.exists((IObjectPK)new ObjectUuidPK(info.getId()))) continue;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                batchResults.replaceNewId(info.getId().toString());
            }
            if (StringUtils.isEmpty((String)(srcId = info.getSourceBillId()))) continue;
            ObjectUuidPK srcPk = new ObjectUuidPK(srcId);
            String bosType = srcPk.getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)this.ctx, (String)srcId, (String)info.getId().toString(), (String)bosType, (String)bosType);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }
}

