/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.rewrite.IRewrite;
import com.kingdee.eas.scm.common.app.rewrite.RewriterFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;

public class RewriterProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 2115863253416850756L;

    public RewriterProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public RewriterProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public RewriterProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BizActionEnum bizActionEnum = null;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            bizActionEnum = BizActionEnum.AUDIT;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            bizActionEnum = BizActionEnum.UNAUDIT;
        } else {
            return;
        }
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IRewrite iRewrite;
            InvBillBaseInfo info = (InvBillBaseInfo)objCol.getObject(i);
            if (info == null || info.getEntries() == null || info.getEntries().size() == 0) continue;
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
            if (info.getBillType() == null || entryInfo == null) {
                return;
            }
            String billTypeId = info.getBillType().getId().toString();
            String tableName = BillTypeUtils.getBillEntryTableName((Context)this.ctx, (String)billTypeId);
            if (tableName != null && (tableName.equalsIgnoreCase("T_IM_MATERIALREQBILLENTRY") || tableName.equalsIgnoreCase("T_IM_PURINWAREHSENTRY")) && SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)tableName, (String)info.getId().toString())) {
                return;
            }
            if (!StringUtils.isEmpty((String)entryInfo.getCoreBillTypeId()) && null != (iRewrite = RewriterFactory.getRewriter((String)entryInfo.getCoreBillTypeId(), (String)billTypeId))) {
                iRewrite.rewrite((IObjectValue)info, bizActionEnum.getValue(), this.ctx);
            }
            if (entryInfo.getSourceBillType() == null || null == (iRewrite = RewriterFactory.getRewriter((String)entryInfo.getSourceBillType().getId().toString(), (String)billTypeId)) || entryInfo.getSourceBillType().getId().toString().equals(entryInfo.getCoreBillTypeId())) continue;
            iRewrite.rewrite((IObjectValue)info, bizActionEnum.getValue(), this.ctx);
        }
    }
}

