/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class SerialNumImportProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public SerialNumImportProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SerialNumImportProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SerialNumImportProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            this.importMaterialSN(this.ctx, aInvBillBaseInfo);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    protected void importMaterialSN(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        InvBillBaseEntryInfo aInvBillBaseEntryInfo;
        int i;
        if (aInvBillBaseInfo.get("ImportSN") == null) {
            return;
        }
        if (!(aInvBillBaseInfo instanceof SaleIssueBillInfo || aInvBillBaseInfo instanceof PurInWarehsBillInfo || aInvBillBaseInfo instanceof MoveIssueBillInfo || aInvBillBaseInfo instanceof MoveInWarehsBillInfo || aInvBillBaseInfo instanceof OtherInWarehsBillInfo || aInvBillBaseInfo instanceof OtherIssueBillInfo)) {
            return;
        }
        SerialNumberStatusEnum snstatus = null;
        Hashtable htSN = (Hashtable)aInvBillBaseInfo.get("ImportSN");
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        String strBillId = aInvBillBaseInfo.getId().toString();
        String strBillNumber = aInvBillBaseInfo.getNumber();
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        Vector<MaterialSerialNumberInfo> vecSNinfo = new Vector<MaterialSerialNumberInfo>(0);
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance((Context)ctx);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (i = 0; i < iObjectCollection.size(); ++i) {
            aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            entryIdSet.add(aInvBillBaseEntryInfo.getId().toString());
        }
        if (entryIdSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
            iMaterialSerialNumber.delete(filterInfo);
        }
        for (i = 0; i < iObjectCollection.size(); ++i) {
            aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (aInvBillBaseEntryInfo.getLot() == null) continue;
            String key = null;
            key = null == aInvBillBaseEntryInfo.getLot() ? aInvBillBaseEntryInfo.getMaterial().getId().toString() : aInvBillBaseEntryInfo.getLot().trim() + aInvBillBaseEntryInfo.getMaterial().getId().toString();
            if (!htSN.containsKey(key) || SerialNumberStatusEnum.NULL == (snstatus = InvCommonUtils.getSnStatusByTranType((TransactionTypeInfo)aInvBillBaseInfo.getTransactionType(), (InvUpdateTypeInfo)aInvBillBaseEntryInfo.getInvUpdateType(), (boolean)(aInvBillBaseInfo.isIsReversed() ^ InvAppUtils.isNegative((TransactionTypeInfo)aInvBillBaseInfo.getTransactionType()))))) continue;
            Vector vecSN = (Vector)htSN.get(key);
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillType(aBillTypeInfo);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(aInvBillBaseEntryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(aInvBillBaseEntryInfo.getStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(aInvBillBaseEntryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(aInvBillBaseEntryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(aInvBillBaseEntryInfo.getMaterial());
            BigDecimal bigQty = new BigDecimal(vecSN.size());
            aMaterialSerialNumberInfo.setSnQty(bigQty);
            aMaterialSerialNumberInfo.setIsReversed(false);
            aMaterialSerialNumberInfo.setSnStatus(snstatus == SerialNumberStatusEnum.SALE ? snstatus : SerialNumberStatusEnum.INWAREHOUSE);
            for (int j = 0; j < vecSN.size(); ++j) {
                MaterialSerialNumberEntryInfo aMaterialSerialNumberEntry = new MaterialSerialNumberEntryInfo();
                aMaterialSerialNumberEntry.setSerialNumber((String)vecSN.get(j));
                aMaterialSerialNumberInfo.getEntry().add(aMaterialSerialNumberEntry);
            }
            vecSNinfo.add(aMaterialSerialNumberInfo);
        }
        CoreBaseCollection newMsnCol = new CoreBaseCollection();
        for (int i2 = 0; i2 < vecSNinfo.size(); ++i2) {
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = (MaterialSerialNumberInfo)vecSNinfo.get(i2);
            newMsnCol.add((CoreBaseInfo)aMaterialSerialNumberInfo);
        }
        if (newMsnCol.size() > 0) {
            iMaterialSerialNumber.addnewBatchData(newMsnCol);
        }
    }
}

