/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseCollection;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class SerialNumberProcessor
extends AbstractSCMBusinessProcessor {
    private static final long serialVersionUID = 5253255410962670451L;

    public SerialNumberProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SerialNumberProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SerialNumberProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (null == collection || collection.size() == 0) {
            return;
        }
        if (!this.checkMaterialIsSN(collection)) {
            if (collection.getObject(0).get("id") != null) {
                ObjectUuidPK pk = new ObjectUuidPK(collection.getObject(0).get("id").toString());
                InvServerUtils.deleteSerialNumber((Context)this.ctx, (IObjectPK)pk);
            }
            return;
        }
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance((Context)this.ctx);
        if (collection.getObject(0) instanceof StockTransferBillInfo || collection.getObject(0) instanceof TransferOrderBillInfo || collection.getObject(0) instanceof InvBillBaseInfo && InvCommonUtils.isNeedUpdateSerialNumber((InvBillBaseInfo)((InvBillBaseInfo)collection.getObject(0)))) {
            iMaterialSerialNumber.updateMaterialSN(collection);
        }
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            SCMBillBaseCollection scmBillBaseCollection = new SCMBillBaseCollection();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)collection.getObject(i);
                scmBillBaseCollection.add(scmBillBaseInfo);
            }
            if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
                iMaterialSerialNumber.checkSerialNumberIsNull(scmBillBaseCollection);
            }
            if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
                iMaterialSerialNumber.doSerialNumberCarry(scmBillBaseCollection);
            }
        } else if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            SCMBillBaseCollection scmBillBaseCollection = new SCMBillBaseCollection();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)collection.getObject(i);
                iMaterialSerialNumber.updateSerialInventory(scmBillBaseInfo);
                scmBillBaseCollection.add(scmBillBaseInfo);
            }
            iMaterialSerialNumber.checkSerialNumberIsNull(scmBillBaseCollection);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)collection.getObject(i);
                iMaterialSerialNumber.unAduitSerialInventory(scmBillBaseInfo);
            }
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    protected void importMaterialSN(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        InvBillBaseEntryInfo aInvBillBaseEntryInfo;
        int i;
        if (aInvBillBaseInfo.get("ImportSN") == null) {
            return;
        }
        if (!(aInvBillBaseInfo instanceof SaleIssueBillInfo || aInvBillBaseInfo instanceof PurInWarehsBillInfo || aInvBillBaseInfo instanceof MoveIssueBillInfo || aInvBillBaseInfo instanceof MoveInWarehsBillInfo || aInvBillBaseInfo instanceof OtherInWarehsBillInfo || aInvBillBaseInfo instanceof OtherIssueBillInfo)) {
            return;
        }
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        SerialNumberStatusEnum snstatus = null;
        Hashtable htSN = (Hashtable)aInvBillBaseInfo.get("ImportSN");
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        String strBillId = aInvBillBaseInfo.getId().toString();
        String strBillNumber = aInvBillBaseInfo.getNumber();
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        ArrayList<MaterialSerialNumberInfo> vecSNinfo = new ArrayList<MaterialSerialNumberInfo>(0);
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance((Context)this.ctx);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (i = 0; i < iObjectCollection.size(); ++i) {
            aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            entryIdSet.add(aInvBillBaseEntryInfo.getId().toString());
        }
        if (entryIdSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
            iMaterialSerialNumber.delete(filterInfo);
        }
        for (i = 0; i < iObjectCollection.size(); ++i) {
            aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (aInvBillBaseEntryInfo.getLot() == null) continue;
            String key = null;
            key = null == aInvBillBaseEntryInfo.getLot() ? aInvBillBaseEntryInfo.getMaterial().getId().toString() : aInvBillBaseEntryInfo.getLot().trim() + aInvBillBaseEntryInfo.getMaterial().getId().toString();
            if (!htSN.containsKey(key) || SerialNumberStatusEnum.NULL == (snstatus = InvCommonUtils.getSnStatusByTranType((TransactionTypeInfo)tti, (InvUpdateTypeInfo)aInvBillBaseEntryInfo.getInvUpdateType(), (boolean)(aInvBillBaseInfo.isIsReversed() ^ InvAppUtils.isNegative((TransactionTypeInfo)aInvBillBaseInfo.getTransactionType()))))) continue;
            Vector vecSN = (Vector)htSN.get(key);
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillType(aBillTypeInfo);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(aInvBillBaseEntryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(aInvBillBaseEntryInfo.getStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(aInvBillBaseEntryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(aInvBillBaseEntryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(aInvBillBaseEntryInfo.getMaterial());
            aMaterialSerialNumberInfo.setTransactionType(aInvBillBaseInfo.getTransactionType());
            aMaterialSerialNumberInfo.setBillBaseStatus(aInvBillBaseInfo.getBaseStatus());
            aMaterialSerialNumberInfo.setBillBizDate(aInvBillBaseInfo.getBizDate());
            aMaterialSerialNumberInfo.setWarehouse(aInvBillBaseEntryInfo.getWarehouse());
            aMaterialSerialNumberInfo.setLocation(aInvBillBaseEntryInfo.getLocation());
            BigDecimal bigQty = new BigDecimal(vecSN.size());
            aMaterialSerialNumberInfo.setSnQty(bigQty);
            aMaterialSerialNumberInfo.setIsReversed(false);
            aMaterialSerialNumberInfo.setSnStatus(snstatus);
            for (int j = 0; j < vecSN.size(); ++j) {
                MaterialSerialNumberEntryInfo aMaterialSerialNumberEntry = new MaterialSerialNumberEntryInfo();
                aMaterialSerialNumberEntry.setSerialNumber((String)vecSN.get(j));
                aMaterialSerialNumberInfo.getEntry().add(aMaterialSerialNumberEntry);
            }
            vecSNinfo.add(aMaterialSerialNumberInfo);
        }
        CoreBaseCollection newMsnCol = new CoreBaseCollection();
        for (int i2 = 0; i2 < vecSNinfo.size(); ++i2) {
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = (MaterialSerialNumberInfo)vecSNinfo.get(i2);
            newMsnCol.add((CoreBaseInfo)aMaterialSerialNumberInfo);
        }
        if (newMsnCol.size() > 0) {
            iMaterialSerialNumber.addnewBatchData(newMsnCol);
        }
    }

    protected void importMaterialSN(StockTransferBillInfo billInfo) throws BOSException, EASBizException {
        int i;
        if (billInfo.get("ImportSN") == null) {
            return;
        }
        Hashtable htSN = (Hashtable)billInfo.get("ImportSN");
        StockTransferBillEntryCollection entryCol = billInfo.getEntry();
        StockTransferBillEntryInfo entryInfo = null;
        String strBillId = billInfo.getId().toString();
        String strBillNumber = billInfo.getNumber();
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        ArrayList<MaterialSerialNumberInfo> vecSNinfo = new ArrayList<MaterialSerialNumberInfo>(0);
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance((Context)this.ctx);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (i = 0; i < entryCol.size(); ++i) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            entryIdSet.add(aInvBillBaseEntryInfo.getId().toString());
        }
        if (entryIdSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
            imsn.delete(filterInfo);
        }
        for (i = 0; i < entryCol.size(); ++i) {
            String key;
            entryInfo = (StockTransferBillEntryInfo)entryCol.getObject(i);
            if (entryInfo.getLot() == null || entryInfo.getLot().trim().length() == 0 || entryInfo.getMaterial() == null || !htSN.containsKey(key = entryInfo.getLot().trim() + entryInfo.getMaterial().getId().toString())) continue;
            Vector vecSN = (Vector)htSN.get(key);
            MaterialSerialNumberInfo msnInfo = new MaterialSerialNumberInfo();
            msnInfo.setBillID(strBillId);
            msnInfo.setBillType(aBillTypeInfo);
            msnInfo.setBillNumber(strBillNumber);
            msnInfo.setSnUnit(entryInfo.getUnit());
            msnInfo.setStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
            msnInfo.setBillEntryID(entryInfo.getId().toString());
            msnInfo.setBillEntrySeq(entryInfo.getSeq());
            msnInfo.setMaterial(entryInfo.getMaterial());
            BigDecimal bigQty = new BigDecimal(vecSN.size());
            msnInfo.setSnQty(bigQty);
            msnInfo.setIsReversed(false);
            msnInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            msnInfo.setTransactionType(null);
            msnInfo.setBillBaseStatus(billInfo.getBaseStatus());
            msnInfo.setBillBizDate(billInfo.getBizDate());
            msnInfo.setWarehouse(entryInfo.getIssueWarehouse());
            msnInfo.setLocation(entryInfo.getIssueLocation());
            int vsize = vecSN.size();
            for (int j = 0; j < vsize; ++j) {
                MaterialSerialNumberEntryInfo msnEntry = new MaterialSerialNumberEntryInfo();
                msnEntry.setSerialNumber((String)vecSN.get(j));
                msnInfo.getEntry().add(msnEntry);
            }
            vecSNinfo.add(msnInfo);
        }
        CoreBaseCollection newMsnCol = new CoreBaseCollection();
        int size = vecSNinfo.size();
        for (int i2 = 0; i2 < size; ++i2) {
            MaterialSerialNumberInfo msnInfo = (MaterialSerialNumberInfo)vecSNinfo.get(i2);
            newMsnCol.add((CoreBaseInfo)msnInfo);
        }
        if (newMsnCol.size() > 0) {
            imsn.addnewBatchData(newMsnCol);
        }
    }

    private boolean checkMaterialIsSN(IObjectCollection collection) throws BOSException, EASBizException {
        HashSet<String> matIdSet = new HashSet<String>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)collection.getObject(i);
            IObjectCollection scmBillEntryBaseCollection = scmBillBaseInfo.getEntries();
            SCMBillEntryBaseInfo scmEntryBaseInfo = null;
            for (int j = 0; j < scmBillEntryBaseCollection.size(); ++j) {
                scmEntryBaseInfo = (SCMBillEntryBaseInfo)scmBillEntryBaseCollection.getObject(j);
                if (scmEntryBaseInfo.getMaterial() == null) continue;
                matIdSet.add(scmEntryBaseInfo.getMaterial().getId().toString());
            }
        }
        if (matIdSet.size() > 0) {
            String matIdString = CollectionUtil.convertList2String(new ArrayList(matIdSet));
            String sql = "select 1 from T_BD_MATERIAL WHERE FID in (" + matIdString + ") and FSEQUNITID IS NOT NULL";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            if (rs.size() <= 0) {
                return false;
            }
        }
        return true;
    }
}

