/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpdateFullReverseBillCostProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 2112383138397177041L;

    public UpdateFullReverseBillCostProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public UpdateFullReverseBillCostProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public UpdateFullReverseBillCostProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext applicationContext;
        Object temp;
        IObjectCollection collection = batchResults.getObjCollection();
        ExecuteContext executeContext = this.getExecuteContext();
        boolean isAdnew = false;
        if (executeContext != null && (temp = (applicationContext = executeContext.getApplicationContext()).getData("isAddNew")) != null) {
            Boolean isAddNew = (Boolean)applicationContext.getData("isAddNew");
            isAdnew = isAddNew;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            if (!aInvBillBaseInfo.isIsReversed()) continue;
            if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                this.updateFullReverseBillCost(this.ctx, aInvBillBaseInfo);
                continue;
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.SAVE) && !this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) continue;
            this.setTraceUp(this.ctx, (IObjectValue)aInvBillBaseInfo, isAdnew);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    public void setTraceUp(Context ctx, IObjectValue info, boolean isAddNew) throws BOSException, EASBizException {
        InvBillBaseInfo invBillinfo = (InvBillBaseInfo)info;
        if (invBillinfo.isIsReversed() && isAddNew) {
            String srcId = invBillinfo.getSourceBillId();
            ObjectUuidPK srcPk = new ObjectUuidPK(srcId);
            String bosType = srcPk.getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcId, (String)invBillinfo.getId().toString(), (String)bosType, (String)bosType);
        }
    }

    private void updateFullReverseBillCost(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException {
        if (aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
            this.updateFullReversePurInBillCost(ctx, (PurInWarehsBillInfo)aInvBillBaseInfo);
            return;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk1 = imeataLoader.getEntityObjectPK(aInvBillBaseInfo.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk1);
        String tableName = entityObjectInfo.getTable().getName();
        String entryTableName = CalculateUtil.getEntryTableNameFormBillTableName((String)tableName);
        if (!aInvBillBaseInfo.isIsReversed() || StringUtil.isEmptyString((String)tableName) || StringUtil.isEmptyString((String)entryTableName)) {
            return;
        }
        boolean flag = false;
        if (aInvBillBaseInfo instanceof PurInWarehsBillInfo || aInvBillBaseInfo instanceof SaleIssueBillInfo) {
            flag = true;
        }
        StringBuffer bf1 = new StringBuffer();
        bf1.append("select entry.factualCost as actualCost");
        bf1.append(" ,entry.funitActualCost as unitActualCost");
        bf1.append(" ,entry.fQty as qty");
        bf1.append(" ,entry.freverseQty as reverseQty");
        bf1.append(" ,entry.fid as entryID");
        bf1.append(" from ").append(tableName).append(" as bill");
        bf1.append(" inner join ").append(entryTableName).append(" as entry");
        bf1.append(" on bill.fid = entry.fparentid");
        bf1.append(" where bill.FIsReversed = 0 and bill.fbaseStatus=4 and bill.fid = ?");
        String querySourceBillSql = bf1.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("select entry.fid as entryID");
        bf2.append(" ,entry.fqty as qty");
        bf2.append(" ,entry.factualCost as actualCost");
        bf2.append(" ,bill.ffiVouchered as fiVouchered");
        bf2.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf2.append(" from ").append(tableName).append(" as bill");
        bf2.append(" inner join ").append(entryTableName).append(" as entry");
        bf2.append(" on bill.fid = entry.fparentid");
        bf2.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf2.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf2.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf2.append(" where bill.FIsReversed = 1");
        bf2.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        bf2.append(" order by fivouchered desc");
        String queryReverseBillSql = bf2.toString();
        StringBuffer bf3 = new StringBuffer();
        bf3.append("update ").append(entryTableName);
        bf3.append(" set  FAssociateQty=abs(FBaseQty), FUnitActualCost=?,FActualCost=?");
        if (flag) {
            bf3.append(",FWrittenOffAmount=?,FUnWriteOffAmount=?");
        }
        bf3.append(" where fid=?");
        String updateReverseBillSql = bf3.toString();
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        PreparedStatement pm3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm1 = conn.prepareStatement(querySourceBillSql);
            pm2 = conn.prepareStatement(queryReverseBillSql, 1004, 1007);
            pm3 = conn.prepareStatement(updateReverseBillSql);
            pm1.setString(1, aInvBillBaseInfo.getSourceBillId());
            rs1 = pm1.executeQuery();
            while (rs1.next()) {
                String entryID = rs1.getString("entryID");
                BigDecimal actualCost = rs1.getBigDecimal("actualCost");
                BigDecimal unitActualCost = rs1.getBigDecimal("unitActualCost").abs();
                BigDecimal cost = new BigDecimal("0.00");
                pm2.setString(1, entryID);
                rs2 = pm2.executeQuery();
                int i = 0;
                while (rs2.next()) {
                    BigDecimal reverseCost;
                    BigDecimal reverseActualCost = rs2.getBigDecimal("actualCost");
                    boolean isVouchered = rs2.getBoolean("fiVouchered");
                    int precision = rs2.getInt("fprecision");
                    BigDecimal bigDecimal = reverseCost = isVouchered ? reverseActualCost : unitActualCost.multiply(rs2.getBigDecimal("qty")).setScale(precision, 4);
                    if (rs1.getBigDecimal("qty").abs().compareTo(rs1.getBigDecimal("reverseQty").abs()) == 0 && rs2.isLast() && ++i > 1) {
                        reverseCost = actualCost.abs().subtract(cost.abs()).negate();
                        if (actualCost.signum() == -1) {
                            reverseCost = reverseCost.multiply(new BigDecimal("-1"));
                        }
                    } else if (rs1.getBigDecimal("qty").abs().compareTo(rs1.getBigDecimal("reverseQty").abs()) == 0 && rs2.isLast() && i == 1) {
                        reverseCost = actualCost.negate();
                    }
                    cost = cost.add(reverseCost.abs());
                    int y = 1;
                    pm3.setBigDecimal(y, unitActualCost);
                    pm3.setBigDecimal(++y, reverseCost);
                    ++y;
                    if (flag) {
                        pm3.setBigDecimal(y, reverseCost);
                        pm3.setBigDecimal(++y, new BigDecimal("0.00"));
                        ++y;
                    }
                    pm3.setString(y, rs2.getString("entryID"));
                    pm3.addBatch();
                }
            }
            pm3.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm1, pm2, pm3}, (ResultSet[])new ResultSet[]{rs1, rs2});
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm1, pm2, pm3}, (ResultSet[])new ResultSet[]{rs1, rs2});
    }

    private void updateFullReversePurInBillCost(Context ctx, PurInWarehsBillInfo aInvBillBaseInfo) throws BOSException {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk1 = imeataLoader.getEntityObjectPK(aInvBillBaseInfo.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk1);
        String tableName = entityObjectInfo.getTable().getName();
        String entryTableName = CalculateUtil.getEntryTableNameFormBillTableName((String)tableName);
        if (!aInvBillBaseInfo.isIsReversed() || StringUtil.isEmptyString((String)tableName) || StringUtil.isEmptyString((String)entryTableName)) {
            return;
        }
        StringBuffer bf1 = new StringBuffer();
        bf1.append("select entry.factualCost as actualCost");
        bf1.append(" ,entry.funitActualCost as unitActualCost");
        bf1.append(" ,entry.fpurchasecost as purchaseCost");
        bf1.append(" ,entry.funitpurchasecost as unitPurchaseCost");
        bf1.append(" ,entry.fQty as qty");
        bf1.append(" ,entry.freverseQty as reverseQty");
        bf1.append(" ,entry.fid as entryID");
        bf1.append(" from ").append(tableName).append(" as bill");
        bf1.append(" inner join ").append(entryTableName).append(" as entry");
        bf1.append(" on bill.fid = entry.fparentid");
        bf1.append(" where bill.FIsReversed = 0 and bill.fbaseStatus=4 and bill.fid = ?");
        String querySourceBillSql = bf1.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("select entry.fid as entryID");
        bf2.append(" ,entry.fqty as qty");
        bf2.append(" ,entry.factualCost as actualCost");
        bf2.append(" ,entry.fpurchasecost as purchaseCost");
        bf2.append(" ,bill.ffiVouchered as fiVouchered");
        bf2.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf2.append(" from ").append(tableName).append(" as bill");
        bf2.append(" inner join ").append(entryTableName).append(" as entry");
        bf2.append(" on bill.fid = entry.fparentid");
        bf2.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf2.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf2.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf2.append(" where bill.FIsReversed = 1");
        bf2.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        bf2.append(" order by fivouchered desc");
        String queryReverseBillSql = bf2.toString();
        StringBuffer bf3 = new StringBuffer();
        bf3.append("update ").append(entryTableName);
        bf3.append(" set  FAssociateQty=abs(FBaseQty), FUnitActualCost=?,FActualCost=?");
        bf3.append(",FWrittenOffAmount=?,FUnWriteOffAmount=?");
        bf3.append(",FPurchaseCost=?");
        bf3.append(" where fid=?");
        String updateReverseBillSql = bf3.toString();
        StringBuffer sb4 = new StringBuffer();
        sb4.append("update ").append(tableName).append(" set FTotalActualCost = ");
        sb4.append(" ( select c.totalcost from ( select sum(factualcost) totalcost,fparentid from ").append(entryTableName);
        sb4.append(" where fparentid = ( select top 1 fparentid from ").append(entryTableName).append(" where fid = ? ) group by fparentid ) as c )");
        sb4.append(" where fid = ( select top 1 fparentid from ").append(entryTableName).append(" where fid = ? )");
        String updateReverseBillTotalActualCost = sb4.toString();
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        PreparedStatement pm3 = null;
        PreparedStatement pm4 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm1 = conn.prepareStatement(querySourceBillSql);
            pm2 = conn.prepareStatement(queryReverseBillSql, 1004, 1007);
            pm3 = conn.prepareStatement(updateReverseBillSql);
            pm4 = conn.prepareStatement(updateReverseBillTotalActualCost);
            pm1.setString(1, aInvBillBaseInfo.getSourceBillId());
            rs1 = pm1.executeQuery();
            while (rs1.next()) {
                String entryID = rs1.getString("entryID");
                BigDecimal unitActualCost = rs1.getBigDecimal("unitActualCost").abs();
                BigDecimal purchaseCost = rs1.getBigDecimal("purchaseCost");
                BigDecimal unitPurchaseCost = rs1.getBigDecimal("unitPurchaseCost").abs();
                BigDecimal cost = new BigDecimal("0.00");
                pm2.setString(1, entryID);
                rs2 = pm2.executeQuery();
                int i = 0;
                while (rs2.next()) {
                    BigDecimal reverseCost;
                    BigDecimal reverseActualCost = rs2.getBigDecimal("actualCost");
                    BigDecimal reversePurchaseCost = rs2.getBigDecimal("purchaseCost");
                    boolean isVouchered = rs2.getBoolean("fiVouchered");
                    int precision = rs2.getInt("fprecision");
                    BigDecimal bigDecimal = reverseCost = isVouchered ? reversePurchaseCost : unitPurchaseCost.multiply(rs2.getBigDecimal("qty")).setScale(precision, 4);
                    if (rs1.getBigDecimal("qty").abs().compareTo(rs1.getBigDecimal("reverseQty").abs()) == 0 && rs2.isLast() && ++i > 1) {
                        reverseCost = purchaseCost.abs().subtract(cost.abs()).negate();
                        if (purchaseCost.signum() == -1) {
                            reverseCost = reverseCost.multiply(new BigDecimal("-1"));
                        }
                    } else if (rs1.getBigDecimal("qty").abs().compareTo(rs1.getBigDecimal("reverseQty").abs()) == 0 && rs2.isLast() && i == 1) {
                        reverseCost = purchaseCost.negate();
                    }
                    cost = cost.add(reverseCost.abs());
                    int y = 1;
                    pm3.setBigDecimal(y, unitActualCost);
                    pm3.setBigDecimal(++y, reverseActualCost);
                    pm3.setBigDecimal(++y, reverseCost);
                    pm3.setBigDecimal(++y, new BigDecimal("0.00"));
                    pm3.setBigDecimal(++y, reverseCost);
                    pm3.setString(++y, rs2.getString("entryID"));
                    pm3.addBatch();
                    pm4.setString(1, rs2.getString("entryID"));
                    pm4.setString(2, rs2.getString("entryID"));
                    pm4.addBatch();
                }
            }
            pm3.executeBatch();
            pm4.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm1, pm2, pm3, pm4}, (ResultSet[])new ResultSet[]{rs1, rs2});
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm1, pm2, pm3, pm4}, (ResultSet[])new ResultSet[]{rs1, rs2});
    }
}

