/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.manufacturerec;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;

public class AutoGenerateCostObjectProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -6389918507812613908L;

    public AutoGenerateCostObjectProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public AutoGenerateCostObjectProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public AutoGenerateCostObjectProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (null == collection) {
            return;
        }
        if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.autoGenerateCostObject(collection.getObject(i));
        }
    }

    private void autoGenerateCostObject(IObjectValue model) throws BOSException, EASBizException {
        ManufactureRecBillInfo billInfo = (ManufactureRecBillInfo)model;
        ManufactureRecBillEntryCollection entryColl = billInfo.getEntry();
        ManufactureRecBillEntryInfo entryInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        CostObjectCollection costColl = new CostObjectCollection();
        CostObjectInfo costInfo = null;
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.ctx);
        IMaterialCost iMaterialCost = MaterialCostFactory.getLocalInstance((Context)this.ctx);
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)this.ctx);
        if (billInfo == null || billInfo.getStorageOrgUnit() == null) {
            return;
        }
        if (entryColl == null) {
            return;
        }
        int size = entryColl.size();
        if (size <= 0) {
            return;
        }
        companyInfo = entryColl.get(0).getCompanyOrgUnit();
        if (companyInfo == null) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            entryInfo = entryColl.get(index);
            if (entryInfo == null || !this.checkIsGenerateCostObject(entryInfo.getMaterial(), companyInfo, iMaterialCompany, iMaterialCost)) continue;
            costInfo = new CostObjectInfo();
            costInfo.setCompany(companyInfo);
            costInfo.setRelatedId(entryInfo.getMaterial().getId());
            costInfo.setBatchNumber(entryInfo.getLot());
            costColl.add(costInfo);
        }
        if (costColl.size() > 0) {
            iCostObject.addnewBybatch((IObjectCollection)costColl);
        }
    }

    private boolean checkIsGenerateCostObject(MaterialInfo materialInfo, CompanyOrgUnitInfo companyInfo, IMaterialCompanyInfo iMaterialCompany, IMaterialCost iMaterialCost) throws BOSException, EASBizException {
        MaterialCompanyInfoCollection materialComColl = null;
        MaterialCostCollection materialCostColl = null;
        if (materialInfo == null || !materialInfo.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            return false;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        materialComColl = iMaterialCompany.getMaterialCompanyInfoCollection(viewInfo);
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        viewInfo1.setFilter(filter1);
        viewInfo1.getSelector().add(new SelectorItemInfo("*"));
        viewInfo1.getSelector().add(new SelectorItemInfo("costObejctGroup.*"));
        materialCostColl = iMaterialCost.getMaterialCostCollection(viewInfo1);
        if (materialComColl == null || materialCostColl == null || materialComColl.size() <= 0 || materialCostColl.size() <= 0) {
            return false;
        }
        return false;
    }
}

