/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvDefaultValueProcessor;
import com.kingdee.util.StringUtils;
import java.util.List;

public abstract class AbstractMatAssembleDefaultValueProcessor
extends InvDefaultValueProcessor {
    private static final long serialVersionUID = -4357131118199182413L;

    public AbstractMatAssembleDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public AbstractMatAssembleDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public AbstractMatAssembleDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        IObjectCollection collection = batchResults.getObjCollection();
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                InvBillBaseInfo invBillInfo = (InvBillBaseInfo)collection.getObject(i);
                for (int j = 0; j < invBillInfo.getEntries().size(); ++j) {
                    InvBillBaseEntryInfo invEntryInfo = (InvBillBaseEntryInfo)invBillInfo.getEntries().getObject(j);
                    this.setNullToZero(invEntryInfo);
                    this.setNullToFalse(invEntryInfo);
                    this.setEmptyToNullForLot(invEntryInfo);
                    this.updateEntryFields(invEntryInfo);
                    this.setEntryCompanyInfo(invEntryInfo);
                    this.setEntrySeq(invEntryInfo);
                }
            }
        }
    }

    private void setEntrySeq(InvBillBaseEntryInfo invEntryInfo) {
        IObjectCollection entrys = (IObjectCollection)invEntryInfo.get(this.getEntry1Name());
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            entry.setSeq(i + 1);
        }
    }

    private void setEntryCompanyInfo(InvBillBaseEntryInfo invEntryInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou = invEntryInfo.getStorageOrgUnit();
        if (sou == null) {
            return;
        }
        IObjectCollection entrys = (IObjectCollection)invEntryInfo.get(this.getEntry1Name());
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            if (entry.getCompanyOrgUnit() != null) continue;
            entry.setCompanyOrgUnit(this.getSouDelegateCou(sou));
        }
    }

    private void setEmptyToNullForLot(InvBillBaseEntryInfo invEntryInfo) {
        IObjectCollection entryCol = (IObjectCollection)invEntryInfo.get(this.getEntry1Name());
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (!StringUtils.isEmpty((String)entry.getLot())) continue;
            entry.setLot(null);
        }
    }

    private void setNullToFalse(InvBillBaseEntryInfo invEntryInfo) {
        List<String> fields = this.getEntryBooleanFields();
        if (null != fields) {
            IObjectCollection entryCol = (IObjectCollection)invEntryInfo.get(this.getEntry1Name());
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entryCol.getObject(i);
                for (String f : fields) {
                    if (entry.get(f) != null) continue;
                    entry.setBoolean(f, false);
                }
            }
        }
    }

    private void setNullToZero(InvBillBaseEntryInfo invEntryInfo) {
        List<String> fields = this.getEntryNumberFields();
        if (null != fields) {
            IObjectCollection entryCol = (IObjectCollection)invEntryInfo.get(this.getEntry1Name());
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entryCol.getObject(i);
                for (String f : fields) {
                    if (entry.getBigDecimal(f) != null) continue;
                    entry.setBigDecimal(f, SCMConstant.BIGDECIMAL_ZERO);
                }
            }
        }
    }

    private void updateEntryFields(InvBillBaseEntryInfo invEntryInfo) {
        IObjectCollection entryCol = (IObjectCollection)invEntryInfo.get(this.getEntry1Name());
        InvBillBaseEntryInfo entryInfo = null;
        MaterialInfo material = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (entryInfo != null && entryInfo.getStorageOrgUnit() == null && invEntryInfo.getStorageOrgUnit() != null) {
                entryInfo.setStorageOrgUnit(invEntryInfo.getStorageOrgUnit());
            }
            if ((material = entryInfo.getMaterial()) == null || material.getAssistUnit() == null || entryInfo.getAssistUnit() != null) continue;
            entryInfo.setAssistUnit(material.getAssistUnit());
        }
    }

    protected abstract String getEntry1Name();
}

