/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.validator.bizrule.app.CheckSerialNumberVRule;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForMatattrBotp;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMatAssembleOtherBiz4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -8008642046781518831L;
    protected String XTZHBISSUE;
    protected String XTZHAINWAREHS;

    public AbstractMatAssembleOtherBiz4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public AbstractMatAssembleOtherBiz4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public AbstractMatAssembleOtherBiz4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance((Context)this.ctx);
        CheckSerialNumberVRule rule = new CheckSerialNumberVRule(this.ctx);
        CreateVirtualBillForMatattrBotp botp = new CreateVirtualBillForMatattrBotp();
        String issueBotpNumber = "";
        String inWarehsBotpNumber = "";
        InvBillBaseInfo isSueInfo = null;
        InvBillBaseInfo inwarehsInfo = null;
        boolean isCarryFirstEntry = false;
        try {
            this.ctx.put((Object)"autoCreateBill", (Object)Boolean.TRUE);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                InvBillBaseInfo invBillInfo = (InvBillBaseInfo)collection.getObject(i);
                isCarryFirstEntry = !"CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(invBillInfo.getBillType().getId().toString());
                iMaterialSerialNumber.checkSerialNumberIsNull((SCMBillBaseInfo)invBillInfo);
                issueBotpNumber = this.XTZHBISSUE;
                inWarehsBotpNumber = this.XTZHAINWAREHS;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("baseStatus"));
                iMaterialSerialNumber.updateMaterialSN((SCMBillBaseInfo)invBillInfo);
                IOtherIssueBill issueBill = OtherIssueBillFactory.getLocalInstance((Context)this.ctx);
                isSueInfo = botp.createInvVirtualBill(this.ctx, (IObjectValue)invBillInfo, (IInvBillBase)issueBill, issueBotpNumber, null);
                iMaterialSerialNumber.doSerialNumberCarry(invBillInfo, isSueInfo, isCarryFirstEntry);
                issueBill.submit((CoreBaseInfo)isSueInfo);
                isSueInfo = issueBill.getOtherIssueBillInfo((IObjectPK)new ObjectUuidPK(isSueInfo.getId().toString()), selector);
                if (isSueInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                    issueBill.audit((IObjectPK)new ObjectUuidPK(isSueInfo.getId().toString()));
                }
                IOtherInWarehsBill inWarehsBill = OtherInWarehsBillFactory.getLocalInstance((Context)this.ctx);
                inwarehsInfo = botp.createInvVirtualBill(this.ctx, (IObjectValue)invBillInfo, (IInvBillBase)inWarehsBill, inWarehsBotpNumber, isSueInfo);
                iMaterialSerialNumber.doSerialNumberCarry(invBillInfo, inwarehsInfo, !isCarryFirstEntry);
                inWarehsBill.submit((CoreBaseInfo)inwarehsInfo);
                inwarehsInfo = inWarehsBill.getOtherInWarehsBillInfo((IObjectPK)new ObjectUuidPK(inwarehsInfo.getId().toString()), selector);
                if (inwarehsInfo.getBaseStatus() == BillBaseStatusEnum.AUDITED) continue;
                inWarehsBill.audit((IObjectPK)new ObjectUuidPK(inwarehsInfo.getId().toString()));
            }
        }
        finally {
            this.ctx.remove((Object)"autoCreateBill");
        }
    }

    protected void afterAuditBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isShuted;
        InvBillBaseInfo billInfo = (InvBillBaseInfo)model;
        Date bizDate = billInfo.getBizDate();
        CompanyOrgUnitInfo cou = ((InvBillBaseEntryInfo)billInfo.getEntries().getObject(0)).getCompanyOrgUnit();
        if (cou != null && (isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou))) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou);
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (periodInfo != null && periodInfo.equals((Object)curPeriodInfo)) {
                throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED, (Object[])new String[]{cou.getName()});
            }
        }
        SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)model, (CompanyOrgUnitInfo)cou, (boolean)false);
        ObjectUuidPK pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        HashMap paramMap = new HashMap();
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance((Context)ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            this.insertLots(ctx, (IObjectPK)pk, billInfo);
        }
        if (paramMap.get("isCloseSerialNum") == null || !((Boolean)paramMap.get("isCloseSerialNum")).booleanValue()) {
            this.updateSerialNumInventory(ctx, billInfo);
        }
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance((Context)ctx);
        iMaterialSerialNumber.checkSerialNumberIsNull((SCMBillBaseInfo)billInfo);
        iMaterialSerialNumber.updateMaterialSN((SCMBillBaseInfo)billInfo);
        this.updateInventory(ctx, (IObjectPK)pk, billInfo, BizActionEnum.AUDIT);
        this.calculate(ctx, billInfo);
    }

    protected void updateInventory(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, BizActionEnum bizAction) throws EASBizException, BOSException {
        IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
        String transTypeID = null;
        if (aInvBillBaseInfo.getTransactionType() != null) {
            transTypeID = aInvBillBaseInfo.getTransactionType().getId().toString();
            iInventoryUpdate.updateInventory(bizAction, pk.toString(), transTypeID);
        }
    }

    protected void calculate(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aInvBillBaseInfo);
    }

    protected void insertLots(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        if (tti == null) {
            return;
        }
        if (tti.getBillType() == null || tti.getRiType() == null || tti.getRiType().getBizDirection() == null) {
            tti = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId().toString()), InvCommonUtils.getTransactionSelectorItemCol());
        }
        String billTypeID = tti.getBillType().getId().toString();
        int bizDerection = tti.getRiType().getBizDirection().getValue();
        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && bizDerection == 1 || SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) && bizDerection == -1 || !aInvBillBaseInfo.isIsInitBill() && !aInvBillBaseInfo.isIsReversed() || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance((Context)ctx);
            if (aInvBillBaseInfo.getBillType().getId() != null) {
                ido.insertData(pk, aInvBillBaseInfo.getBillType().getId().toString());
            }
        }
    }

    protected void updateSerialNumInventory(Context ctx, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        String billtrypeid = billInfo.getBillType().getId().toString();
        boolean isSaleBack = false;
        TransactionTypeInfo tti = null;
        if (billInfo.getTransactionType() == null || billInfo.getTransactionType().getId() == null) {
            return;
        }
        tti = billInfo.getTransactionType();
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billtrypeid) && tti.getRiType().getBizDirection().getValue() == -1) {
            isSaleBack = true;
        }
        SerialNumberStatusEnum snstatus = null;
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        int entrySize = iObjectCollection.size();
        InvBillBaseEntryInfo ibb = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        String[] materialIds = new String[entrySize];
        String[] storageOrgIds = new String[entrySize];
        String[] seqUnitIDS = new String[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            materialIds[i] = ibb.getMaterial().getId().toString();
            storageOrgIds[i] = ibb.getStorageOrgUnit().getId().toString();
        }
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        Map mapMaterialInventorys = DataLoaderHelper.loadMaterialInventorys((Context)ctx, (String[])storageOrgIds, (String[])materialIds, (SelectorItemCollection)sicCol);
        SelectorItemCollection siCol = new SelectorItemCollection();
        siCol.add(new SelectorItemInfo("id"));
        siCol.add(new SelectorItemInfo("number"));
        siCol.add(new SelectorItemInfo("name"));
        siCol.add(new SelectorItemInfo("seqUnit.id"));
        siCol.add(new SelectorItemInfo("seqUnit.number"));
        siCol.add(new SelectorItemInfo("seqUnit.name"));
        Map mapMaterialSeq = DataLoaderHelper.loadMaterial((Context)ctx, (String[])materialIds, (SelectorItemCollection)siCol);
        boolean isNeedSele = false;
        MeasureUnitInfo seqUnit = null;
        HashMap map = new HashMap();
        for (int i = 0; i < entrySize; ++i) {
            if (mapMaterialSeq != null && materialIds[i] != null && mapMaterialSeq.get(materialIds[i]) != null && mapMaterialSeq.get(materialIds[i]) instanceof MaterialInfo) {
                seqUnit = ((MaterialInfo)mapMaterialSeq.get(materialIds[i])).getSeqUnit();
            }
            if (seqUnit != null) {
                isNeedSele = true;
                seqUnitIDS[i] = seqUnit.getId().toString();
                continue;
            }
            seqUnitIDS[i] = "";
        }
        if (isNeedSele) {
            map = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])materialIds, (String[])seqUnitIDS);
        }
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal baseQty;
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            MaterialInventoryInfo mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getStorageOrgUnit().getId().toString());
            if (mii == null || !mii.isIsSequenceNo() || ibb == null) continue;
            SerialNumberStatusEnum serialNumberStatusEnum = snstatus = "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billtrypeid) ? SerialNumberStatusEnum.INWAREHOUSE : InvCommonUtils.getSnStatusByTranType((TransactionTypeInfo)tti, (InvUpdateTypeInfo)ibb.getInvUpdateType(), (boolean)(billInfo.isIsReversed() ^ InvAppUtils.isNegative((TransactionTypeInfo)billInfo.getTransactionType())));
            if (SerialNumberStatusEnum.NULL == snstatus) continue;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(ibb.getId().toString());
            snInfo.setIsReversed(billInfo.isIsReversed());
            snInfo.setSoureBillID(ibb.getSourceBillId());
            snInfo.setSoureBillEntryID(ibb.getSourceBillEntryId());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setSnStatus(snstatus == SerialNumberStatusEnum.SALE ? snstatus : SerialNumberStatusEnum.INWAREHOUSE);
            snInfo.setBillType(billInfo.getBillType());
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setStorageOrgUnit(ibb.getStorageOrgUnit());
            snInfo.setMaterial(ibb.getMaterial());
            material = ibb.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = ((MaterialInfo)mapMaterialSeq.get(material.getId().toString())).getSeqUnit()) == null) {
                return;
            }
            BigDecimal sNqty = baseQty = ibb.getBaseQty();
            if (!ibb.getBaseUnit().getId().toString().equals(sNUnitInfo.getId().toString())) {
                BigDecimal coefficient = SCMConstant.BIGDECIMAL_ONE;
                MultiMeasureUnitInfo mulUnit = null;
                mulUnit = (MultiMeasureUnitInfo)map.get(material.getId().toString() + sNUnitInfo.getId().toString());
                if (mulUnit != null) {
                    coefficient = mulUnit.getBaseConvsRate();
                    int precision = mulUnit.getQtyPrecision();
                    if (coefficient != null) {
                        sNqty = baseQty.divide(coefficient, precision, 4);
                    }
                }
            }
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            snInfo.put("isSaleBack", (Object)isSaleBack);
            serialNumberInfos[i] = snInfo;
        }
        this.checkBillDuplicateSerialNumber(ctx, billInfo);
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance((Context)ctx);
        imsn.checkSerialNumber(true, (IObjectValue[])serialNumberInfos);
        imsn.updateSerialInventory((SCMBillBaseInfo)billInfo);
    }

    private void checkBillDuplicateSerialNumber(Context ctx, InvBillBaseInfo invbillBase) throws InvBizException, BOSException {
        Set<String> serialNumSet;
        if (null == invbillBase || invbillBase.getId() == null) {
            return;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)invbillBase.getId().toString()));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.serialNumber"));
        selector.add(new SelectorItemInfo("entry.id"));
        entityView.setSelector(selector);
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance((Context)ctx);
        MaterialSerialNumberCollection msnCol = imsn.getMaterialSerialNumberCollection(entityView);
        HashMap allSerialNumMap = new HashMap();
        HashMap<MaterialInfo, HashSet<String>> duplicateSerialMap = new HashMap<MaterialInfo, HashSet<String>>();
        int len = msnCol.size();
        for (int i = 0; i < len; ++i) {
            MaterialSerialNumberInfo msn = msnCol.get(i);
            MaterialSerialNumberEntryCollection entryCol = msn.getEntry();
            if (null == entryCol || entryCol.size() <= 0 || msn.getMaterial() == null) continue;
            int size = entryCol.size();
            for (int k = 0; k < size; ++k) {
                MaterialSerialNumberEntryInfo entryInfo = entryCol.get(k);
                String key = msn.getMaterial().getId().toString() + entryInfo.getSerialNumber();
                if (allSerialNumMap.containsKey(key)) {
                    serialNumSet = (Set)duplicateSerialMap.get(msn.getMaterial());
                    if (null == serialNumSet) {
                        serialNumSet = new HashSet<String>();
                        duplicateSerialMap.put(msn.getMaterial(), (HashSet<String>)serialNumSet);
                    }
                    serialNumSet.add(entryInfo.getSerialNumber());
                    continue;
                }
                allSerialNumMap.put(key, null);
            }
        }
        if (duplicateSerialMap.size() > 0) {
            Set keySet = duplicateSerialMap.keySet();
            Iterator iterator = keySet.iterator();
            StringBuffer errorMsg = new StringBuffer();
            while (iterator.hasNext()) {
                MaterialInfo materialInfo = (MaterialInfo)iterator.next();
                errorMsg.append(" (").append(materialInfo.getNumber()).append(": ");
                serialNumSet = (HashSet<String>)duplicateSerialMap.get(materialInfo);
                for (String serialNumber : serialNumSet) {
                    errorMsg.append(serialNumber).append(",");
                }
                errorMsg.setLength(errorMsg.length() - 1);
                errorMsg.append(" ),");
            }
            errorMsg.setLength(errorMsg.length() - 1);
            throw new InvBizException(InvBizException.BILL_HAS_DUPLICATE_SERIALNUMBER, (Object[])new String[]{errorMsg.toString()});
        }
    }

    protected abstract void sysOutEntryActualCost(Context var1, String var2, String var3) throws BOSException, EASBizException;
}

