/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractMatAssembleOtherBiz4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1627351055270534141L;

    public AbstractMatAssembleOtherBiz4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public AbstractMatAssembleOtherBiz4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public AbstractMatAssembleOtherBiz4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseInfo invBillInfo = (InvBillBaseInfo)collection.getObject(i);
            ArrayList<String> idList = new ArrayList<String>();
            IOtherIssueBill iIssue = OtherIssueBillFactory.getLocalInstance((Context)this.ctx);
            String isSueID = this.getOtherID(this.ctx, invBillInfo.getId().toString(), "T_IM_OTHERISSUEBILL", "T_IM_OTHERISSUEBILLENTRY");
            if (!StringUtils.isEmpty((String)isSueID)) {
                idList.add(isSueID);
                iIssue.innerUnAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
                iIssue.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
            }
            IOtherInWarehsBill iInWarehs = OtherInWarehsBillFactory.getLocalInstance((Context)this.ctx);
            String inWarehsID = this.getOtherID(this.ctx, invBillInfo.getId().toString(), "T_IM_OTHERINWAREHSBILL", "T_IM_OTHERINWAREHSBILLENTRY");
            if (!StringUtils.isEmpty((String)inWarehsID)) {
                idList.add(inWarehsID);
                iInWarehs.innerUnAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                iInWarehs.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                this.delCostAdjustBill(this.ctx, inWarehsID);
            }
            if (idList != null && idList.size() > 0) {
                this.deleteMaterialSerialByUnAudit(this.ctx, idList);
            }
            MaterialSerialNumberFactory.getLocalInstance((Context)this.ctx).updateMaterialSN((SCMBillBaseInfo)invBillInfo);
        }
    }

    public String getOtherID(Context ctx, String sourceBillID, String billTbl, String billEntryTbl) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT OIS.FID FROM " + billTbl + " OIS, " + billEntryTbl + " OISE ");
        sql.append(" WHERE OIS.FID = OISE.FPARENTID AND OISE.Fsourcebillid = '").append(sourceBillID).append("'");
        String otherID = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                otherID = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return otherID;
    }

    private void delCostAdjustBill(Context ctx, String inWarehsID) throws EASBizException, BOSException {
        String sql = "select fid from T_CL_CostAdjustBill where  FSourceBillID in ('" + inWarehsID + "')  and  (FCreateType = 14 or FCreateType = 15)";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<ObjectUuidPK> idSet = new HashSet<ObjectUuidPK>();
        try {
            while (rs.next()) {
                ObjectUuidPK costID = new ObjectUuidPK(rs.getString("fid"));
                idSet.add(costID);
            }
            for (IObjectPK iObjectPK : idSet) {
                CostAdjustBillFactory.getLocalInstance((Context)ctx).unAudit(iObjectPK);
                CostAdjustBillFactory.getLocalInstance((Context)ctx).delete(iObjectPK);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void deleteMaterialSerialByUnAudit(Context ctx, List idList) throws BOSException {
        if (idList != null && idList.size() > 0) {
            String ids = InvServerUtils.getInStringFromList((List)idList);
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_IV_MaterialSerialNumberEntry where fparentid in (select fid from ");
            sql.append("T_IV_MaterialSerialNumber where FBillId in ").append(ids).append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from T_IV_MaterialSerialNumber where fbillid in ").append(ids);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

