/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.materialreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.ParameterItem;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvBizDataCheckProcessor;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class MaterialReqBizDataCheckProcessor
extends InvBizDataCheckProcessor {
    private static final long serialVersionUID = 1L;
    private static final String resName = "com.kingdee.eas.scm.im.SCM_IMResource";
    public static final String WRITEBAK_SCM_VOUCHER = "FA_032";

    public MaterialReqBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MaterialReqBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public MaterialReqBizDataCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            MaterialReqBillInfo info = (MaterialReqBillInfo)collection.getObject(i);
            if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                if (info.getPurchaseType().equals((Object)PurchaseTypeEnum.SUBCONTRACT) && info.getSourceBillType() != null && "kvQieV/4TJ+1ipJVFBlPx0Y+1VI=".equals(info.getSourceBillType().getId().toString()) && info.getSupplier() == null) {
                    throw new InvBizException(InvBizException.SUPPLIER_NULL, (Object[])new String[]{info.getNumber()});
                }
                Map reversedSourceEntryMap = this.getReversedSourceEntry(info);
                for (int j = 0; j < info.getEntry().size(); ++j) {
                    BigDecimal realCountervail;
                    MaterialReqBillEntryInfo entryInfo = info.getEntry().get(i);
                    if (entryInfo == null || !info.isIsReversed() || entryInfo.getSourceBillEntryId() == null) continue;
                    MaterialReqBillEntryInfo sourceEntry = (MaterialReqBillEntryInfo)reversedSourceEntryMap.get(entryInfo.getSourceBillEntryId());
                    BigDecimal bigDecimal = realCountervail = sourceEntry.getReverseQty() == null ? sourceEntry.getQty().abs() : sourceEntry.getQty().abs().subtract(sourceEntry.getReverseQty());
                    if (entryInfo.getQty() == null || entryInfo.getQty().compareTo(realCountervail) <= 0) continue;
                    throw new InvBizException(InvBizException.OFFSETQTYGREATERTHANOLD, (Object[])new String[]{info.getNumber() + this.stringNo + entryInfo.getSeq() + this.stringRow});
                }
                BizTypeInfo bizTypeInfo = info.getBizType();
                if (bizTypeInfo == null || !"07SrlgEeEADgACsowKgSQiQHQ1w=".equals(bizTypeInfo.getId().toString()) || !this.getParameterValue(info.getStorageOrgUnit(), WRITEBAK_SCM_VOUCHER) || info.getEntry().size() <= 1) continue;
                throw new InvBizException(InvBizException.ENTRYROWNOTOVERONE, (Object[])new String[]{info.getNumber()});
            }
            if (this.batchAction.equals((Object)BatchActionEnum.AUDIT) || !this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) continue;
            if (info.getBizType() != null && info.getSourceBillType() != null && info.getBizType().getId().toString().equals("br1Lx8TrLlXgQKjAYj0acCQHQ1w=") && info.getSourceBillType().getId().toString().equals("EVuaJtWZ4kKbRG9czgLdmkY+1VI=")) {
                throw new InvBizException(InvBizException.CHECK_DIRECT_MATERIAL_MATERIALREQ_UNAUDIT);
            }
            MaterialReqBillEntryCollection billEntry = info.getEntry();
            StringBuffer submessage = new StringBuffer();
            boolean subcheck = false;
            for (int j = 0; j < billEntry.size(); ++j) {
                BigDecimal scQty = billEntry.get(j).getSubWrittenOffBaseQty();
                if (scQty == null || scQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
                submessage.append(ResourceBase.getString((String)resName, (String)"The", (Locale)this.ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)resName, (String)"Row", (Locale)this.ctx.getLocale()));
                subcheck = true;
            }
            if (!subcheck) continue;
            throw new InvBizException(InvBizException.CHECK_SUBWRITTENOFF_UNAUDIT, new Object[]{submessage});
        }
    }

    @Override
    protected boolean checkEntryCoreBillType(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        MaterialReqBillInfo billInfo = (MaterialReqBillInfo)aInvBillBaseInfo;
        MaterialReqBillEntryCollection collection = billInfo.getEntry();
        String CoreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            CoreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() == null || collection.get(i).getCoreBillType().getId() == null || collection.get(i).getCoreBillType().getId().toString().equals(CoreBillTypeid)) continue;
            return false;
        }
        return true;
    }

    private Map getReversedSourceEntry(MaterialReqBillInfo info) throws BOSException {
        MaterialReqBillEntryInfo entryInfo;
        HashMap<String, MaterialReqBillEntryInfo> result = new HashMap<String, MaterialReqBillEntryInfo>();
        if (info == null || !info.isIsReversed()) {
            return result;
        }
        MaterialReqBillEntryCollection entryCol = info.getEntry();
        HashSet<String> sourceEntryIdSet = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            entryInfo = entryCol.get(i);
            if (entryInfo.getSourceBillEntryId() == null) continue;
            sourceEntryIdSet.add(entryInfo.getSourceBillEntryId());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", sourceEntryIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection col = MaterialReqBillEntryFactory.getLocalInstance((Context)this.ctx).getCollection(entityViewInfo);
        if (col == null || col.size() == 0) {
            return result;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (MaterialReqBillEntryInfo)col.get(i);
            result.put(entryInfo.getId().toString(), entryInfo);
        }
        return result;
    }

    protected boolean getParameterValue(StorageOrgUnitInfo sou, String parameterName) throws EASBizException, BOSException {
        boolean value = false;
        String storageUnitID = sou.getId().toString();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(storageUnitID, 4, 1);
        CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)orgCol.get(0);
        if (companyOrgUnit != null && companyOrgUnit.getId() != null) {
            ParameterItem item = new ParameterItem(parameterName);
            value = item.getValueAsBoolean(this.ctx, (IObjectPK)new ObjectUuidPK(companyOrgUnit.getId()));
        }
        return value;
    }
}

