/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.materialreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.PurInWarehsServerutils;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvDefaultValueProcessor;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;

public class MaterialReqDefaultValueProcessor
extends InvDefaultValueProcessor {
    private static final long serialVersionUID = 1L;

    public MaterialReqDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MaterialReqDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public MaterialReqDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
        info.setNumber("104");
        return info;
    }

    @Override
    protected String getEntryName() {
        return "entry";
    }

    @Override
    protected void doProcess4Save(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Save(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        int len = collection.size();
        for (int i = 0; i < len; ++i) {
            MaterialReqBillInfo info = (MaterialReqBillInfo)collection.getObject(i);
            if (info.getPurchaseType() != null) continue;
            if (info.getSupplier() != null) {
                info.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
                continue;
            }
            info.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        }
    }

    @Override
    protected void doProcess4Submit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Submit(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        int len = collection.size();
        for (int i = 0; i < len; ++i) {
            int index;
            MaterialReqBillInfo info = (MaterialReqBillInfo)collection.getObject(i);
            if (info == null) continue;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)this.bosType));
                batchResults.replaceNewId(info.getId().toString());
            }
            if (info.getPurchaseType() == null) {
                if (info.getSupplier() != null) {
                    info.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
                } else {
                    info.setPurchaseType(PurchaseTypeEnum.PURCHASE);
                }
            }
            MaterialReqBillEntryCollection entrys = info.getEntry();
            for (int j = 0; j < entrys.size(); ++j) {
                MaterialReqBillEntryInfo entryInfo = entrys.get(j);
                if (entryInfo == null) continue;
                entryInfo.setUnReturnedBaseQty(entryInfo.getBaseQty().abs().subtract(entryInfo.getReturnBaseQty().abs()));
                if (info.getPurchaseType().equals((Object)PurchaseTypeEnum.SUBCONTRACT)) {
                    BigDecimal scWrittenOffAmount = entryInfo.getScWrittenOffAmount() == null ? BigDecimal.ZERO : entryInfo.getScWrittenOffAmount();
                    entryInfo.setScUnWrittenOffAmount(entryInfo.getActualCost().subtract(scWrittenOffAmount));
                }
                entryInfo.setSubWrittenOffQty(SysConstant.BIGZERO);
                entryInfo.setSubWrittenOffBaseQty(SysConstant.BIGZERO);
                entryInfo.setSubUnWriteOffQty(entryInfo.getQty());
                entryInfo.setSubUnWriteOffBaseQty(entryInfo.getBaseQty());
                if (entryInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
                    entryInfo.setUnitActualCost(BigDecimal.ZERO);
                    entryInfo.setActualCost(BigDecimal.ZERO);
                }
                if (entryInfo.getSourceBillEntryId() == null || entryInfo.getAssistUnit() == null || entryInfo.getMaterial() == null || entryInfo.getBaseQty() == null || entryInfo.getAssistQty() != null) continue;
                try {
                    entryInfo.setAssistQty(PurInWarehsServerutils.getAssUnitQty((Context)this.ctx, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)entryInfo.getMaterial(), (BigDecimal)entryInfo.getBaseQty()));
                    continue;
                }
                catch (BaseException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (info.getSupplyStoreOrgUnit() != null) {
                info.setSupplyCompanyOrgUnit(InvServerUtils.getCompanyInfoForStorage((Context)this.ctx, (StorageOrgUnitInfo)info.getSupplyStoreOrgUnit()));
            }
            if (info.getStorageOrgUnit() != null) {
                info.setDemandCompanyOrgUnit(InvServerUtils.getCompanyInfoForStorage((Context)this.ctx, (StorageOrgUnitInfo)info.getStorageOrgUnit()));
            }
            boolean flag = false;
            int size = entrys.size();
            for (index = 0; index < size; ++index) {
                MaterialReqBillEntryInfo entry = entrys.get(index);
                if (info.isIsReversed()) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            for (index = 0; index < entrys.size(); ++index) {
                MaterialReqBillEntryInfo entry = entrys.get(index);
                if (info.isIsReversed()) continue;
                if (entry.getCoreBillType() != null && entry.getCoreBillType().getId().toString().equals(info.getBillType().getId().toString())) {
                    entry.setCoreBillNumber(info.getNumber());
                    if (entry.getId() != null) {
                        entry.setCoreBillEntryID(entry.getId().toString());
                    }
                }
                if (entry.getCoreBillType() != null) continue;
                entry.setCoreBillEntrySe(index + 1);
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
                entry.setCoreBillType(billTypeInfo);
                entry.setCoreBillID(info.getId().toString());
                entry.setCoreBillNumber(info.getNumber());
                if (entry.getId() == null) continue;
                entry.setCoreBillEntryID(entry.getId().toString());
            }
        }
    }

    @Override
    protected void doProcess4Audit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Audit(batchResults);
    }

    @Override
    protected void doProcess4UnAudit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4UnAudit(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        StringBuffer idStr = new StringBuffer();
        int len = collection.size();
        for (int index = 0; index < len; ++index) {
            MaterialReqBillInfo info = (MaterialReqBillInfo)collection.getObject(index);
            if (info.isIsReversed()) continue;
            if (idStr.length() > 0) {
                idStr.append(",");
            }
            idStr.append("'").append(info.getId().toString()).append("'");
        }
        String[] updateSql = new String[2];
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_IM_MaterialReqBillEntry set FCOREBILLNUMBER = null,FCOREBILLENTRYSE = 0 ,FCOREBILLTYPEID = null,FCOREBILLID = null,FCOREBILLENTRYID= null ");
        sql.append(" where FCOREBILLTYPEID = '50957179-0105-1000-e000-0163c0a812fd463ED552' and fparentid in (" + idStr.toString() + ")");
        updateSql[0] = sql.toString();
        updateSql[1] = "UPDATE T_IM_MaterialReqBillEntry SET  FISAdmeasure = 0 where fparentid in (" + idStr.toString() + ")";
        KsqlUtil.executeBatch((Context)this.ctx, (String[])updateSql);
    }
}

