/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.materialrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvDefaultValueProcessor;

public class MaterialRequestBillDefaultValueProcessor
extends InvDefaultValueProcessor {
    private static final long serialVersionUID = 7365996021814087604L;

    public MaterialRequestBillDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MaterialRequestBillDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public MaterialRequestBillDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected BillTypeInfo getBillType() {
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"XlazxwEREADgAAAEwKgSxUY+1VI="));
        billTypeInfo.setNumber("XlazxwEREADgAAAEwKgSxUY+1VI=");
        return billTypeInfo;
    }

    @Override
    protected void doProcess4Submit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Submit(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int len = objCol.size();
        for (int index = 0; index < len; ++index) {
            MaterialRequestBillInfo info = (MaterialRequestBillInfo)objCol.getObject(index);
            MaterialRequestBillEntryCollection entryCol = info.getEntry();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                MaterialRequestBillEntryInfo entryInfo = entryCol.get(i);
                if (entryInfo.getApprovedBaseQty() == null) {
                    entryInfo.setApprovedBaseQty(SCMConstant.BIGDECIMAL_ZERO);
                }
                if (info.isIsReversed()) {
                    entryInfo.setAssociateQty(entryInfo.getApprovedBaseQty());
                    continue;
                }
                entryInfo.setAssociateQty(entryInfo.getApprovedBaseQty().abs());
            }
        }
    }

    @Override
    protected void doProcess4Save(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Save(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int len = objCol.size();
        for (int index = 0; index < len; ++index) {
            MaterialRequestBillInfo info = (MaterialRequestBillInfo)objCol.getObject(index);
            MaterialRequestBillEntryCollection entryCol = info.getEntry();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                MaterialRequestBillEntryInfo entryInfo = entryCol.get(i);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
        }
    }

    @Override
    protected void updateEntryFields(IObjectValue model) throws BOSException, EASBizException {
        super.updateEntryFields(model);
        MaterialRequestBillInfo info = (MaterialRequestBillInfo)model;
        MaterialRequestBillEntryCollection entryCol = info.getEntry();
        MaterialRequestBillEntryInfo entryInfo = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            if (entryInfo.getWarehouse() != null) continue;
            entryInfo.setLocation(null);
        }
    }
}

