/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PurInBeforePassAuditOrUnPassAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -6347400111227838941L;

    public PurInBeforePassAuditOrUnPassAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInBeforePassAuditOrUnPassAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurInBeforePassAuditOrUnPassAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        boolean isAudit;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            isAudit = true;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            isAudit = false;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)objCol.getObject(i);
            if (isAudit) {
                this.purinBeforePassAudit(info);
                continue;
            }
            this.purinBeforeUnPassAudit(info);
        }
    }

    protected void purinBeforePassAudit(PurInWarehsBillInfo info) throws BOSException, EASBizException {
        PurInWarehsBillInfo hsInfo = info;
        String updateDischargeType = "update T_IM_PurinwarehsBill set FDischargeType = {0} where FId = ''{1}''";
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.ctx);
        CompanyOrgUnitInfo company = hsInfo.getEntry().get(0).getCompanyOrgUnit();
        if (company != null) {
            String dischargeType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "SCM_CAL_001");
            if (dischargeType.equals("1") && hsInfo.isIsInitBill()) {
                dischargeType = "2";
            }
            String sSQL = MessageFormat.format(updateDischargeType, dischargeType, hsInfo.getId().toString());
            DbUtil.execute((Context)this.ctx, (String)sSQL);
        }
    }

    protected void purinBeforeUnPassAudit(PurInWarehsBillInfo info) throws BOSException {
        if (info.getPurchaseType() != null && PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> idList = new ArrayList<String>();
            PurInWarehsEntryInfo entryInfo = null;
            if (!info.isIsReversed()) {
                int size = info.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = info.getEntry().get(i);
                    if (entryInfo == null || entryInfo.getPurOrderEntry() == null || entryInfo.getSourceBillType() != null) continue;
                    idList.add(entryInfo.getId().toString());
                }
                if (idList != null && idList.size() > 0) {
                    StringBuffer ids = new StringBuffer();
                    int c = idList.size();
                    for (int i = 0; i < c; ++i) {
                        if (i > 0) {
                            ids.append(",");
                        }
                        ids.append("'");
                        ids.append(((String)idList.get(i)).toString());
                        ids.append("'");
                    }
                    sql.append("update T_IM_PurInwarehsEntry set FPurOrderID = null,FPurOrderNumber= null,FPurOrderEntryID = null,");
                    sql.append("FPurOrderEntrySeq = null,FCoreBillTypeID = null ");
                    sql.append("where fid in (").append(ids.toString()).append(")");
                    DbUtil.execute((Context)this.ctx, (String)sql.toString());
                }
            }
        }
    }

    protected String getCoreBillEntryId(Context ctx, InvBillBaseInfo info) {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)info;
        PurInWarehsEntryCollection col = billInfo.getEntry();
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getPurOrderEntry() == null) continue;
            inSql.append("'").append(col.get(i).getPurOrderEntry()).append("',");
        }
        if (inSql.length() > 0) {
            inSql.setLength(inSql.length() - 1);
            return inSql.toString();
        }
        return null;
    }

    protected Map<String, String> getCoreBillType(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)info;
        PurInWarehsEntryCollection col = billInfo.getEntry();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getCoreBillType() == null || col.get(i).getCoreBillType().getId() == null) continue;
            map.put(col.get(i).getCoreBillType().getId().toString(), col.get(i).getCoreBillType().getId().toString());
        }
        if (map.size() > 0) {
            return map;
        }
        return null;
    }
}

