/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.project.WBSTypeEnum;
import com.kingdee.eas.mm.project.app.WriteBackWBSFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;

public class PurInRewriteProjectTaskProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -2964954013376624206L;

    public PurInRewriteProjectTaskProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInRewriteProjectTaskProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurInRewriteProjectTaskProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        int opType = -1;
        if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            opType = 103;
        } else if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            opType = 109;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            PurInWarehsBillInfo aInvBillBaseInfo = (PurInWarehsBillInfo)vo;
            ObjectUuidPK pk = new ObjectUuidPK(aInvBillBaseInfo.getId().toString());
            IObjectPK[] pks = new IObjectPK[]{pk};
            this.writeBackQtyProductionOrderByAudit(this.ctx, aInvBillBaseInfo, pks, opType);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ASYNCHRONOUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List writeBackQtyProductionOrderByAudit(Context ctx, PurInWarehsBillInfo purInWarehsBillInfo, IObjectPK[] pks, int bizAction) throws BOSException, EASBizException {
        List errorId = null;
        if (purInWarehsBillInfo != null && purInWarehsBillInfo != null && purInWarehsBillInfo.getSourceBillType() != null && purInWarehsBillInfo.getSourceBillType().getId() != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equalsIgnoreCase(purInWarehsBillInfo.getSourceBillType().getId().toString())) {
            String tempTableName = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                StringBuffer sqlBuf = new StringBuffer();
                sqlBuf.append("CREATE TABLE ls (").append("FbaseQty NUMERIC(21,8) not null default 0,").append("FAuditTime DATETIME null,").append("FProjectID varchar(44) null,").append("FMaterialID varchar(44) null,").append("FTrackNumberID varchar(44) null, ").append("FBillID varchar(44) null, ").append("FStorageOrgUnitID varchar(44) null ").append(")");
                tempTableName = pool.createTempTable(sqlBuf.toString());
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
            try {
                StringBuffer idStrs = new StringBuffer();
                for (int i = 0; i < pks.length; ++i) {
                    idStrs.append("'" + pks[i] + "', ");
                }
                String idStr = idStrs.toString().trim().substring(0, idStrs.toString().trim().length() - 1);
                StringBuffer insertSql = new StringBuffer();
                insertSql.append("INSERT INTO ").append(tempTableName).append(" (FbaseQty,FAuditTime,FProjectID,FMaterialID,FTrackNumberID,FBillID,FStorageOrgUnitID) ").append(" SELECT E.FbaseQty,S.FAuditTime,E.FPROJECTID,E.FMaterialID,E.FTrackNumberID,S.FID,S.FStorageOrgUnitID FROM t_im_purinwarehsbill  S ").append(" INNER JOIN t_im_purinwarehsentry E").append(" ON E.FParentID=S.FID ").append(" AND S.FID IN ( ").append(idStr).append(" )");
                DbUtil.execute((Context)ctx, (String)insertSql.toString());
                WriteBackWBSFacadeControllerBean cb = new WriteBackWBSFacadeControllerBean();
                cb.batchWriteBackByQty(ctx, tempTableName, bizAction, WBSTypeEnum.PURCHASE);
            }
            finally {
                if (tempTableName != null) {
                    pool.releaseTable(tempTableName);
                }
            }
        }
        return errorId;
    }
}

