/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.project.WBSTypeEnum;
import com.kingdee.eas.mm.project.app.WriteBackWBSFacadeControllerBean;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;

public class PurInWriteBackProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -6312874291962151488L;

    public PurInWriteBackProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInWriteBackProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurInWriteBackProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BizActionEnum bizAction;
        IObjectCollection objCol = batchResults.getObjCollection();
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.AUDIT;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.UNAUDIT;
        } else {
            return;
        }
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance((Context)this.ctx);
        String billTypeId = "50957179-0105-1000-e000-015fc0a812fd463ED552";
        String tableName = BillTypeUtils.getBillEntryTableName((Context)this.ctx, (String)billTypeId);
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)objCol.getObject(i);
            IObjectPK[] pks = new IObjectPK[]{new ObjectStringPK(info.getId().toString())};
            iPurInWarehsBill.writeBackSupplierInvoice((IObjectValue)info, pks, BatchActionEnum.AUDIT.equals((Object)this.batchAction), false);
            this.writeBackQtyProductionOrderByAudit(info, pks, bizAction);
            if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)tableName, (String)info.getId().toString())) continue;
            this.writeBackTotalqty((IObjectValue)info, BatchActionEnum.AUDIT.equals((Object)this.batchAction));
        }
    }

    private boolean isReturnBiz(String bizTypeID) {
        boolean flag = false;
        if (bizTypeID.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=") || bizTypeID.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=") || bizTypeID.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            flag = true;
        }
        return flag;
    }

    private void writeBackTotalqty(IObjectValue model, boolean isAudit) throws BOSException {
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        String bizTypeID = info.getBizType().getId().toString();
        if (!this.isReturnBiz(bizTypeID)) {
            return;
        }
        String srcBillTypeID = null;
        String coreBillTypeID = null;
        if (info.getSourceBillType() != null && info.getSourceBillType().getId() != null) {
            srcBillTypeID = info.getSourceBillType().getId().toString();
        }
        HashSet<String> ids = new HashSet<String>();
        PurInWarehsEntryInfo entry = null;
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            entry = info.getEntry().get(i);
            ids.add(entry.getSourceBillEntryId());
            if (entry.getCoreBillType() == null) continue;
            coreBillTypeID = entry.getCoreBillType().getId().toString();
            ids.add(entry.getPurOrderEntry());
        }
        if (ids.size() <= 0) {
            return;
        }
        if (!"Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeID) && !"Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(srcBillTypeID)) {
            return;
        }
        String tranOrderEntryIds = InvServerUtils.getSqlIdsStrForColl(ids);
        String sign = " + ";
        if (!isAudit) {
            sign = " - ";
        } else if (isAudit && info.isIsReversed()) {
            sign = " + ";
        }
        StringBuffer writeBack = new StringBuffer();
        writeBack.append("update T_IM_TransferOrderBillEntry as t10 set (FTotalPurReturnQty,FTotalPurReturnBaseQty,FAssociateQty,FApAssociateBaseQty) = ( ");
        writeBack.append("  select isnull(t3.FTotalPurReturnQty, 0) ").append(sign).append(" t11.FTQty, ");
        writeBack.append("  isnull(t3.FTotalPurReturnBaseQty, 0) ").append(sign).append(" t11.FTBaseQty, ");
        writeBack.append("  isnull(t3.FTotalPurReturnBaseQty, 0) ").append(sign).append(" t11.FTBaseQty, ");
        writeBack.append("  case when (isnull(t3.FBaseQty,0) - isnull(t3.FPurInvoiceQty,0)) > 0 ");
        writeBack.append("    then (isnull(t3.FBaseQty,0) - isnull(t3.FPurInvoiceBaseQty,0)) ");
        writeBack.append("    else (isnull(t3.FTotalPurReturnBaseQty, 0) ").append(sign).append(" isnull(t11.FTBaseQty,0) - isnull(t3.FPurInvoiceBaseQty,0)) ");
        writeBack.append("  end ");
        writeBack.append("  from T_IM_TransferOrderBillEntry t3 inner join ( ");
        writeBack.append("    select t3.fid as FTID, sum(round(decimal(isnull(t1.FQty,0) * t5.FBaseConvsRate / t6.FBaseConvsRate ,21,8), t6.FQtyPrecision)) FTQty, sum(isnull(t1.FBaseQty,0)) FTBaseQty ");
        writeBack.append("    from T_IM_PurInWarehsEntry t1 ");
        writeBack.append("    inner join  T_IM_PurInWarehsBill t2 on t1.fparentid = t2.fid ");
        writeBack.append("    inner join  T_IM_TransferOrderBillEntry t3 on (t1.fsourcebillentryid = t3.fid or t1.FPurOrderEntryID = t3.fid) ");
        writeBack.append("    inner join t_bd_multimeasureunit t5 on t1.FMaterialID = t5.FMaterialID and t1.FUnitID = t5.fmeasureunitid ");
        writeBack.append("    inner join t_bd_multimeasureunit t6 on t3.FMaterialID = t6.FMaterialID and t3.FUnitID = t6.fmeasureunitid ");
        writeBack.append("    where t3.fid in (" + tranOrderEntryIds + ") and t2.fid = '" + info.getId().toString() + "' group by t3.fid ");
        writeBack.append("  ) t11 on t11.FTID =t3.fid ");
        writeBack.append("where t3.fid in (" + tranOrderEntryIds + ") and t3.fid = t10.fid)");
        DbUtil.execute((Context)this.ctx, (String)writeBack.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackQtyProductionOrderByAudit(PurInWarehsBillInfo purInWarehsBillInfo, IObjectPK[] pks, BizActionEnum bizAction) throws BOSException, EASBizException {
        if (purInWarehsBillInfo != null && purInWarehsBillInfo.getSourceBillType() != null && purInWarehsBillInfo.getSourceBillType().getId() != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equalsIgnoreCase(purInWarehsBillInfo.getSourceBillType().getId().toString())) {
            String tempTableName = null;
            TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
            try {
                StringBuffer sqlBuf = new StringBuffer();
                sqlBuf.append("CREATE TABLE ls (").append("FbaseQty NUMERIC(21,8) not null default 0,").append("FAuditTime DATETIME null,").append("FProjectID varchar(44) null,").append("FMaterialID varchar(44) null,").append("FTrackNumberID varchar(44) null, ").append("FBillID varchar(44) null, ").append("FStorageOrgUnitID varchar(44) null ").append(")");
                tempTableName = pool.createTempTable(sqlBuf.toString());
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
            try {
                StringBuffer idStrs = new StringBuffer();
                for (int i = 0; i < pks.length; ++i) {
                    idStrs.append("'" + pks[i] + "', ");
                }
                String idStr = idStrs.toString().trim().substring(0, idStrs.toString().trim().length() - 1);
                StringBuffer insertSql = new StringBuffer();
                insertSql.append("INSERT INTO ").append(tempTableName).append(" (FbaseQty,FAuditTime,FProjectID,FMaterialID,FTrackNumberID,FBillID,FStorageOrgUnitID) ").append(" SELECT E.FbaseQty,S.FAuditTime,E.FPROJECTID,E.FMaterialID,E.FTrackNumberID,S.FID,S.FStorageOrgUnitID FROM t_im_purinwarehsbill  S ").append(" INNER JOIN t_im_purinwarehsentry E").append(" ON E.FParentID=S.FID ").append(" AND S.FID IN ( ").append(idStr).append(" )");
                DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
                WriteBackWBSFacadeControllerBean cb = new WriteBackWBSFacadeControllerBean();
                cb.batchWriteBackByQty(this.ctx, tempTableName, bizAction.getValue(), WBSTypeEnum.PURCHASE);
            }
            finally {
                if (tempTableName != null) {
                    pool.releaseTable(tempTableName);
                }
            }
        }
    }
}

