/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purreceival;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.dt.CarryBillEntryFactory;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurReceivalBillWriteBackProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 5154330247659295953L;
    private static final Logger logger = LoggerFactory.getLogger(PurReceivalBillWriteBackProcessor.class);

    public PurReceivalBillWriteBackProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public PurReceivalBillWriteBackProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReceivalBillWriteBackProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        if (null == objCol || objCol.size() == 0) {
            return;
        }
        boolean isAudit = false;
        boolean isUnAudit = false;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            isAudit = true;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            isUnAudit = true;
        } else {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            PurReceivalBillInfo info = (PurReceivalBillInfo)objCol.getObject(i);
            this.updateCarryBill(isAudit, (IObjectCollection)info.getEntry());
            if (!isUnAudit) continue;
            this.updatePurReceivalBill(info.getId(), (IObjectValue)info);
        }
    }

    protected void updateCarryBill(boolean isAudit, IObjectCollection entryColl) throws BOSException, EASBizException {
        CarryBillEntryInfo carryEntryInfo = null;
        BillTypeInfo sourceBillType = null;
        PurReceivalEntryCollection entryCol = (PurReceivalEntryCollection)entryColl;
        PurReceivalEntryInfo entryInfo = null;
        for (int i = 0; i < entryCol.size(); ++i) {
            entryInfo = entryCol.get(i);
            sourceBillType = entryInfo.getSourceBillType();
            if (sourceBillType == null || !"190".equals(sourceBillType.getNumber())) continue;
            String carInfoIdStr = entryInfo.getSourceBillEntryId();
            carryEntryInfo = CarryBillEntryFactory.getLocalInstance((Context)this.ctx).getCarryBillEntryInfo("where id='" + carInfoIdStr + "'");
            BigDecimal associ = carryEntryInfo.getAssociateQty();
            BigDecimal associBase = carryEntryInfo.getReceiveAssoBaseQty();
            if (isAudit) {
                associ = carryEntryInfo.getAssociateQty().subtract(entryInfo.getQty());
                associBase = carryEntryInfo.getReceiveAssoBaseQty().subtract(entryInfo.getBaseQty());
            } else {
                associ = carryEntryInfo.getAssociateQty().add(entryInfo.getQty());
                associBase = carryEntryInfo.getReceiveAssoBaseQty().add(entryInfo.getBaseQty());
            }
            carryEntryInfo.setAssociateQty(associ);
            carryEntryInfo.setReceiveAssoBaseQty(associBase);
            CarryBillEntryFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(carryEntryInfo.getId()), (CoreBaseInfo)carryEntryInfo);
        }
    }

    private void updatePurReceivalBill(BOSUuid id, IObjectValue model) throws EASBizException, BOSException {
        PurReceivalBillInfo purReceivInfo;
        if (id == null && model == null) {
            return;
        }
        if (model == null) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("isReversed"));
            sc.add(new SelectorItemInfo("sourceBillType.id"));
            sc.add(new SelectorItemInfo("transactionType.id"));
            model = PurReceivalBillFactory.getLocalInstance((Context)this.ctx).getPurReceivalBillInfo((IObjectPK)new ObjectUuidPK(id), sc);
        }
        if ((purReceivInfo = (PurReceivalBillInfo)model) != null && purReceivInfo.getTransactionType() != null) {
            Statement st;
            Connection conn;
            block9: {
                conn = null;
                st = null;
                boolean needUpdate = false;
                StringBuffer sqlBuffer = new StringBuffer();
                try {
                    conn = EJBFactory.getConnection((Context)this.ctx);
                    st = conn.createStatement();
                    String purOrderID = purReceivInfo.getId().toString();
                    if (purReceivInfo.getSourceBillType() == null && !purReceivInfo.isIsReversed() && purReceivInfo.getEntry() != null) {
                        sqlBuffer.append("update T_IM_PurReceivalEntry set FIsRequestToReceived = 1");
                        sqlBuffer.append("where FParentID = '" + purOrderID + "'\r\n");
                        st.addBatch(sqlBuffer.toString());
                        needUpdate = true;
                    }
                    if (!purReceivInfo.isIsReversed()) {
                        sqlBuffer.setLength(0);
                        sqlBuffer.append("UPDATE T_IM_PurReceivalEntry SET FTofixAssetsQty = 0 ,FUnToFixAssetsQty = FQTY");
                        sqlBuffer.append(" WHERE FPARENTID ='").append(purOrderID).append("'");
                        st.addBatch(sqlBuffer.toString());
                        needUpdate = true;
                    }
                    if (!needUpdate) break block9;
                    st.executeBatch();
                }
                catch (SQLException ex) {
                    try {
                        logger.error("\u6267\u884csql\u51fa\u9519", (Throwable)ex);
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(st, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }
}

