/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purreceival;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvDefaultValueProcessor;
import java.math.BigDecimal;

public class PurReceivalDefaultValueProcessor
extends InvDefaultValueProcessor {
    private static final long serialVersionUID = -4257890611040711469L;

    public PurReceivalDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurReceivalDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReceivalDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    @Override
    protected void doProcess4Submit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Submit(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        this.setCheckQty(collection);
        this.setEntryStatus(collection, EntryBaseStatusEnum.SUBMITED);
    }

    @Override
    protected void doProcess4Save(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Save(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        this.setCheckQty(collection);
        this.setEntryStatus(collection, EntryBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void setEntryStatus(IObjectCollection collection, EntryBaseStatusEnum baseStatus) {
        int len = collection.size();
        for (int index = 0; index < len; ++index) {
            PurReceivalBillInfo info = (PurReceivalBillInfo)collection.getObject(index);
            PurReceivalEntryCollection entryCol = info.getEntry();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                entryCol.get(i).setBaseStatus(baseStatus);
            }
        }
    }

    private void setCheckQty(IObjectCollection collection) {
        PurReceivalBillInfo billInfo = null;
        PurReceivalEntryInfo entryInfo = null;
        PurReceivalEntryCollection entryCollection = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            billInfo = (PurReceivalBillInfo)collection.getObject(i);
            entryCollection = billInfo.getEntry();
            BigDecimal qty = null;
            BigDecimal baseQty = null;
            BigDecimal zero = new BigDecimal("0.00");
            if (billInfo.isIsReversed()) continue;
            int n = entryCollection.size();
            for (int j = 0; j < n; ++j) {
                entryInfo = entryCollection.get(j);
                qty = entryInfo.getQty();
                baseQty = entryInfo.getBaseQty();
                entryInfo.setCheckQty(zero);
                entryInfo.setCheckReturnedQty(zero);
                entryInfo.setUnCheckQty(qty);
                entryInfo.setCheckBaseQty(zero);
                entryInfo.setCheckReturnedBaseQty(zero);
                entryInfo.setUnCheckBaseQty(baseQty);
            }
        }
    }

    @Override
    protected BillTypeInfo getBillType() {
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0157c0a812fd463ED552"));
        billType.setNumber("101");
        return billType;
    }

    @Override
    protected boolean isEntryBlank(InvBillBaseEntryInfo entry) {
        RowTypeInfo rowType = ((PurReceivalEntryInfo)entry).getBillRowType();
        if (rowType != null && !DestinationTypeEnum.STORAGE.equals((Object)rowType.getDestinationType())) {
            return false;
        }
        return super.isEntryBlank(entry);
    }
}

