/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purreceival;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;

public class PurReceivalHandleCheckInfoProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 8418068764693900988L;

    public PurReceivalHandleCheckInfoProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public PurReceivalHandleCheckInfoProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReceivalHandleCheckInfoProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        boolean isAudit = false;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            isAudit = true;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            isAudit = false;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (null == objCol || objCol.size() == 0) {
            return;
        }
        if (isAudit) {
            this.autoCreateCheckInfo(objCol);
        } else {
            this.autoDeleteCheckInfo(objCol);
        }
    }

    private void autoCreateCheckInfo(IObjectCollection billCol) throws EASBizException, BOSException {
        String idStr = this.getIdStr(billCol);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into T_IM_PurReceivalEntryCheck (FID,FSeq,FParentID,FMaterialID,FMaterialName,FAssistPropertyID,FBaseUnitID,FUnitID,FAssistUnitID,");
        sql.append(" FQualifiedQty,FQualifiedBaseQty,FUnQualifiedQty,FUnQualifiedBaseQty,FConcessRecQty,FConcessRecBaseQty)");
        sql.append(" select NEWBOSID('74FDF032'),1,pre.FID,pre.FMaterialID,pre.FNoNummaterialName,pre.FAssistPropertyID,pre.FBaseUnitID,pre.FUnitID,pre.FAssistUnitID,");
        sql.append(" pre.FQualifiedQty,pre.FQualifiedBaseQty,pre.FUnQualifiedQty,pre.FUnQualifiedBaseQty,pre.FConcessiveRecQty,pre.FConcessiveRecBaseQty");
        sql.append(" from T_IM_PurReceivalEntry pre");
        sql.append(" inner join T_IM_PurReceivalBill pr on pr.FID=pre.FParentID");
        sql.append(" inner join T_SCM_TransactionType tt on tt.FID=pr.FTransactionTypeID");
        sql.append(" left join T_BD_MaterialPurchasing mp on pre.FMaterialID = mp.FMaterialID and pre.fpurchaseorgunitid = mp.forgunit ");
        sql.append(" where pr.FID in ( ").append(idStr).append(" )");
        sql.append(" and pr.FIsReversed=0");
        sql.append(" and tt.FRITypeID <> '").append(RecIssueTypeConstant.CHECKRT_RITYPEID).append("' ");
        sql.append(" and (pre.FIsCheck = 0 or ");
        sql.append(" (pre.FIsCheck = 1 and pre.FIsUrgentPass = 1 and isNull(mp.Ffinequalityfairprice,0) = 0)) ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void autoDeleteCheckInfo(IObjectCollection billCol) throws EASBizException, BOSException {
        String idStr = this.getIdStr(billCol);
        StringBuilder sql = new StringBuilder();
        sql.append("delete from T_IM_PurReceivalEntryCheck che");
        sql.append(" where che.FParentID in ");
        sql.append(" (select pre.fid from T_IM_PurReceivalEntry pre ");
        sql.append(" left join T_BD_MaterialPurchasing mp on pre.FMaterialID = mp.FMaterialID and pre.fpurchaseorgunitid = mp.forgunit ");
        sql.append(" where pre.FParentID in ( ").append(idStr).append(" ) ");
        sql.append(" and (pre.FIsCheck = 0 or ");
        sql.append(" (pre.FIsCheck = 1 and pre.FIsUrgentPass = 1 and isNull(mp.Ffinequalityfairprice, 0) = 0))) ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getIdStr(IObjectCollection objCol) {
        StringBuilder sb = new StringBuilder();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = objCol.getObject(i);
            sb.append("'").append(vo.get("id").toString()).append("',");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

