/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvBizDataCheckProcessor;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;

public class SaleIssueBizDataCheckProcessor
extends InvBizDataCheckProcessor {
    private static final long serialVersionUID = 1L;

    public SaleIssueBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleIssueBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    public SaleIssueBizDataCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        BatchExecuteParamsEntry[] collection = batchResults.getParamEntries();
        if (collection == null || collection.length <= 0) {
            return;
        }
        int size = collection.length;
        for (int i = 0; i < size; ++i) {
            SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)collection[0].toArray()[i];
            if (saleIssueBillInfo == null || !this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) continue;
            CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.companyMap.get(saleIssueBillInfo.getStorageOrgUnit().getId().toString());
            if (cou == null) {
                throw new InvBizException(InvBizException.STORAGEORGNOTHASCOMPANYORG, (Object[])new String[]{saleIssueBillInfo.getNumber()});
            }
            if (!this.isConsignmentBizType((InvBillBaseInfo)saleIssueBillInfo)) continue;
            this.checkBizConsignment(this.ctx, saleIssueBillInfo);
        }
    }

    @Override
    protected boolean checkEntryCoreBillType(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
        SaleIssueEntryCollection collection = billInfo.getEntry();
        String CoreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            CoreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() != null && collection.get(i).getCoreBillType().getId() != null && !collection.get(i).getCoreBillType().getId().toString().equals(CoreBillTypeid)) {
                return false;
            }
            if (collection.get(i).getCoreBillType() != null || CoreBillTypeid == null) continue;
            return false;
        }
        return true;
    }

    private void checkBizConsignment(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws EASBizException, BOSException {
        if (null == saleIssueBillInfo || null == saleIssueBillInfo.getTransactionType()) {
            return;
        }
        boolean isConsOut = this.isConsOutSaleIssueBill(ctx, (InvBillBaseInfo)saleIssueBillInfo);
        boolean isConsRt = this.isConsRtSaleIssueBill(ctx, (InvBillBaseInfo)saleIssueBillInfo);
        boolean isConsSettled = this.isConsSettleCreateToSaleIssueBill(ctx, (InvBillBaseInfo)saleIssueBillInfo);
        if (isConsOut) {
            SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                SaleIssueEntryInfo entryInfo = entryCol.get(i);
                if (entryInfo == null || entryInfo.getCoreBillType() != null) continue;
                throw new InvBizException(InvBizException.NOT_SUPPORT_MANUAL_CONSIGNMENT);
            }
        }
        boolean isInvUpdateByARBill = false;
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.companyMap.get(saleIssueBillInfo.getStorageOrgUnit().getId().toString());
        String isInvUpdateByARBillStr = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(cou.getId()), "CONSIGNSALES");
        if (!StringUtils.isEmpty((String)isInvUpdateByARBillStr) && "true".equalsIgnoreCase(isInvUpdateByARBillStr.trim())) {
            isInvUpdateByARBill = true;
        }
        if (isInvUpdateByARBill) {
            if (isConsOut || isConsRt) {
                throw new InvBizException(InvBizException.ISUPDATEBYARBILL_FOR_CONSIGNMENT_ISSUE);
            }
        } else {
            if (isConsRt && saleIssueBillInfo.getSourceBillType() == null) {
                throw new InvBizException(InvBizException.CONSRT_NOT_MANUALADD);
            }
            if (!saleIssueBillInfo.isIsInitBill() && isConsSettled) {
                throw new InvBizException(InvBizException.ISUPDATEBYARBILL_FOR_CONSIGNMENT_ISSUE_SETTLED);
            }
        }
    }

    private boolean isConsOutSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        String riTypeID;
        boolean isConsOut = false;
        if (this.isConsignmentBizType(invBillBaseInfo) && invBillBaseInfo.getTransactionType().getRiType() != null && RecIssueTypeConstant.CONSIGNOUT_RITYPEID.equals(riTypeID = invBillBaseInfo.getTransactionType().getRiType().getId().toString())) {
            isConsOut = true;
        }
        return isConsOut;
    }

    private boolean isConsRtSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        String riTypeID;
        boolean isConsRt = false;
        if (this.isConsignmentBizType(invBillBaseInfo) && invBillBaseInfo.getTransactionType().getRiType() != null && RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(riTypeID = invBillBaseInfo.getTransactionType().getRiType().getId().toString())) {
            isConsRt = true;
        }
        return isConsRt;
    }

    private boolean isConsSettleCreateToSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        boolean isConsSettleSaleIssueBill = false;
        if (this.isConsignmentBizType(invBillBaseInfo) && invBillBaseInfo.getSourceBillType() != null && invBillBaseInfo.getTransactionType().getRiType() != null) {
            String riTypeID = invBillBaseInfo.getTransactionType().getRiType().getId().toString();
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(invBillBaseInfo.getSourceBillType().getId().toString()) && RecIssueTypeConstant.SALEOUT_RITYPEID.equals(riTypeID)) {
                isConsSettleSaleIssueBill = true;
            }
        }
        return isConsSettleSaleIssueBill;
    }

    private boolean isConsignmentBizType(InvBillBaseInfo invBillBaseInfo) {
        boolean isConsignmentBizType = false;
        if (invBillBaseInfo != null && invBillBaseInfo.getTransactionType() != null && invBillBaseInfo.getBizType() != null && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(invBillBaseInfo.getBizType().getId().toString())) {
            isConsignmentBizType = true;
        }
        return isConsignmentBizType;
    }
}

