/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class UpdateSourceBillStatusProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -1668248337808930459L;

    public UpdateSourceBillStatusProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public UpdateSourceBillStatusProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public UpdateSourceBillStatusProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        assert (batchResults != null);
        assert (batchResults.getObjCollection() != null);
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction) && !BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            this.setSourceBillStatus(this.ctx, objCol.getObject(i));
        }
    }

    private void setSourceBillStatus(Context ctx, IObjectValue model) throws BOSException {
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)"T_IM_SaleIssueEntry") && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)"T_IM_SaleIssueEntry", (String)info.getId().toString())) {
            return;
        }
        if (info.getEntry().get(0).getSourceBillId() == null) {
            return;
        }
        String bizTypeID = info.getBizType().getId().toString();
        if (bizTypeID.equals("d8e80652-0114-1000-e000-04c5c0a812202407435C") && info.getTransactionType().getRiType() != null && info.getTransactionType().getRiType().getId().toString().equals(RecIssueTypeConstant.CONSIGNRT_RITYPEID) && !"50957179-0105-1000-e008-8152c0a812fd463ED552".equals(info.getSourceBillType().getId().toString())) {
            StringBuffer sql = new StringBuffer();
            if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
                sql.append(" update T_IM_SaleIssueEntry set funsettleqty = 0,funsettlebaseqty= 0 ");
                sql.append(" where fparentid = '" + info.getId().toString() + "'");
            } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
                sql.append(" update T_IM_SaleIssueEntry set funsettleqty = fqty,funsettlebaseqty= fbaseQty ");
                sql.append(" where fparentid = '" + info.getId().toString() + "'");
            }
            if (sql.length() > 0) {
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        if (!(bizTypeID.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=") || bizTypeID.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=") || bizTypeID.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w="))) {
            return;
        }
        ArrayList<String> closeList = new ArrayList<String>();
        ArrayList<String> auditList = new ArrayList<String>();
        ArrayList<String> coreIDList = new ArrayList<String>();
        SaleIssueEntryInfo entryInfo = null;
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo == null) continue;
            if (info.isIsReversed()) {
                coreIDList.add(entryInfo.getSaleOrder());
                continue;
            }
            coreIDList.add(entryInfo.getSourceBillId());
        }
        if (coreIDList == null || coreIDList.size() <= 0) {
            return;
        }
        String ids = InvServerUtils.getInStringFromList(coreIDList);
        StringBuffer str = new StringBuffer();
        str.append(" select t2.fid as fid , ");
        str.append(" case when ");
        str.append("  (t2.FTotalSaleReturnBaseQty <= round(decimal( t2.FBaseQty * round(decimal(1 - ISNULL(t2.FQtyLackRate,0)/100,21,8),4) ,21,8) ,b.FQtyPrecision)  ");
        str.append("  and t2.FTotalPurReturnBaseQty <= round(decimal( t2.FBaseQty * round(decimal(1 - ISNULL(t2.FQtyLackRate,0)/100,21,8),4) ,21,8) ,b.FQtyPrecision) )");
        str.append("  then '1' ");
        str.append("  else '2'  end  as isClose ");
        str.append("  from T_IM_TransferOrderBillEntry t2 inner join  T_IM_TransferOrderBill t1 on t1.fid = t2.fparentid ");
        str.append("inner join t_bd_multimeasureunit b on t2.fmaterialid = b.fmaterialid and t2.fbaseunitid = b.fmeasureunitid ");
        str.append("  where t1.fid in ").append(ids);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rs.next()) {
                String isClose = rs.getString("isClose");
                String fid = rs.getString("fid");
                if (isClose.equals("1")) {
                    closeList.add(fid);
                    continue;
                }
                auditList.add(fid);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String auditids = InvServerUtils.getInStringFromList(auditList);
        String coloseids = InvServerUtils.getInStringFromList(closeList);
        if (auditids != null && auditids.length() > 0) {
            String str2 = "UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE FBaseStatus = 7 AND FID in " + auditids;
            String str4 = "UPDATE T_IM_TransferOrderBill SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID in " + ids;
            DbUtil.execute((Context)ctx, (String)str2);
            DbUtil.execute((Context)ctx, (String)str4);
        } else {
            String str3 = "UPDATE T_IM_TransferOrderBill SET FBaseStatus = 7  WHERE FID in " + ids;
            DbUtil.execute((Context)ctx, (String)str3);
        }
        if (coloseids != null && coloseids.length() > 0) {
            String str1 = "UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 7  WHERE FID in " + coloseids;
            DbUtil.execute((Context)ctx, (String)str1);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_IM_TransferOrderBill set fbasestatus = ").append(7);
        sql.append(" where fid in ").append(ids);
        sql.append(" and fid not in (select fparentid from T_IM_TransferOrderBillEntry where fbasestatus<>7 and fparentid in");
        sql.append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

