/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WriteDiffQty2SaleOrderProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -1844950401961289905L;
    protected static final Logger logger = Logger.getLogger(WriteDiffQty2SaleOrderProcessor.class);

    public WriteDiffQty2SaleOrderProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public WriteDiffQty2SaleOrderProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public WriteDiffQty2SaleOrderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        assert (batchResults != null);
        assert (batchResults.getObjCollection() != null);
        boolean isAudit = false;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            isAudit = true;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            isAudit = false;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)"t_im_saleissueentry") && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)"t_im_saleissueentry", (String)objCol.getObject(i).get("id").toString())) continue;
            this.writeDiffQty2CoreBillSaleOrder(this.ctx, objCol.getObject(i), isAudit);
        }
    }

    protected void writeDiffQty2CoreBillSaleOrder(Context ctx, IObjectValue model, boolean isAudit) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        if (info.getSourceBillType() == null || !"510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(info.getSourceBillType().getId().toString())) {
            return;
        }
        if (info.getEntry() == null) {
            return;
        }
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            String paramValue;
            if (info.getEntry().get(i) == null || info.getEntry().get(i).getSaleOrgUnit() == null) continue;
            String saleOrgUnitID = info.getEntry().get(i).getSaleOrgUnit().getId().toString();
            String string = paramValue = paramValueMap.get(saleOrgUnitID) != null ? ((String)paramValueMap.get(saleOrgUnitID)).toString() : ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrgUnitID), (String)"SALEORDER005");
            if (Boolean.valueOf(paramValue).booleanValue()) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'").append(info.getEntry().get(i).getId().toString()).append("'");
            }
            paramValueMap.put(saleOrgUnitID, paramValue);
        }
        if (ids.length() < 1) {
            return;
        }
        if (StringUtil.isEmpty((String)ids.toString())) {
            return;
        }
        Connection con = null;
        PreparedStatement updatePstmt = null;
        IRowSet rs = null;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select (case\n");
        selectSql.append("         when pre.fqty < pre.fshippedqty - sie.fqty then\n");
        selectSql.append("          sie.fqty\n");
        selectSql.append("         when pre.fqty < pre.fshippedqty then\n");
        selectSql.append("          pre.fshippedqty-pre.fqty\n");
        selectSql.append("       end) diffQty,\n");
        selectSql.append("       (case\n");
        selectSql.append("         when pre.fbaseqty < pre.fshippedbaseqty - sie.fbaseqty then\n");
        selectSql.append("          sie.fbaseqty\n");
        selectSql.append("         when pre.fbaseqty < pre.fshippedbaseqty then\n");
        selectSql.append("          pre.fshippedbaseqty-pre.fbaseqty\n");
        selectSql.append("       end) diffBaseQty,\n");
        selectSql.append("       mu.FBaseConvsRate FBaseConvsRate, sie.fsaleorderentryid FID\n");
        selectSql.append("  from t_im_saleissuebill si ");
        selectSql.append(" inner join t_im_saleissueentry sie on sie.fparentid = si.fid\n");
        selectSql.append(" inner join t_sd_saleorderentry soe on sie.fsaleorderentryid = soe.fid\n");
        selectSql.append(" inner join t_sd_postrequisitionentry pre on pre.fid =\n");
        selectSql.append("                                             sie.fsourcebillentryid\n");
        selectSql.append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ");
        selectSql.append(" where si.FIsReversed=0 and sie.fid in(").append(ids).append(")");
        String updateSql = "update t_sd_saleorderentry set FTotalUnIssueQty = FTotalUnIssueQty+?, FTotalUnIssueBaseQty = FTotalUnIssueBaseQty+? where FID = ?";
        try {
            con = EJBFactory.getConnection((Context)ctx);
            updatePstmt = con.prepareStatement(updateSql);
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                do {
                    BigDecimal diffQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("diffQty")).abs();
                    BigDecimal diffBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("diffBaseQty")).abs();
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    diffQty = diffBaseQty.divide(baseConvsRate, diffQty.scale(), 4);
                    updatePstmt.setBigDecimal(1, isAudit ? diffQty.negate() : diffQty);
                    updatePstmt.setBigDecimal(2, isAudit ? diffBaseQty.negate() : diffBaseQty);
                    updatePstmt.setString(3, rs.getString("FID"));
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, updatePstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)updatePstmt, (Connection)con);
    }
}

