/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.stockreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.StockReqEntryCollection;
import com.kingdee.eas.scm.im.inv.StockReqEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;

public class StockReqDefaultValueProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -5700549281093334714L;
    private static final String[] ENTRY_DECIMAL_FIELDS = new String[]{"qty", "baseQty", "auditQty", "auditBaseQty", "assistQty", "totalStockQty", "totalStockBaseQty"};

    public StockReqDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public StockReqDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public StockReqDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI="));
        info.setNumber("170");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected String getEntryName() {
        return "entry";
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection col = batchResults.getObjCollection();
        if (col == null || col.size() <= 0) {
            return;
        }
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
            this.doProcess4Save(col);
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            this.doProcess4Submit(col);
        } else if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            this.doProcess4Audit(col);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            // empty if block
        }
    }

    protected void doProcess4Submit(IObjectCollection col) {
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            StockReqInfo billInfo = (StockReqInfo)col.getObject(index);
            if (billInfo.getBillType() == null) {
                BillTypeInfo aBillTypeInfo = new BillTypeInfo();
                aBillTypeInfo.setId(BOSUuid.read((String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI="));
                aBillTypeInfo.setNumber("170");
                billInfo.setBillType(aBillTypeInfo);
            }
            StockReqEntryCollection entrys = billInfo.getEntry();
            StockReqEntryInfo entry = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entry = entrys.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                if (entry.getAssistQty() != null) continue;
                entry.setAssistQty(new BigDecimal("0.00"));
            }
            this.setNULLToZERO(billInfo);
        }
    }

    protected void doProcess4Save(IObjectCollection col) {
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            StockReqInfo billInfo = (StockReqInfo)col.getObject(index);
            StockReqEntryCollection entrys = billInfo.getEntry();
            StockReqEntryInfo entry = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entry = entrys.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
            this.setNULLToZERO(billInfo);
        }
    }

    protected void doProcess4Audit(IObjectCollection col) throws BOSException {
        if (CollectionUtil.isEmpty((IObjectCollection)col)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Update T_IM_StockReqEntry SET FAssociateQty = FAuditBaseQty");
        sql.append(" WHERE FParentID in ( '8888'");
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            StockReqInfo billInfo = (StockReqInfo)col.getObject(index);
            sql.append(", '").append(billInfo.getId().toString()).append("'");
        }
        sql.append(")");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void setNULLToZERO(StockReqInfo info) {
        if (info.getEntry() == null) {
            return;
        }
        for (int i = 0; i < info.getEntry().size(); ++i) {
            StockReqEntryInfo entry = info.getEntry().get(i);
            for (int j = 0; j < ENTRY_DECIMAL_FIELDS.length; ++j) {
                if (entry.get(ENTRY_DECIMAL_FIELDS[j]) != null) continue;
                entry.put(ENTRY_DECIMAL_FIELDS[j], (Object)SCMConstant.BIGDECIMAL_ZERO);
            }
            if (info.getSourceBillType() != null || entry.getId() == null) continue;
            entry.setOriginalEntryId(entry.getId().toString());
        }
    }
}

