/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.stocktransfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import java.math.BigDecimal;

public class StockTransferBillDefaultValueProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -5700549281093334714L;
    private static final String[] headFields = new String[0];
    private static final String[] fields = new String[]{"assistQty"};
    private static final String[] subFields = new String[]{"discountAmount", "tax", "discountRate", "taxRate", "totalIssueQty", "quarityOverRate", "quarityArreRate", "price"};

    public StockTransferBillDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public StockTransferBillDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public StockTransferBillDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        info.setNumber("140");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected String getEntryName() {
        return "entry";
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection col = batchResults.getObjCollection();
        if (col == null || col.size() <= 0) {
            return;
        }
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
            this.doProcess4Save(col);
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            this.doProcess4Submit(col);
        } else if (BatchActionEnum.AUDIT.equals((Object)this.batchAction) || BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            // empty if block
        }
    }

    protected void doProcess4Submit(IObjectCollection col) {
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            StockTransferBillInfo billInfo = (StockTransferBillInfo)col.getObject(index);
            billInfo.setReceiptCompanyOrgUnit(billInfo.getIssueCompanyOrgUnit());
            if (billInfo.getBillType() == null) {
                BillTypeInfo aBillTypeInfo = new BillTypeInfo();
                aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
                billInfo.setBillType(aBillTypeInfo);
            }
            StockTransferBillEntryCollection entrys = billInfo.getEntry();
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                StockTransferBillEntryInfo entry = entrys.get(i);
                if (entry.getIssueStorageOrgUnit() == null) {
                    entry.setIssueStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
                }
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                if (entry.getAssistQty() == null) {
                    entry.setAssistQty(new BigDecimal("0.00"));
                }
                entry.setUnIssueBaseQty(entry.getBaseQty());
                entry.setArAssociateBaseQty(entry.getBaseQty());
                entry.setApAssociateBaseQty(entry.getBaseQty());
            }
            this.setNULLToZERO(billInfo);
        }
    }

    protected void doProcess4Save(IObjectCollection col) {
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            StockTransferBillInfo billInfo = (StockTransferBillInfo)col.getObject(index);
            StockTransferBillEntryCollection entrys = billInfo.getEntry();
            StockTransferBillEntryInfo entry = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entry = entrys.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                entry.setUnIssueBaseQty(entry.getBaseQty());
                entry.setArAssociateBaseQty(entry.getBaseQty());
                entry.setApAssociateBaseQty(entry.getBaseQty());
            }
            this.setNULLToZERO(billInfo);
        }
    }

    private void setNULLToZERO(StockTransferBillInfo billInfo) {
        BigDecimal ZERO = new BigDecimal("0.00");
        int headSize = headFields.length;
        for (int i = 0; i < headSize; ++i) {
            if (billInfo.get(headFields[i]) != null) continue;
            billInfo.setBigDecimal(headFields[i], ZERO);
        }
        StockTransferBillEntryCollection entrys = billInfo.getEntry();
        StockTransferBillEntryInfo entry = null;
        if (entrys != null) {
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                int j;
                entry = entrys.get(i);
                for (j = 0; j < fields.length; ++j) {
                    if (entry.get(fields[j]) != null) continue;
                    entry.setBigDecimal(fields[j], ZERO);
                }
                for (j = 0; j < subFields.length; ++j) {
                    if (!entry.containsKey(subFields[j]) || entry.get(subFields[j]) != null) continue;
                    entry.setBigDecimal(subFields[j], ZERO);
                }
            }
        }
    }
}

