/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.app.AbstractBizCheckFacadeControllerBean;
import com.kingdee.eas.scm.nsrm.app.frombiz.ISendFromBizService;
import com.kingdee.eas.scm.nsrm.app.frombiz.SendFromBizUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCheckFacadeControllerBean
extends AbstractBizCheckFacadeControllerBean {
    private static final long serialVersionUID = 6663243651019112301L;
    private static Logger logger = Logger.getLogger(BizCheckFacadeControllerBean.class);

    @Override
    protected void _checkPurOrderUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            StringBuffer sql = new StringBuffer();
            String tableField = "CFSrmProgress";
            sql.append("select FID,FNumber,CFAutoConfirm,").append(tableField).append(" from T_SM_PurOrder where (").append(tableField).append(" is not null and ").append(tableField).append(" != ").append("0").append(" and ").append(tableField).append(" != ").append("1").append(") ").append(" and FID ='").append(pk).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    int anInt = rs.getInt(tableField);
                    int cfAutoConfirm = rs.getInt("CFAutoConfirm");
                    if (anInt == 4 && cfAutoConfirm == 1) {
                        return;
                    }
                    throw new NSRMBizException(NSRMBizException.ORDER_NOTAUDIT);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _checkPurInwarehsOrReturnSend(Context ctx, IObjectPK pk, String operateType) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        PurInWarehsBillCollection infoCol = (PurInWarehsBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(evi);
        PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)infoCol.getObject(0);
        ISendFromBizService iSend = SendFromBizUtil.getInstance();
        boolean isSrm = Boolean.valueOf(purInWarehsBillInfo.getSupplier().get("isSrm").toString());
        if (!isSrm) {
            return;
        }
        if (purInWarehsBillInfo.getTransactionType().getRiType().getRI().getValue() == 1 && purInWarehsBillInfo.getTransactionType().getRiType().getBizDirection().getValue() == 1) {
            this.PurInwarehsOperate(ctx, pk, operateType, iSend);
        } else {
            this.PurIERPReturnOperate(ctx, pk, operateType, iSend);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM004", cu);
        if ("1".equals(paramValue)) {
            this.PurOrderSyncOperate(ctx, purInWarehsBillInfo, iSend);
        }
    }

    public void PurOrderSyncOperate(Context ctx, PurInWarehsBillInfo purInWarehsBillInfo, ISendFromBizService iSend) throws EASBizException, BOSException {
        if (null != purInWarehsBillInfo) {
            PurInWarehsEntryCollection col = purInWarehsBillInfo.getEntry();
            PurInWarehsEntryInfo entry = null;
            HashSet<String> puridSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                entry = col.get(i);
                if (entry.getSourceBillType() != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(entry.getSourceBillType().getId().toString())) {
                    puridSet.add(entry.getSourceBillId());
                    continue;
                }
                if (entry.getCoreBillType() == null || !"510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(entry.getCoreBillType().getId().toString())) continue;
                puridSet.add(entry.getPurOrder());
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("srmProgress"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("id"));
            filter.getFilterItems().add(new FilterItemInfo("id", puridSet, CompareType.INCLUDE));
            evi.setFilter(filter);
            evi.setSelector(sic);
            PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
            HashMap<String, Object> orderMap = new HashMap<String, Object>();
            for (int i = 0; i < purOrderCollection.size(); ++i) {
                orderMap.put(purOrderCollection.get(i).getId().toString(), purOrderCollection.get(i).get("srmProgress"));
            }
            puridSet.clear();
            for (String orderID : orderMap.keySet()) {
                Object srmPorgress = orderMap.get(orderID);
                CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
                boolean issync = true;
                if (null == srmPorgress || "0".equals(srmPorgress) || "3".equals(srmPorgress)) {
                    issync = false;
                }
                if ((!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
                puridSet.add(orderID);
            }
            if (puridSet.size() > 0) {
                iSend.send(ctx, "EAS_PurOrder_Sync_Send", puridSet, false);
            }
        }
    }

    public void PurInwarehsOperate(Context ctx, IObjectPK pk, String operate, ISendFromBizService iSend) throws EASBizException, BOSException {
        Set<String> ids = this.getvirBillId(ctx, pk.toString());
        if ("audit".equals(operate)) {
            if (ids.size() > 0) {
                iSend.send(ctx, "EAS_PurInWarehsBill_Sync_Send", ids, false);
            } else {
                iSend.send(ctx, "EAS_PurInWarehsBill_Sync_Send", pk, false);
            }
        } else if (ids.size() > 0) {
            iSend.send(ctx, "EAS_PurInWarehsBill_Del_Send", ids, false);
        } else {
            iSend.send(ctx, "EAS_PurInWarehsBill_Del_Send", pk, false);
        }
    }

    public void PurIERPReturnOperate(Context ctx, IObjectPK pk, String operate, ISendFromBizService iSend) throws EASBizException, BOSException {
        Set<String> ids = this.getvirBillId(ctx, pk.toString());
        if ("audit".equals(operate)) {
            if (ids.size() > 0) {
                iSend.send(ctx, "EAS_IerpPurReturns_Sync_Send", ids, false);
            } else {
                iSend.send(ctx, "EAS_IerpPurReturns_Sync_Send", pk, false);
            }
        } else if (ids.size() > 0) {
            iSend.send(ctx, "EAS_IerpPurReturns_Del_Send", ids, false);
        } else {
            iSend.send(ctx, "EAS_IerpPurReturns_Del_Send", pk, false);
        }
    }

    @Override
    protected void _checkIsAllowUnAduit(Context ctx, IObjectPK pk, String orderName) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("synStatus"));
        sic.add(new SelectorItemInfo("entry.isContrastDrew"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        if (orderName.equals("purInwrehs")) {
            this.checkIsAllowInwUnAudit(ctx, pk, evi);
        } else if (orderName.equals("purRecival")) {
            this.checkIsAllowRecUnAudit(ctx, pk, evi);
        }
    }

    private void checkIsAllowRecUnAudit(Context ctx, IObjectPK pk, EntityViewInfo evi) throws BOSException {
        PurReceivalBillCollection purReceivalBillCollection = PurReceivalBillFactory.getLocalInstance((Context)ctx).getPurReceivalBillCollection(evi);
        if (purReceivalBillCollection == null || purReceivalBillCollection.size() <= 0) {
            return;
        }
        PurReceivalBillInfo info = purReceivalBillCollection.get(0);
        if (info.get("synStatus") != null && "0".equals(info.get("synStatus").toString())) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.nsrm.NSRMBizResource", (String)"MSG_NOT_UNAUDIT", (Locale)ctx.getLocale()));
        }
        for (PurReceivalEntryInfo next : info.getEntries()) {
            if (next.get("isContrastDrew") == null || !((Boolean)next.get("isContrastDrew")).booleanValue()) continue;
            throw new BOSException("\u5df2\u5bf9\u8d26\u5f00\u7968");
        }
    }

    public Set<String> getvirBillId(Context ctx, String pk) throws BOSException {
        HashSet<String> virIdSet = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurInWarehsEntryCollection entryCol = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        PurInWarehsEntryInfo entryInfo = null;
        for (int i = 0; i < entryCol.size(); ++i) {
            entryInfo = entryCol.get(i);
            idSet.add(entryInfo.getId().toString());
        }
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("parent.id"));
        filter1.getFilterItems().add(new FilterItemInfo("SOURCEBILLENTRYID", (Object)((Object)idSet).toString(), CompareType.INCLUDE));
        filter1.getFilterItems().add(new FilterItemInfo("parent.isSysBill", (Object)1, CompareType.EQUALS));
        evi1.setFilter(filter1);
        evi1.setSelector(sic1);
        PurInWarehsEntryCollection purInWarehsEntryCollection = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(evi1);
        HashSet<String> newIdSet = new HashSet<String>();
        for (int i = 0; i < purInWarehsEntryCollection.size(); ++i) {
            PurInWarehsEntryInfo entry = purInWarehsEntryCollection.get(i);
            newIdSet.add(entry.getParent().getId().toString());
        }
        EntityViewInfo newEvi = new EntityViewInfo();
        FilterInfo newFilter = new FilterInfo();
        SelectorItemCollection newSic = new SelectorItemCollection();
        newSic.add(new SelectorItemInfo("number"));
        newSic.add(new SelectorItemInfo("id"));
        newSic.add(new SelectorItemInfo("supplier.id"));
        newSic.add(new SelectorItemInfo("entry.sourceBillId"));
        newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)((Object)newIdSet).toString(), CompareType.INCLUDE));
        newEvi.setFilter(newFilter);
        newEvi.setSelector(newSic);
        PurInWarehsBillCollection col = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillCollection(newEvi);
        PurInWarehsBillInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            virIdSet.add(info.getId().toString());
        }
        return virIdSet;
    }

    private void checkIsAllowInwUnAudit(Context ctx, IObjectPK pk, EntityViewInfo evi) throws BOSException {
        PurInWarehsBillCollection purInWarehsBillCollection = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillCollection(evi);
        if (purInWarehsBillCollection == null || purInWarehsBillCollection.size() <= 0) {
            return;
        }
        PurInWarehsBillInfo info = purInWarehsBillCollection.get(0);
        if (info.get("synStatus") != null && "0".equals(info.get("synStatus").toString())) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.nsrm.NSRMBizResource", (String)"MSG_NOT_UNAUDIT", (Locale)ctx.getLocale()));
        }
        this.addVirToContext(ctx, purInWarehsBillCollection);
        for (PurInWarehsEntryInfo next : info.getEntries()) {
            if (next.get("isContrastDrew") == null || !((Boolean)next.get("isContrastDrew")).booleanValue()) continue;
            throw new BOSException("\u5df2\u5bf9\u8d26\u5f00\u7968");
        }
    }

    private void addVirToContext(Context ctx, PurInWarehsBillCollection purInWarehsBillCollection) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < purInWarehsBillCollection.size(); ++i) {
            PurInWarehsBillInfo info1 = purInWarehsBillCollection.get(i);
            for (int j = 0; j < info1.getEntries().size(); ++j) {
                idSet.add(info1.getEntry().get(j).getId().toString());
            }
        }
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("parent.id"));
        filter1.getFilterItems().add(new FilterItemInfo("SOURCEBILLENTRYID", (Object)((Object)idSet).toString(), CompareType.INCLUDE));
        filter1.getFilterItems().add(new FilterItemInfo("parent.isSysBill", (Object)1, CompareType.EQUALS));
        evi1.setFilter(filter1);
        evi1.setSelector(sic1);
        PurInWarehsEntryCollection purInWarehsEntryCollection = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(evi1);
        HashSet<String> newIdSet = new HashSet<String>();
        for (int i = 0; i < purInWarehsEntryCollection.size(); ++i) {
            PurInWarehsEntryInfo entry = purInWarehsEntryCollection.get(i);
            newIdSet.add(entry.getParent().getId().toString());
        }
        EntityViewInfo newEvi = new EntityViewInfo();
        FilterInfo newFilter = new FilterInfo();
        SelectorItemCollection newSic = new SelectorItemCollection();
        newSic.add(new SelectorItemInfo("number"));
        newSic.add(new SelectorItemInfo("id"));
        newSic.add(new SelectorItemInfo("supplier.id"));
        newSic.add(new SelectorItemInfo("entry.sourceBillId"));
        newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)((Object)newIdSet).toString(), CompareType.INCLUDE));
        newEvi.setFilter(newFilter);
        newEvi.setSelector(newSic);
        PurInWarehsBillCollection col = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillCollection(newEvi);
        PurInWarehsBillInfo info = null;
        PurInWarehsBillCollection cols = null;
        logger.error((Object)"@@@@com.kingdee.eas.scm.nsrm.app.BizCheckFacadeControllerBean.addVirToContext:start--------");
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            info.put("type", (Object)1);
            String id = info.getEntry().get(0).getSourceBillId();
            cols = null == ctx.get((Object)id) ? new PurInWarehsBillCollection() : (PurInWarehsBillCollection)ctx.get((Object)id);
            cols.add(info);
            logger.error((Object)("@@@@com.kingdee.eas.scm.nsrm.app.BizCheckFacadeControllerBean.addVirToContext:" + info.getNumber()));
            ctx.put((Object)id, (Object)cols);
        }
        logger.error((Object)"@@@@com.kingdee.eas.scm.nsrm.app.BizCheckFacadeControllerBean.addVirToContext:end--------");
    }
}

