/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class OtherBillDeleteSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(OtherBillDeleteSend.class);
    private OtherBillCollection oldBillCol = null;
    private OtherBillCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (OtherBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getOtherBillCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@OtherBillAuditSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@OtherBillAuditSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@OtherBillAuditSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
        OtherBillInfo purInfo = null;
        OtherBillentryInfo entry = null;
        String supplierID = null;
        this.newBillCol = new OtherBillCollection();
        HashSet<String> oldSupplierIdSet = new HashSet<String>();
        Set<String> newSupplierIdSet = null;
        HashSet<String> orderSet = new HashSet<String>();
        String typeId = "YW3xsAEJEADgAAVEwKgTB0c4VZA=";
        int size = this.oldBillCol.size();
        for (int i = 0; i < size; ++i) {
            purInfo = this.oldBillCol.get(i);
            if (typeId.equals(purInfo.getAsstActType().getId().toString())) {
                supplierID = purInfo.getAsstActID().toString();
                oldSupplierIdSet.add(supplierID);
            }
            for (int j = 0; j < purInfo.getEntries().size(); ++j) {
                if (null == purInfo.getEntry().get(j).getCoreBillNumber()) continue;
                orderSet.add(purInfo.getEntry().get(j).getCoreBillNumber());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srmProgress"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("number", orderSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            orderMap.put(purOrderCollection.get(i).getNumber(), purOrderCollection.get(i).get("srmProgress"));
        }
        newSupplierIdSet = JudgeSupplierIsSrmUtil.getSupplierIsSrm(ctx, oldSupplierIdSet);
        if (newSupplierIdSet == null || newSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@OtherBillAuditSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        int size2 = this.oldBillCol.size();
        for (int i = 0; i < size2; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getAsstActID().toString();
            boolean issync = true;
            for (int j = 0; j < purInfo.getEntry().size(); ++j) {
                Object srmPorgress;
                entry = purInfo.getEntry().get(j);
                if (null == entry.getCoreBillNumber() || null != (srmPorgress = orderMap.get(entry.getCoreBillNumber())) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            if (!purInfo.getAsstActType().getId().toString().equals(typeId) || !newSupplierIdSet.contains(supplierID) || (!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(purInfo);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        return null;
    }
}

