/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.constant.SyncStatusConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentDeleteSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PaymentDeleteSend.class);
    private PaymentBillCollection oldBillCol = null;
    private PaymentBillCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entrys");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (PaymentBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPaymentBillCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PaymentDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PaymentDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@PaymentDeleteSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
        PaymentBillInfo purInfo = null;
        PaymentBillEntryInfo entry = null;
        String supplierID = null;
        this.newBillCol = new PaymentBillCollection();
        HashSet<String> oldSupplierIdSet = new HashSet<String>();
        Set<String> newSupplierIdSet = null;
        HashSet<String> orderSet = new HashSet<String>();
        int size = this.oldBillCol.size();
        for (int i = 0; i < size; ++i) {
            purInfo = this.oldBillCol.get(i);
            if (purInfo.getPayeeType() == null) continue;
            if ("T_BD_Supplier".equals(purInfo.getPayeeType().getRealtionDataObject()) && purInfo.getPayeeID() != null) {
                supplierID = purInfo.getPayeeID().toString();
                oldSupplierIdSet.add(supplierID);
            }
            for (int j = 0; j < purInfo.getEntries().size(); ++j) {
                if (null == purInfo.getEntries().get(j).getCoreBillNumber()) continue;
                orderSet.add(purInfo.getEntries().get(j).getCoreBillNumber());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srmProgress"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("number", orderSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            orderMap.put(purOrderCollection.get(i).getNumber(), purOrderCollection.get(i).get("srmProgress"));
        }
        if (oldSupplierIdSet == null || oldSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@PaymentDeleteSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        newSupplierIdSet = JudgeSupplierIsSrmUtil.getSupplierIsSrm(ctx, oldSupplierIdSet);
        if (newSupplierIdSet == null || newSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@PaymentDeleteSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        int size2 = this.oldBillCol.size();
        for (int i = 0; i < size2; ++i) {
            purInfo = this.oldBillCol.get(i);
            if (purInfo.getPayeeType() == null || purInfo.getPayeeID() == null) continue;
            boolean issync = true;
            for (int j = 0; j < purInfo.getEntries().size(); ++j) {
                Object srmPorgress;
                entry = purInfo.getEntries().get(j);
                if (null == entry.getCoreBillNumber() || null != (srmPorgress = orderMap.get(entry.getCoreBillNumber())) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            supplierID = purInfo.getPayeeID().toString();
            if (!"T_BD_Supplier".equals(purInfo.getPayeeType().getRealtionDataObject()) || !newSupplierIdSet.contains(supplierID) || (!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(purInfo);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
            Map dataMap = null;
            try {
                dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            }
            catch (Exception e) {
                return null;
            }
            if (!"200".equals(dataMap.get("code"))) {
                throw new BOSException((Throwable)((Object)new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL)));
            }
        } else {
            throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
        }
        SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_CAS_paymentbill");
        return null;
    }
}

