/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurOrderAlertDeleteSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurOrderAlertDeleteSend.class);
    private PurOrderCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = JudgeSupplierIsSrmUtil.getIsSrmFilterEVI(pks, null);
        try {
            this.newBillCol = (PurOrderCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurOrderCollection(ev);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            logger.debug((Object)"@@@@SendPurOrderExecutor.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol != null && this.newBillCol.size() == 0) {
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            String msg = ConvertUtil.convertObj2Str(retMap.get("msg"));
            if (returnData == null) {
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
            Map dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            if (!"200".equals(dataMap.get("code"))) {
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
        } else {
            throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
        }
        SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1");
        return null;
    }
}

