/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.SelectorFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaloutStcokSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(SaloutStcokSend.class);
    private IObjectCollection iObjectCollection = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, this.iObjectCollection, "entries");
        return this.iObjectCollection;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        SelectorItemCollection orderSic = SelectorFactory.getEntry2PurOrderSelector();
        orderSic.addObjectCollection((IObjectCollection)SelectorFactory.getPurOrderEntrySelector(""));
        SelectorItemCollection inwarehsSic = SelectorFactory.getPurInWarehsEntryNoEntrySelector();
        inwarehsSic.addObjectCollection((IObjectCollection)SelectorFactory.getEntry2PurInWarehsBillSelector());
        Object date = this.getDate(pks);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        ev.setSelector(orderSic);
        this.handOrderEntrys(ctx, qtyMap, pks);
        ev.setSelector(inwarehsSic);
        this.handInwarehsEntrys(ctx, qtyMap, ev, date);
        ev.getSelector().clear();
        ev.setSelector(orderSic);
        this.handUpdateOrderEntrys(ctx, qtyMap, ev, date);
        if (this.iObjectCollection == null || this.iObjectCollection.size() == 0) {
            logger.debug((Object)"@@@@SaloutStcokSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    private Object getDate(String[] pks) {
        String[] strs = new String[2];
        for (int i = 0; i < pks.length; ++i) {
            strs = pks[i].split("_");
            if (!"date".equals(strs[0])) continue;
            return strs[1];
        }
        return null;
    }

    private void handUpdateOrderEntrys(Context ctx, Map<String, BigDecimal> qtyMap, EntityViewInfo ev, Object date) throws BOSException {
        PurOrderEntryCollection orderEntrys = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(ev);
        if (qtyMap == null || qtyMap.size() <= 0) {
            return;
        }
        if (orderEntrys != null && orderEntrys.size() >= 0) {
            BigDecimal beforeQty = BigDecimal.ZERO;
            PurOrderEntryInfo entry = null;
            this.iObjectCollection = (IObjectCollection)orderEntrys.clone();
            this.iObjectCollection.clear();
            for (int i = 0; i < orderEntrys.size(); ++i) {
                entry = orderEntrys.get(i);
                beforeQty = entry.getTotalReceiveQty().subtract(entry.getTotalReceiptQty());
                if (null == beforeQty || beforeQty.compareTo(BigDecimal.ZERO) != 1) continue;
                entry.put("purorg", (Object)entry.getParent().getPurchaseOrgUnit().getNumber());
                entry.put("afterdate", date);
                entry.put("beforeqty", (Object)beforeQty);
                entry.put("org", (Object)entry.getStorageOrgUnit().getNumber().toString());
                entry.put("number", (Object)entry.getParent().getNumber().toString());
                this.iObjectCollection.addObject((IObjectValue)entry);
            }
        }
    }

    private void handInwarehsEntrys(Context ctx, Map<String, BigDecimal> qtyMap, EntityViewInfo ev, Object date) throws BOSException {
        PurInWarehsEntryCollection inwarehsEntrys = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(ev);
        if (inwarehsEntrys != null && inwarehsEntrys.size() >= 0) {
            BigDecimal beforeQty = BigDecimal.ZERO;
            BigDecimal orderBeforeQty = BigDecimal.ZERO;
            PurInWarehsEntryInfo entry = null;
            for (int i = 0; i < inwarehsEntrys.size(); ++i) {
                entry = inwarehsEntrys.get(i);
                if (entry.getSourceBillEntryId() != null) {
                    orderBeforeQty = qtyMap.get(entry.getSourceBillEntryId());
                    if (orderBeforeQty != null && orderBeforeQty.compareTo(BigDecimal.ZERO) == 1) {
                        beforeQty = orderBeforeQty.add(entry.getQty().subtract(entry.getWrittenOffQty()));
                        qtyMap.put(entry.getSourceBillEntryId().toString(), beforeQty);
                    } else {
                        beforeQty = entry.getQty().subtract(entry.getWrittenOffQty());
                    }
                } else {
                    beforeQty = entry.getQty().subtract(entry.getWrittenOffQty());
                }
                entry.put("beforeQty", (Object)beforeQty);
                entry.put("afterdate", date);
                entry.put("purorg", (Object)entry.getPurchaseOrgUnit().getNumber());
                entry.put("org", (Object)entry.getParent().getStorageOrgUnit().getNumber().toString());
                entry.put("number", (Object)entry.getPurOrderNumber());
            }
            if (qtyMap == null || qtyMap.size() <= 0) {
                this.iObjectCollection = (IObjectCollection)inwarehsEntrys.clone();
                this.iObjectCollection.clear();
                this.iObjectCollection.addObjectCollection((IObjectCollection)inwarehsEntrys);
            }
        }
    }

    private void handOrderEntrys(Context ctx, Map<String, BigDecimal> qtyMap, String[] pks) throws BOSException {
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        SelectorItemCollection orderSic = SelectorFactory.getPurOrderEntrySelector("");
        ev.setSelector(orderSic);
        PurOrderEntryCollection orderEntrys = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(ev);
        PurOrderEntryInfo entry = null;
        if (orderEntrys != null && orderEntrys.size() >= 0) {
            BigDecimal beforeQty = BigDecimal.ZERO;
            for (int i = 0; i < orderEntrys.size(); ++i) {
                entry = orderEntrys.get(i);
                beforeQty = entry.getTotalReceiveQty().subtract(entry.getTotalReceiptQty());
                if (beforeQty.compareTo(BigDecimal.ZERO) != 1) continue;
                qtyMap.put(entry.getId().toString(), beforeQty);
            }
        }
    }

    public void checkData(Context ctx) throws Exception {
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        return null;
    }
}

