/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class WareHouseHandSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(WareHouseHandSend.class);
    private WarehouseCollection oldBillCol = null;
    private WarehouseCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        LocationInfo info;
        int i;
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (WarehouseCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getWarehouseCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@WareHouseHandSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@WareHouseHandSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@WareHouseHandSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.oldBillCol.size(); ++i2) {
            WarehouseInfo info2 = this.oldBillCol.get(i2);
            if (!Boolean.valueOf(info2.get("hasLocation").toString()).booleanValue()) continue;
            idSet.add(info2.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Warehouse.number"));
        filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)((Object)idSet).toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("State", (Object)"1".toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("TransState", (Object)"1".toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        LocationCollection locationCollection = LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(evi);
        HashMap warehouseMap = new HashMap();
        for (i = 0; i < locationCollection.size(); ++i) {
            info = locationCollection.get(i);
            String warehouseNumber = info.getWarehouse().getNumber();
            if (warehouseMap.get(warehouseNumber) == null) {
                HashSet<String> set = new HashSet<String>();
                set.add(info.getNumber());
                warehouseMap.put(warehouseNumber, set);
                continue;
            }
            ((Set)warehouseMap.get(warehouseNumber)).add(info.getNumber().toString());
        }
        for (i = 0; i < this.oldBillCol.size(); ++i) {
            info = this.oldBillCol.get(i);
            Set numberSet = (Set)warehouseMap.get(info.getNumber());
            JSONArray json = JSONArray.fromObject((Object)numberSet);
            info.put("locations", (Object)json.toString());
        }
    }

    public void checkData(Context ctx) throws Exception {
        this.newBillCol = this.oldBillCol;
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        return null;
    }
}

